/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.server.zookeeper.tasks;

import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jobrunr.jobs.Job;
import org.jobrunr.jobs.RecurringJob;
import org.jobrunr.jobs.states.StateName;
import org.jobrunr.server.BackgroundJobServer;
import org.jobrunr.server.JobZooKeeper;
import org.jobrunr.server.zookeeper.tasks.ZooKeeperTask;
import org.jobrunr.storage.RecurringJobsResult;
import org.jobrunr.utils.CollectionUtils;

public class ProcessRecurringJobsTask
extends ZooKeeperTask {
    private final Map<String, Instant> recurringJobRuns = new HashMap<String, Instant>();
    private RecurringJobsResult recurringJobs = new RecurringJobsResult();

    public ProcessRecurringJobsTask(JobZooKeeper jobZooKeeper, BackgroundJobServer backgroundJobServer) {
        super(jobZooKeeper, backgroundJobServer);
    }

    @Override
    protected void runTask() {
        LOGGER.trace("Looking for recurring jobs... ");
        List<RecurringJob> recurringJobs = this.getRecurringJobs();
        this.processRecurringJobs(recurringJobs);
    }

    private List<RecurringJob> getRecurringJobs() {
        if (this.storageProvider.recurringJobsUpdated(this.recurringJobs.getLastModifiedHash())) {
            this.recurringJobs = this.storageProvider.getRecurringJobs();
        }
        return this.recurringJobs;
    }

    void processRecurringJobs(List<RecurringJob> recurringJobs) {
        LOGGER.debug("Found {} recurring jobs.", (Object)recurringJobs.size());
        Instant from = this.runStartTime();
        Instant upUntil = this.runStartTime().plusSeconds(this.backgroundJobServerConfiguration().getPollIntervalInSeconds());
        ArrayList<Job> allJobsToSchedule = new ArrayList<Job>();
        for (RecurringJob recurringJob : recurringJobs) {
            List<Job> jobsToSchedule = this.getJobsToSchedule(recurringJob, from, upUntil);
            if (jobsToSchedule.isEmpty()) {
                LOGGER.trace("Recurring job '{}' resulted in 0 scheduled job.", (Object)recurringJob.getJobName());
            } else if (jobsToSchedule.size() > 1) {
                LOGGER.info("Recurring job '{}' resulted in {} scheduled jobs. This means a long GC happened and JobRunr is catching up.", (Object)recurringJob.getJobName(), (Object)jobsToSchedule.size());
                allJobsToSchedule.addAll(jobsToSchedule);
            } else if (this.isAlreadyScheduledEnqueuedOrProcessing(recurringJob)) {
                LOGGER.debug("Recurring job '{}' is already scheduled, enqueued or processing. Run will be skipped as job is taking longer than given CronExpression or Interval.", (Object)recurringJob.getJobName());
            } else if (jobsToSchedule.size() == 1) {
                LOGGER.debug("Recurring job '{}' resulted in 1 scheduled job.", (Object)recurringJob.getJobName());
                allJobsToSchedule.addAll(jobsToSchedule);
            }
            this.registerRecurringJobRun(recurringJob, upUntil);
        }
        if (CollectionUtils.isNotNullOrEmpty(allJobsToSchedule)) {
            this.storageProvider.save(allJobsToSchedule);
        }
    }

    private List<Job> getJobsToSchedule(RecurringJob recurringJob, Instant runStartTime, Instant upUntil) {
        Instant lastRun = this.recurringJobRuns.getOrDefault(recurringJob.getId(), runStartTime);
        return recurringJob.toScheduledJobs(lastRun, upUntil);
    }

    private boolean isAlreadyScheduledEnqueuedOrProcessing(RecurringJob recurringJob) {
        return this.storageProvider.recurringJobExists(recurringJob.getId(), StateName.SCHEDULED, StateName.ENQUEUED, StateName.PROCESSING);
    }

    private void registerRecurringJobRun(RecurringJob recurringJob, Instant upUntil) {
        this.recurringJobRuns.put(recurringJob.getId(), upUntil);
    }
}

