/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.storage.nosql.common;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Random;
import java.util.stream.Stream;
import org.jobrunr.JobRunrException;
import org.jobrunr.storage.nosql.NoSqlStorageProvider;
import org.jobrunr.storage.nosql.common.NoSqlDatabaseMigrationsProvider;
import org.jobrunr.storage.nosql.common.migrations.NoSqlMigration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class NoSqlDatabaseCreator<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(NoSqlDatabaseCreator.class);
    private static Random randomTimeOnFailure = new Random();
    private final NoSqlDatabaseMigrationsProvider databaseMigrationsProvider;

    protected NoSqlDatabaseCreator(NoSqlStorageProvider noSqlStorageProvider) {
        this(noSqlStorageProvider.getClass());
    }

    protected NoSqlDatabaseCreator(Class<? extends NoSqlStorageProvider> noSqlStorageProviderClass) {
        this(Collections.singletonList(noSqlStorageProviderClass));
    }

    protected NoSqlDatabaseCreator(List<Class<? extends NoSqlStorageProvider>> noSqlStorageProviderClasses) {
        this.databaseMigrationsProvider = new NoSqlDatabaseMigrationsProvider(noSqlStorageProviderClasses);
    }

    public void runMigrations() {
        this.getMigrations().filter(this::isValidMigration).sorted(Comparator.comparing(NoSqlMigration::getClassName)).forEach(this::runMigrationIfNecessary);
    }

    protected boolean isValidMigration(NoSqlMigration noSqlMigration) {
        return true;
    }

    protected abstract boolean isNewMigration(NoSqlMigration var1);

    protected abstract void runMigration(T var1) throws Exception;

    protected abstract boolean markMigrationAsDone(NoSqlMigration var1);

    protected void runMigrationIfNecessary(NoSqlMigration noSqlMigration) {
        if (!this.isNewMigration(noSqlMigration)) {
            LOGGER.info("Skipping migration {} as it is already done", (Object)noSqlMigration);
        } else {
            LOGGER.info("Running migration {}", (Object)noSqlMigration);
            try {
                this.runMigration(noSqlMigration.getMigration());
                this.markMigrationAsDone(noSqlMigration);
            }
            catch (Exception exceptionCausedByConcurrentMigration) {
                try {
                    Thread.sleep(randomTimeOnFailure.nextInt(1000));
                    if (this.isNewMigration(noSqlMigration)) {
                        this.runMigration(noSqlMigration.getMigration());
                        this.markMigrationAsDone(noSqlMigration);
                    }
                }
                catch (Exception e) {
                    throw JobRunrException.shouldNotHappenException(new IllegalStateException("Error running database migration " + noSqlMigration.getClassName(), e));
                }
            }
        }
    }

    protected Stream<NoSqlMigration> getMigrations() {
        return this.databaseMigrationsProvider.getMigrations();
    }
}

