/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.storage.nosql.elasticsearch;

import java.io.IOException;
import java.time.Instant;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.client.indices.GetIndexRequest;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.json.JsonXContent;
import org.jobrunr.JobRunrException;
import org.jobrunr.storage.StorageException;
import org.jobrunr.storage.StorageProviderUtils;
import org.jobrunr.storage.nosql.NoSqlStorageProvider;
import org.jobrunr.storage.nosql.common.NoSqlDatabaseCreator;
import org.jobrunr.storage.nosql.common.migrations.NoSqlMigration;
import org.jobrunr.storage.nosql.elasticsearch.ElasticSearchUtils;
import org.jobrunr.storage.nosql.elasticsearch.migrations.ElasticSearchMigration;
import org.jobrunr.utils.CollectionUtils;
import org.jobrunr.utils.StringUtils;

public class ElasticSearchDBCreator
extends NoSqlDatabaseCreator<ElasticSearchMigration> {
    public static final String JOBRUNR_MIGRATIONS_INDEX_NAME = "jobrunr_migrations";
    private final RestHighLevelClient client;
    private final String indexPrefix;
    private final String migrationIndexName;

    public ElasticSearchDBCreator(NoSqlStorageProvider noSqlStorageProvider, RestHighLevelClient client, String indexPrefix) {
        super(noSqlStorageProvider);
        this.client = client;
        this.indexPrefix = indexPrefix;
        this.migrationIndexName = StorageProviderUtils.elementPrefixer(indexPrefix, JOBRUNR_MIGRATIONS_INDEX_NAME);
        ElasticSearchMigration.waitForHealthyCluster(client);
    }

    @Override
    public void runMigrations() {
        this.createMigrationsIndexIfNotExists();
        super.runMigrations();
    }

    public void validateIndices() {
        try {
            ElasticSearchMigration.waitForHealthyCluster(this.client);
            List<String> requiredIndexNames = Arrays.asList("jobs", "recurring_jobs", "background_job_servers", "metadata");
            Set<String> availableIndexNames = CollectionUtils.asSet(this.client.indices().get(new GetIndexRequest(new String[]{"*"}), RequestOptions.DEFAULT).getIndices());
            for (String requiredIndexName : requiredIndexNames) {
                if (availableIndexNames.contains(StorageProviderUtils.elementPrefixer(this.indexPrefix, StorageProviderUtils.elementPrefixer("jobrunr_", requiredIndexName)))) continue;
                throw new JobRunrException("Not all required indices are available by JobRunr!");
            }
        }
        catch (ElasticsearchStatusException e) {
            if (e.status() == RestStatus.NOT_FOUND) {
                throw new JobRunrException("Not all required indices are available by JobRunr!");
            }
            throw new StorageException(e);
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
    }

    private void createMigrationsIndexIfNotExists() {
        if (ElasticSearchMigration.indexExists(this.client, this.migrationIndexName)) {
            return;
        }
        ElasticSearchMigration.createIndex(this.client, this.migrationIndexName);
    }

    @Override
    protected boolean isNewMigration(NoSqlMigration noSqlMigration) {
        return this.isNewMigration(noSqlMigration, 0);
    }

    @Override
    protected void runMigration(ElasticSearchMigration noSqlMigration) throws IOException {
        noSqlMigration.runMigration(this.client, this.indexPrefix);
    }

    @Override
    protected boolean markMigrationAsDone(NoSqlMigration noSqlMigration) {
        try {
            XContentBuilder builder = JsonXContent.contentBuilder().prettyPrint();
            builder.startObject();
            builder.field("name", noSqlMigration.getClassName());
            builder.field("date", (Object)Instant.now());
            builder.endObject();
            IndexRequest indexRequest = ((IndexRequest)new IndexRequest(this.migrationIndexName).id(StringUtils.substringBefore(noSqlMigration.getClassName(), "_")).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source(builder);
            return this.client.index(indexRequest, RequestOptions.DEFAULT) != null;
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
    }

    private boolean isNewMigration(NoSqlMigration noSqlMigration, int retry) {
        ElasticSearchUtils.sleep((long)retry * 500L);
        try {
            ElasticSearchMigration.waitForHealthyCluster(this.client);
            GetResponse migration = this.client.get(new GetRequest(this.migrationIndexName, StringUtils.substringBefore(noSqlMigration.getClassName(), "_")), RequestOptions.DEFAULT);
            return !migration.isExists();
        }
        catch (ElasticsearchStatusException e) {
            if (retry < 5) {
                return this.isNewMigration(noSqlMigration, retry + 1);
            }
            if (e.status() == RestStatus.NOT_FOUND) {
                return true;
            }
            throw e;
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
    }
}

