/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.storage.nosql.elasticsearch.migrations;

import java.io.IOException;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.client.indices.CreateIndexRequest;
import org.jobrunr.storage.StorageProviderUtils;
import org.jobrunr.storage.nosql.elasticsearch.migrations.ElasticSearchMigration;

public class M001_CreateJobsIndex
extends ElasticSearchMigration {
    @Override
    public void runMigration(RestHighLevelClient client, String indexPrefix) throws IOException {
        String jobIndexName = StorageProviderUtils.elementPrefixer(indexPrefix, "jobrunr_jobs");
        if (M001_CreateJobsIndex.indexExists(client, jobIndexName)) {
            return;
        }
        M001_CreateJobsIndex.createIndex(client, M001_CreateJobsIndex.jobIndex(jobIndexName));
    }

    private static CreateIndexRequest jobIndex(String jobIndexName) {
        return new CreateIndexRequest(jobIndexName).mapping(M001_CreateJobsIndex.mapping((sb, map) -> {
            sb.append("jobAsJson");
            map.put("type", "text");
            map.put("index", false);
            map.put("store", true);
        }, (sb, map) -> {
            sb.append("state");
            map.put("type", "keyword");
        }, (sb, map) -> {
            sb.append("jobSignature");
            map.put("type", "keyword");
        }, (sb, map) -> {
            sb.append("scheduledAt");
            map.put("type", "date_nanos");
        }, (sb, map) -> {
            sb.append("updatedAt");
            map.put("type", "date_nanos");
        }));
    }
}

