/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.storage.nosql.elasticsearch.migrations;

import java.io.IOException;
import java.time.Instant;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.client.indices.CreateIndexRequest;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.json.JsonXContent;
import org.jobrunr.jobs.states.StateName;
import org.jobrunr.storage.StorageException;
import org.jobrunr.storage.StorageProviderUtils;
import org.jobrunr.storage.nosql.elasticsearch.migrations.ElasticSearchMigration;

public class M005_CreateMetadataIndexAndDropJobStatsIndex
extends ElasticSearchMigration {
    public static final String JOBRUNR_JOB_STATS = "jobrunr_job_stats";

    @Override
    public void runMigration(RestHighLevelClient client, String indexPrefix) throws IOException {
        String metadataIndexName = StorageProviderUtils.elementPrefixer(indexPrefix, "jobrunr_metadata");
        M005_CreateMetadataIndexAndDropJobStatsIndex.createIndex(client, M005_CreateMetadataIndexAndDropJobStatsIndex.metadataIndex(metadataIndexName));
        this.migrateExistingAllTimeSucceededFromJobStatsToMetadataAndDropJobStats(client, metadataIndexName);
    }

    private void migrateExistingAllTimeSucceededFromJobStatsToMetadataAndDropJobStats(RestHighLevelClient client, String metadataIndexName) throws IOException {
        long totalSucceededAmount = 0L;
        if (M005_CreateMetadataIndexAndDropJobStatsIndex.indexExists(client, JOBRUNR_JOB_STATS)) {
            GetResponse getResponse = client.get(new GetRequest(JOBRUNR_JOB_STATS, "job_stats"), RequestOptions.DEFAULT);
            totalSucceededAmount = ((Integer)((Object)getResponse.getSource().getOrDefault(StateName.SUCCEEDED.toString(), 0L))).intValue();
            this.deleteIndex(client, JOBRUNR_JOB_STATS);
        }
        client.index(M005_CreateMetadataIndexAndDropJobStatsIndex.jobStats(totalSucceededAmount, metadataIndexName), RequestOptions.DEFAULT);
    }

    public static IndexRequest jobStats(long totalSucceededAmount, String metadataIndexName) {
        try {
            XContentBuilder builder = JsonXContent.contentBuilder().prettyPrint();
            builder.startObject();
            builder.field("name", "succeeded-jobs-counter");
            builder.field("owner", "cluster");
            builder.field("value", totalSucceededAmount);
            builder.field("createdAt", (Object)Instant.now());
            builder.field("updatedAt", (Object)Instant.now());
            builder.endObject();
            return new IndexRequest(metadataIndexName).id("succeeded-jobs-counter-cluster").source(builder);
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
    }

    private static CreateIndexRequest metadataIndex(String metadataIndexName) {
        return new CreateIndexRequest(metadataIndexName).mapping(M005_CreateMetadataIndexAndDropJobStatsIndex.mapping((sb, map) -> {
            sb.append("name");
            map.put("type", "keyword");
        }, (sb, map) -> {
            sb.append("owner");
            map.put("type", "keyword");
        }, (sb, map) -> {
            sb.append("value");
            map.put("type", "text");
            map.put("index", false);
            map.put("store", true);
        }, (sb, map) -> {
            sb.append("createdAt");
            map.put("type", "date_nanos");
        }, (sb, map) -> {
            sb.append("updatedAt");
            map.put("type", "date_nanos");
        }));
    }
}

