/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.storage.nosql.elasticsearch.migrations;

import java.io.IOException;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.client.indices.PutMappingRequest;
import org.jobrunr.storage.StorageProviderUtils;
import org.jobrunr.storage.nosql.elasticsearch.migrations.ElasticSearchMigration;

public class M006_UpdateRecurringJobsIndex
extends ElasticSearchMigration {
    @Override
    public void runMigration(RestHighLevelClient client, String indexPrefix) throws IOException {
        String recurringJobIndexName = StorageProviderUtils.elementPrefixer(indexPrefix, "jobrunr_recurring_jobs");
        M006_UpdateRecurringJobsIndex.updateIndex(client, M006_UpdateRecurringJobsIndex.recurringJobIndex(recurringJobIndexName));
    }

    private static PutMappingRequest recurringJobIndex(String recurringJobIndexName) {
        return new PutMappingRequest(new String[]{recurringJobIndexName}).source(M006_UpdateRecurringJobsIndex.mapping((sb, map) -> {
            sb.append("createdAt");
            map.put("type", "long");
            map.put("index", false);
            map.put("store", true);
        }));
    }
}

