/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.storage.nosql.redis;

import io.lettuce.core.LettuceFutures;
import io.lettuce.core.Limit;
import io.lettuce.core.Range;
import io.lettuce.core.RedisClient;
import io.lettuce.core.RedisException;
import io.lettuce.core.RedisFuture;
import io.lettuce.core.TransactionResult;
import io.lettuce.core.api.StatefulRedisConnection;
import io.lettuce.core.api.async.RedisAsyncCommands;
import io.lettuce.core.api.sync.RedisCommands;
import io.lettuce.core.support.ConnectionPoolSupport;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.pool2.ObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.jobrunr.jobs.Job;
import org.jobrunr.jobs.JobDetails;
import org.jobrunr.jobs.JobListVersioner;
import org.jobrunr.jobs.JobVersioner;
import org.jobrunr.jobs.RecurringJob;
import org.jobrunr.jobs.mappers.JobMapper;
import org.jobrunr.jobs.states.ScheduledState;
import org.jobrunr.jobs.states.StateName;
import org.jobrunr.storage.AbstractStorageProvider;
import org.jobrunr.storage.BackgroundJobServerStatus;
import org.jobrunr.storage.ConcurrentJobModificationException;
import org.jobrunr.storage.JobNotFoundException;
import org.jobrunr.storage.JobRunrMetadata;
import org.jobrunr.storage.JobStats;
import org.jobrunr.storage.Page;
import org.jobrunr.storage.PageRequest;
import org.jobrunr.storage.RecurringJobsResult;
import org.jobrunr.storage.ServerTimedOutException;
import org.jobrunr.storage.StorageException;
import org.jobrunr.storage.StorageProviderUtils;
import org.jobrunr.storage.nosql.NoSqlStorageProvider;
import org.jobrunr.storage.nosql.redis.LettuceRedisDBCreator;
import org.jobrunr.storage.nosql.redis.LettuceRedisPipelinedStream;
import org.jobrunr.storage.nosql.redis.RedisUtilities;
import org.jobrunr.utils.JobUtils;
import org.jobrunr.utils.NumberUtils;
import org.jobrunr.utils.StringUtils;
import org.jobrunr.utils.annotations.Beta;
import org.jobrunr.utils.resilience.RateLimiter;

@Beta
public class LettuceRedisStorageProvider
extends AbstractStorageProvider
implements NoSqlStorageProvider {
    private final ObjectPool<StatefulRedisConnection<String, String>> pool;
    private final String keyPrefix;
    private JobMapper jobMapper;

    public LettuceRedisStorageProvider(RedisClient redisClient) {
        this(redisClient, RateLimiter.Builder.rateLimit().at1Request().per(RateLimiter.SECOND));
    }

    public LettuceRedisStorageProvider(RedisClient redisClient, RateLimiter changeListenerNotificationRateLimit) {
        this(redisClient, null, changeListenerNotificationRateLimit);
    }

    public LettuceRedisStorageProvider(RedisClient redisClient, String keyPrefix) {
        this(redisClient, keyPrefix, RateLimiter.Builder.rateLimit().at1Request().per(RateLimiter.SECOND));
    }

    public LettuceRedisStorageProvider(RedisClient redisClient, String keyPrefix, RateLimiter changeListenerNotificationRateLimit) {
        this((ObjectPool<StatefulRedisConnection<String, String>>)ConnectionPoolSupport.createGenericObjectPool(() -> ((RedisClient)redisClient).connect(), (GenericObjectPoolConfig)new GenericObjectPoolConfig()), keyPrefix, changeListenerNotificationRateLimit);
    }

    public LettuceRedisStorageProvider(ObjectPool<StatefulRedisConnection<String, String>> pool) {
        this(pool, null, RateLimiter.Builder.rateLimit().at1Request().per(RateLimiter.SECOND));
    }

    public LettuceRedisStorageProvider(ObjectPool<StatefulRedisConnection<String, String>> pool, String keyPrefix) {
        this(pool, keyPrefix, RateLimiter.Builder.rateLimit().at1Request().per(RateLimiter.SECOND));
    }

    public LettuceRedisStorageProvider(ObjectPool<StatefulRedisConnection<String, String>> pool, String keyPrefix, RateLimiter changeListenerNotificationRateLimit) {
        super(changeListenerNotificationRateLimit);
        this.pool = pool;
        this.keyPrefix = StringUtils.isNullOrEmpty(keyPrefix) ? "" : keyPrefix;
        this.setUpStorageProvider(StorageProviderUtils.DatabaseOptions.CREATE);
    }

    @Override
    public void setJobMapper(JobMapper jobMapper) {
        this.jobMapper = jobMapper;
    }

    @Override
    public void setUpStorageProvider(StorageProviderUtils.DatabaseOptions databaseOptions) {
        if (StorageProviderUtils.DatabaseOptions.CREATE != databaseOptions) {
            throw new IllegalArgumentException("LattuceRedisStorageProvider only supports CREATE as databaseOptions.");
        }
        new LettuceRedisDBCreator(this, this.pool, this.keyPrefix).runMigrations();
    }

    @Override
    public void announceBackgroundJobServer(BackgroundJobServerStatus serverStatus) {
        try (StatefulRedisConnection<String, String> connection = this.getConnection();){
            RedisCommands commands = connection.sync();
            commands.multi();
            commands.hset((Object)RedisUtilities.backgroundJobServerKey(this.keyPrefix, serverStatus), (Object)"id", (Object)serverStatus.getId().toString());
            commands.hset((Object)RedisUtilities.backgroundJobServerKey(this.keyPrefix, serverStatus), (Object)"name", (Object)serverStatus.getName());
            commands.hset((Object)RedisUtilities.backgroundJobServerKey(this.keyPrefix, serverStatus), (Object)"workerPoolSize", (Object)String.valueOf(serverStatus.getWorkerPoolSize()));
            commands.hset((Object)RedisUtilities.backgroundJobServerKey(this.keyPrefix, serverStatus), (Object)"pollIntervalInSeconds", (Object)String.valueOf(serverStatus.getPollIntervalInSeconds()));
            commands.hset((Object)RedisUtilities.backgroundJobServerKey(this.keyPrefix, serverStatus), (Object)"deleteSucceededJobsAfter", (Object)String.valueOf(serverStatus.getDeleteSucceededJobsAfter()));
            commands.hset((Object)RedisUtilities.backgroundJobServerKey(this.keyPrefix, serverStatus), (Object)"permanentlyDeleteDeletedJobsAfter", (Object)String.valueOf(serverStatus.getPermanentlyDeleteDeletedJobsAfter()));
            commands.hset((Object)RedisUtilities.backgroundJobServerKey(this.keyPrefix, serverStatus), (Object)"firstHeartbeat", (Object)String.valueOf(serverStatus.getFirstHeartbeat()));
            commands.hset((Object)RedisUtilities.backgroundJobServerKey(this.keyPrefix, serverStatus), (Object)"lastHeartbeat", (Object)String.valueOf(serverStatus.getLastHeartbeat()));
            commands.hset((Object)RedisUtilities.backgroundJobServerKey(this.keyPrefix, serverStatus), (Object)"running", (Object)String.valueOf(serverStatus.isRunning()));
            commands.hset((Object)RedisUtilities.backgroundJobServerKey(this.keyPrefix, serverStatus), (Object)"systemTotalMemory", (Object)String.valueOf(serverStatus.getSystemTotalMemory()));
            commands.hset((Object)RedisUtilities.backgroundJobServerKey(this.keyPrefix, serverStatus), (Object)"systemFreeMemory", (Object)String.valueOf(serverStatus.getSystemFreeMemory()));
            commands.hset((Object)RedisUtilities.backgroundJobServerKey(this.keyPrefix, serverStatus), (Object)"systemCpuLoad", (Object)String.valueOf(serverStatus.getSystemCpuLoad()));
            commands.hset((Object)RedisUtilities.backgroundJobServerKey(this.keyPrefix, serverStatus), (Object)"processMaxMemory", (Object)String.valueOf(serverStatus.getProcessMaxMemory()));
            commands.hset((Object)RedisUtilities.backgroundJobServerKey(this.keyPrefix, serverStatus), (Object)"processFreeMemory", (Object)String.valueOf(serverStatus.getProcessFreeMemory()));
            commands.hset((Object)RedisUtilities.backgroundJobServerKey(this.keyPrefix, serverStatus), (Object)"processAllocatedMemory", (Object)String.valueOf(serverStatus.getProcessAllocatedMemory()));
            commands.hset((Object)RedisUtilities.backgroundJobServerKey(this.keyPrefix, serverStatus), (Object)"processCpuLoad", (Object)String.valueOf(serverStatus.getProcessCpuLoad()));
            commands.zadd((Object)RedisUtilities.backgroundJobServersCreatedKey(this.keyPrefix), (double)RedisUtilities.toMicroSeconds(Instant.now()), (Object)serverStatus.getId().toString());
            commands.zadd((Object)RedisUtilities.backgroundJobServersUpdatedKey(this.keyPrefix), (double)RedisUtilities.toMicroSeconds(Instant.now()), (Object)serverStatus.getId().toString());
            commands.exec();
        }
    }

    @Override
    public boolean signalBackgroundJobServerAlive(BackgroundJobServerStatus serverStatus) {
        try (StatefulRedisConnection<String, String> connection = this.getConnection();){
            RedisCommands commands = connection.sync();
            Map valueMap = commands.hgetall((Object)RedisUtilities.backgroundJobServerKey(this.keyPrefix, serverStatus));
            if (valueMap.isEmpty()) {
                throw new ServerTimedOutException(serverStatus, new StorageException("BackgroundJobServer with id " + serverStatus.getId() + " was not found"));
            }
            commands.watch((Object[])new String[]{RedisUtilities.backgroundJobServerKey(this.keyPrefix, serverStatus)});
            commands.multi();
            commands.hset((Object)RedisUtilities.backgroundJobServerKey(this.keyPrefix, serverStatus), (Object)"lastHeartbeat", (Object)String.valueOf(serverStatus.getLastHeartbeat()));
            commands.hset((Object)RedisUtilities.backgroundJobServerKey(this.keyPrefix, serverStatus), (Object)"systemFreeMemory", (Object)String.valueOf(serverStatus.getSystemFreeMemory()));
            commands.hset((Object)RedisUtilities.backgroundJobServerKey(this.keyPrefix, serverStatus), (Object)"systemCpuLoad", (Object)String.valueOf(serverStatus.getSystemCpuLoad()));
            commands.hset((Object)RedisUtilities.backgroundJobServerKey(this.keyPrefix, serverStatus), (Object)"processFreeMemory", (Object)String.valueOf(serverStatus.getProcessFreeMemory()));
            commands.hset((Object)RedisUtilities.backgroundJobServerKey(this.keyPrefix, serverStatus), (Object)"processAllocatedMemory", (Object)String.valueOf(serverStatus.getProcessAllocatedMemory()));
            commands.hset((Object)RedisUtilities.backgroundJobServerKey(this.keyPrefix, serverStatus), (Object)"processCpuLoad", (Object)String.valueOf(serverStatus.getProcessCpuLoad()));
            commands.zadd((Object)RedisUtilities.backgroundJobServersUpdatedKey(this.keyPrefix), (double)RedisUtilities.toMicroSeconds(Instant.now()), (Object)serverStatus.getId().toString());
            commands.exec();
            boolean bl = Boolean.parseBoolean((String)commands.hget((Object)RedisUtilities.backgroundJobServerKey(this.keyPrefix, serverStatus), (Object)"running"));
            return bl;
        }
    }

    @Override
    public void signalBackgroundJobServerStopped(BackgroundJobServerStatus serverStatus) {
        try (StatefulRedisConnection<String, String> connection = this.getConnection();){
            RedisCommands commands = connection.sync();
            commands.multi();
            commands.del((Object[])new String[]{RedisUtilities.backgroundJobServerKey(this.keyPrefix, serverStatus.getId())});
            commands.zrem((Object)RedisUtilities.backgroundJobServersCreatedKey(this.keyPrefix), (Object[])new String[]{serverStatus.getId().toString()});
            commands.zrem((Object)RedisUtilities.backgroundJobServersUpdatedKey(this.keyPrefix), (Object[])new String[]{serverStatus.getId().toString()});
            commands.exec();
        }
    }

    @Override
    public List<BackgroundJobServerStatus> getBackgroundJobServers() {
        try (StatefulRedisConnection<String, String> connection = this.getConnection();){
            RedisCommands commands = connection.sync();
            List zrange = commands.zrange((Object)RedisUtilities.backgroundJobServersCreatedKey(this.keyPrefix), 0L, Integer.MAX_VALUE);
            List<BackgroundJobServerStatus> list = new LettuceRedisPipelinedStream<String>(zrange, connection).mapUsingPipeline((p, id) -> p.hgetall((Object)RedisUtilities.backgroundJobServerKey(this.keyPrefix, id))).mapAfterSync(Future::get).map(fieldMap -> new BackgroundJobServerStatus(UUID.fromString((String)fieldMap.get("id")), (String)fieldMap.get("name"), Integer.parseInt((String)fieldMap.get("workerPoolSize")), Integer.parseInt((String)fieldMap.get("pollIntervalInSeconds")), Duration.parse((CharSequence)fieldMap.get("deleteSucceededJobsAfter")), Duration.parse((CharSequence)fieldMap.get("permanentlyDeleteDeletedJobsAfter")), Instant.parse((CharSequence)fieldMap.get("firstHeartbeat")), Instant.parse((CharSequence)fieldMap.get("lastHeartbeat")), Boolean.parseBoolean((String)fieldMap.get("running")), NumberUtils.parseLong((String)fieldMap.get("systemTotalMemory")), NumberUtils.parseLong((String)fieldMap.get("systemFreeMemory")), Double.parseDouble((String)fieldMap.get("systemCpuLoad")), NumberUtils.parseLong((String)fieldMap.get("processMaxMemory")), NumberUtils.parseLong((String)fieldMap.get("processFreeMemory")), NumberUtils.parseLong((String)fieldMap.get("processAllocatedMemory")), Double.parseDouble((String)fieldMap.get("processCpuLoad")))).collect(Collectors.toList());
            return list;
        }
    }

    @Override
    public UUID getLongestRunningBackgroundJobServerId() {
        try (StatefulRedisConnection<String, String> connection = this.getConnection();){
            RedisCommands commands = connection.sync();
            UUID uUID = commands.zrange((Object)RedisUtilities.backgroundJobServersCreatedKey(this.keyPrefix), 0L, 1L).stream().map(UUID::fromString).findFirst().orElseThrow(() -> new IllegalStateException("No servers available?!"));
            return uUID;
        }
    }

    @Override
    public int removeTimedOutBackgroundJobServers(Instant heartbeatOlderThan) {
        try (StatefulRedisConnection<String, String> connection = this.getConnection();){
            RedisCommands commands = connection.sync();
            List backgroundJobServers = commands.zrangebyscore((Object)RedisUtilities.backgroundJobServersUpdatedKey(this.keyPrefix), Range.create((Object)0, (Object)RedisUtilities.toMicroSeconds(heartbeatOlderThan)));
            commands.multi();
            backgroundJobServers.forEach(backgroundJobServerId -> {
                commands.del((Object[])new String[]{RedisUtilities.backgroundJobServerKey(this.keyPrefix, backgroundJobServerId)});
                commands.zrem((Object)RedisUtilities.backgroundJobServersCreatedKey(this.keyPrefix), (Object[])new String[]{backgroundJobServerId});
                commands.zrem((Object)RedisUtilities.backgroundJobServersUpdatedKey(this.keyPrefix), (Object[])new String[]{backgroundJobServerId});
            });
            commands.exec();
            int n = backgroundJobServers.size();
            return n;
        }
    }

    @Override
    public void saveMetadata(JobRunrMetadata metadata) {
        try (StatefulRedisConnection<String, String> connection = this.getConnection();){
            RedisCommands commands = connection.sync();
            commands.multi();
            commands.hset((Object)RedisUtilities.metadataKey(this.keyPrefix, metadata), (Object)"id", (Object)metadata.getId());
            commands.hset((Object)RedisUtilities.metadataKey(this.keyPrefix, metadata), (Object)"name", (Object)metadata.getName());
            commands.hset((Object)RedisUtilities.metadataKey(this.keyPrefix, metadata), (Object)"owner", (Object)metadata.getOwner());
            commands.hset((Object)RedisUtilities.metadataKey(this.keyPrefix, metadata), (Object)"value", (Object)metadata.getValue());
            commands.hset((Object)RedisUtilities.metadataKey(this.keyPrefix, metadata), (Object)"createdAt", (Object)String.valueOf(metadata.getCreatedAt()));
            commands.hset((Object)RedisUtilities.metadataKey(this.keyPrefix, metadata), (Object)"updatedAt", (Object)String.valueOf(metadata.getUpdatedAt()));
            commands.sadd((Object)RedisUtilities.metadatasKey(this.keyPrefix), (Object[])new String[]{RedisUtilities.metadataKey(this.keyPrefix, metadata)});
            commands.exec();
            this.notifyMetadataChangeListeners();
        }
    }

    @Override
    public List<JobRunrMetadata> getMetadata(String name) {
        try (StatefulRedisConnection<String, String> connection = this.getConnection();){
            RedisCommands commands = connection.sync();
            List<JobRunrMetadata> list = commands.smembers((Object)RedisUtilities.metadatasKey(this.keyPrefix)).stream().filter(metadataName -> metadataName.startsWith(RedisUtilities.metadataKey(this.keyPrefix, name + "-"))).map(arg_0 -> ((RedisCommands)commands).hgetall(arg_0)).map(fieldMap -> new JobRunrMetadata((String)fieldMap.get("name"), (String)fieldMap.get("owner"), (String)fieldMap.get("value"), Instant.parse((CharSequence)fieldMap.get("createdAt")), Instant.parse((CharSequence)fieldMap.get("updatedAt")))).collect(Collectors.toList());
            return list;
        }
    }

    @Override
    public JobRunrMetadata getMetadata(String name, String owner) {
        try (StatefulRedisConnection<String, String> connection = this.getConnection();){
            RedisCommands commands = connection.sync();
            Map fieldMap = commands.hgetall((Object)RedisUtilities.metadataKey(this.keyPrefix, JobRunrMetadata.toId(name, owner)));
            if (fieldMap.isEmpty()) {
                JobRunrMetadata jobRunrMetadata = null;
                return jobRunrMetadata;
            }
            JobRunrMetadata jobRunrMetadata = new JobRunrMetadata((String)fieldMap.get("name"), (String)fieldMap.get("owner"), (String)fieldMap.get("value"), Instant.parse((CharSequence)fieldMap.get("createdAt")), Instant.parse((CharSequence)fieldMap.get("updatedAt")));
            return jobRunrMetadata;
        }
    }

    @Override
    public void deleteMetadata(String name) {
        try (StatefulRedisConnection<String, String> connection = this.getConnection();){
            RedisCommands commands = connection.sync();
            List<String> metadataToDelete = commands.smembers((Object)RedisUtilities.metadatasKey(this.keyPrefix)).stream().filter(metadataName -> metadataName.startsWith(RedisUtilities.metadataKey(this.keyPrefix, name + "-"))).collect(Collectors.toList());
            if (!metadataToDelete.isEmpty()) {
                commands.multi();
                metadataToDelete.forEach(metadataName -> {
                    commands.del((Object[])new String[]{metadataName});
                    commands.srem((Object)RedisUtilities.metadatasKey(this.keyPrefix), (Object[])new String[]{metadataName});
                });
                commands.exec();
                this.notifyMetadataChangeListeners();
            }
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public Job save(Job jobToSave) {
        try (StatefulRedisConnection<String, String> connection = this.getConnection();){
            JobVersioner jobVersioner = new JobVersioner(jobToSave);
            try {
                RedisCommands commands = connection.sync();
                if (jobVersioner.isNewJob()) {
                    this.insertJob(jobToSave, (RedisCommands<String, String>)commands);
                } else {
                    this.updateJob(jobToSave, (RedisCommands<String, String>)commands);
                }
                jobVersioner.commitVersion();
                this.notifyJobStatsOnChangeListeners();
                Job job = jobToSave;
                jobVersioner.close();
                return job;
            }
            catch (Throwable throwable) {
                try {
                    jobVersioner.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (RedisException e) {
            throw new StorageException(e);
        }
    }

    @Override
    public int deletePermanently(UUID id) {
        Job job = this.getJobById(id);
        try (StatefulRedisConnection<String, String> connection = this.getConnection();){
            RedisCommands commands = connection.sync();
            commands.multi();
            commands.del((Object[])new String[]{RedisUtilities.jobKey(this.keyPrefix, job)});
            commands.del((Object[])new String[]{RedisUtilities.jobVersionKey(this.keyPrefix, job)});
            this.deleteJobMetadata((RedisCommands<String, String>)commands, job);
            TransactionResult result = commands.exec();
            int amount = result == null || result.isEmpty() ? 0 : 1;
            this.notifyJobStatsOnChangeListenersIf(amount > 0);
            int n = amount;
            return n;
        }
    }

    @Override
    public Job getJobById(UUID id) {
        try (StatefulRedisConnection<String, String> connection = this.getConnection();){
            RedisCommands commands = connection.sync();
            Object serializedJob = commands.get((Object)RedisUtilities.jobKey(this.keyPrefix, id));
            if (serializedJob == null) {
                throw new JobNotFoundException(id);
            }
            Job job = this.jobMapper.deserializeJob(serializedJob.toString());
            return job;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<Job> save(List<Job> jobs) {
        if (jobs.isEmpty()) {
            return jobs;
        }
        try (StatefulRedisConnection<String, String> connection = this.getConnection();){
            JobListVersioner jobListVersioner = new JobListVersioner(jobs);
            try {
                RedisCommands commands = connection.sync();
                if (jobListVersioner.areNewJobs()) {
                    commands.multi();
                    jobs.forEach(jobToSave -> this.saveJob((RedisCommands<String, String>)commands, (Job)jobToSave));
                    commands.exec();
                } else {
                    List<Job> concurrentModifiedJobs = StorageProviderUtils.returnConcurrentModifiedJobs(jobs, job -> this.updateJob((Job)job, (RedisCommands<String, String>)commands));
                    if (!concurrentModifiedJobs.isEmpty()) {
                        jobListVersioner.rollbackVersions(concurrentModifiedJobs);
                        throw new ConcurrentJobModificationException(concurrentModifiedJobs);
                    }
                }
                jobListVersioner.commitVersions();
                this.notifyJobStatsOnChangeListenersIf(!jobs.isEmpty());
                List<Job> list = jobs;
                jobListVersioner.close();
                return list;
            }
            catch (Throwable throwable) {
                try {
                    jobListVersioner.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (RedisException e) {
            throw new StorageException(e);
        }
    }

    @Override
    public List<Job> getJobs(StateName state, Instant updatedBefore, PageRequest pageRequest) {
        try (StatefulRedisConnection<String, String> connection = this.getConnection();){
            List jobsByState;
            RedisCommands commands = connection.sync();
            if ("updatedAt:ASC".equals(pageRequest.getOrder())) {
                jobsByState = commands.zrangebyscore((Object)RedisUtilities.jobQueueForStateKey(this.keyPrefix, state), Range.create((Object)0, (Object)RedisUtilities.toMicroSeconds(updatedBefore)), Limit.create((long)pageRequest.getOffset(), (long)pageRequest.getLimit()));
            } else if ("updatedAt:DESC".equals(pageRequest.getOrder())) {
                jobsByState = commands.zrevrangebyscore((Object)RedisUtilities.jobQueueForStateKey(this.keyPrefix, state), Range.create((Object)0, (Object)RedisUtilities.toMicroSeconds(updatedBefore)), Limit.create((long)pageRequest.getOffset(), (long)pageRequest.getLimit()));
            } else {
                throw new IllegalArgumentException("Unsupported sorting: " + pageRequest.getOrder());
            }
            List<Job> list = new LettuceRedisPipelinedStream<String>(jobsByState, connection).mapUsingPipeline((p, id) -> p.get((Object)RedisUtilities.jobKey(this.keyPrefix, id))).mapAfterSync(Future::get).map(this.jobMapper::deserializeJob).collect(Collectors.toList());
            return list;
        }
    }

    @Override
    public List<Job> getScheduledJobs(Instant scheduledBefore, PageRequest pageRequest) {
        try (StatefulRedisConnection<String, String> connection = this.getConnection();){
            RedisCommands commands = connection.sync();
            List<Job> list = new LettuceRedisPipelinedStream<String>(commands.zrangebyscore((Object)RedisUtilities.scheduledJobsKey(this.keyPrefix), Range.create((Object)0, (Object)RedisUtilities.toMicroSeconds(Instant.now())), Limit.create((long)pageRequest.getOffset(), (long)pageRequest.getLimit())), connection).mapUsingPipeline((p, id) -> p.get((Object)RedisUtilities.jobKey(this.keyPrefix, id))).mapAfterSync(Future::get).map(this.jobMapper::deserializeJob).collect(Collectors.toList());
            return list;
        }
    }

    @Override
    public List<Job> getJobs(StateName state, PageRequest pageRequest) {
        try (StatefulRedisConnection<String, String> connection = this.getConnection();){
            List jobsByState;
            RedisCommands commands = connection.sync();
            if ("updatedAt:ASC".equals(pageRequest.getOrder())) {
                jobsByState = commands.zrange((Object)RedisUtilities.jobQueueForStateKey(this.keyPrefix, state), pageRequest.getOffset(), pageRequest.getOffset() + (long)pageRequest.getLimit() - 1L);
            } else if ("updatedAt:DESC".equals(pageRequest.getOrder())) {
                jobsByState = commands.zrevrange((Object)RedisUtilities.jobQueueForStateKey(this.keyPrefix, state), pageRequest.getOffset(), pageRequest.getOffset() + (long)pageRequest.getLimit() - 1L);
            } else {
                throw new IllegalArgumentException("Unsupported sorting: " + pageRequest.getOrder());
            }
            List<Job> list = new LettuceRedisPipelinedStream<String>(jobsByState, connection).mapUsingPipeline((p, id) -> p.get((Object)RedisUtilities.jobKey(this.keyPrefix, id))).mapAfterSync(Future::get).map(this.jobMapper::deserializeJob).collect(Collectors.toList());
            return list;
        }
    }

    @Override
    public Page<Job> getJobPage(StateName state, PageRequest pageRequest) {
        try (StatefulRedisConnection<String, String> connection = this.getConnection();){
            RedisCommands commands = connection.sync();
            long count = commands.zcount((Object)RedisUtilities.jobQueueForStateKey(this.keyPrefix, state), Range.unbounded());
            if (count > 0L) {
                List<Job> jobs = this.getJobs(state, pageRequest);
                Page<Job> page = new Page<Job>(count, jobs, pageRequest);
                return page;
            }
            Page<Job> page = new Page<Job>(0L, new ArrayList(), pageRequest);
            return page;
        }
    }

    @Override
    public int deleteJobsPermanently(StateName state, Instant updatedBefore) {
        int amount;
        block9: {
            amount = 0;
            try (StatefulRedisConnection<String, String> connection = this.getConnection();){
                RedisCommands commands = connection.sync();
                List zrangeToInspect = commands.zrange((Object)RedisUtilities.jobQueueForStateKey(this.keyPrefix, state), 0L, 1000L);
                while (!zrangeToInspect.isEmpty()) {
                    for (String id : zrangeToInspect) {
                        Job job = this.getJobById(UUID.fromString(id));
                        if (job.getUpdatedAt().isAfter(updatedBefore)) {
                            break block9;
                        }
                        commands.multi();
                        commands.del((Object[])new String[]{RedisUtilities.jobKey(this.keyPrefix, job)});
                        commands.del((Object[])new String[]{RedisUtilities.jobVersionKey(this.keyPrefix, job)});
                        this.deleteJobMetadata((RedisCommands<String, String>)commands, job);
                        TransactionResult exec = commands.exec();
                        if (exec == null || exec.isEmpty()) continue;
                        ++amount;
                    }
                    zrangeToInspect = commands.zrange((Object)RedisUtilities.jobQueueForStateKey(this.keyPrefix, state), 0L, 1000L);
                }
            }
        }
        this.notifyJobStatsOnChangeListenersIf(amount > 0);
        return amount;
    }

    @Override
    public Set<String> getDistinctJobSignatures(StateName ... states) {
        try (StatefulRedisConnection<String, String> connection = this.getConnection();){
            RedisCommands commands = connection.sync();
            List jobSignatures = Arrays.stream(states).map(stateName -> commands.smembers((Object)RedisUtilities.jobDetailsKey(this.keyPrefix, stateName))).collect(Collectors.toList());
            Set<String> set = jobSignatures.stream().flatMap(Collection::stream).collect(Collectors.toSet());
            return set;
        }
    }

    @Override
    public boolean exists(JobDetails jobDetails, StateName ... states) {
        try (StatefulRedisConnection<String, String> connection = this.getConnection();){
            RedisCommands commands = connection.sync();
            List existsJob = Arrays.stream(states).map(stateName -> commands.sismember((Object)RedisUtilities.jobDetailsKey(this.keyPrefix, stateName), (Object)JobUtils.getJobSignature(jobDetails))).collect(Collectors.toList());
            boolean bl = existsJob.stream().filter(b -> b).findAny().orElse(false);
            return bl;
        }
    }

    @Override
    public boolean recurringJobExists(String recurringJobId, StateName ... states) {
        try (StatefulRedisConnection<String, String> connection = this.getConnection();){
            RedisCommands commands = connection.sync();
            List existsJob = Arrays.stream(StateName.getStateNames(states)).map(stateName -> commands.sismember((Object)RedisUtilities.recurringJobKey(this.keyPrefix, stateName), (Object)recurringJobId)).collect(Collectors.toList());
            boolean bl = existsJob.stream().filter(b -> b).findAny().orElse(false);
            return bl;
        }
    }

    @Override
    public RecurringJob saveRecurringJob(RecurringJob recurringJob) {
        try (StatefulRedisConnection<String, String> connection = this.getConnection();){
            RedisCommands commands = connection.sync();
            commands.multi();
            commands.set((Object)RedisUtilities.recurringJobKey(this.keyPrefix, recurringJob.getId()), (Object)this.jobMapper.serializeRecurringJob(recurringJob));
            commands.sadd((Object)RedisUtilities.recurringJobsKey(this.keyPrefix), (Object[])new String[]{recurringJob.getId()});
            commands.hset((Object)RedisUtilities.recurringJobCreatedAtKey(this.keyPrefix), (Object)recurringJob.getId(), (Object)Long.toString(recurringJob.getCreatedAt().toEpochMilli()));
            commands.exec();
        }
        return recurringJob;
    }

    @Override
    public boolean recurringJobsUpdated(Long recurringJobsUpdatedHash) {
        try (StatefulRedisConnection<String, String> connection = this.getConnection();){
            RedisCommands commands = connection.sync();
            Long lastModifiedHash = commands.hvals((Object)RedisUtilities.recurringJobCreatedAtKey(this.keyPrefix)).stream().map(Long::valueOf).reduce(Long::sum).orElse(0L);
            boolean bl = !lastModifiedHash.equals(recurringJobsUpdatedHash);
            return bl;
        }
    }

    @Override
    public RecurringJobsResult getRecurringJobs() {
        try (StatefulRedisConnection<String, String> connection = this.getConnection();){
            RedisCommands commands = connection.sync();
            List<RecurringJob> recurringJobs = commands.smembers((Object)RedisUtilities.recurringJobsKey(this.keyPrefix)).stream().map(id -> (String)commands.get((Object)RedisUtilities.recurringJobKey(this.keyPrefix, id))).map(this.jobMapper::deserializeRecurringJob).collect(Collectors.toList());
            RecurringJobsResult recurringJobsResult = new RecurringJobsResult((Collection<RecurringJob>)recurringJobs);
            return recurringJobsResult;
        }
    }

    @Override
    public long countRecurringJobs() {
        try (StatefulRedisConnection<String, String> connection = this.getConnection();){
            long l = connection.sync().scard((Object)RedisUtilities.recurringJobsKey(this.keyPrefix));
            return l;
        }
    }

    @Override
    public int deleteRecurringJob(String id) {
        try (StatefulRedisConnection<String, String> connection = this.getConnection();){
            RedisCommands commands = connection.sync();
            commands.multi();
            commands.del((Object[])new String[]{RedisUtilities.recurringJobKey(this.keyPrefix, id)});
            commands.srem((Object)RedisUtilities.recurringJobsKey(this.keyPrefix), (Object[])new String[]{id});
            commands.hdel((Object)RedisUtilities.recurringJobCreatedAtKey(this.keyPrefix), (Object[])new String[]{id});
            TransactionResult exec = commands.exec();
            int n = exec != null && !exec.isEmpty() ? 1 : 0;
            return n;
        }
    }

    @Override
    public JobStats getJobStats() {
        Instant instant = Instant.now();
        try (StatefulRedisConnection<String, String> connection = this.getConnection();){
            connection.setAutoFlushCommands(false);
            RedisAsyncCommands commands = connection.async();
            RedisFuture totalSucceededAmountCounterResponse = commands.hget((Object)RedisUtilities.metadataKey(this.keyPrefix, "succeeded-jobs-counter-cluster"), (Object)"value");
            RedisFuture scheduledResponse = commands.zcount((Object)RedisUtilities.jobQueueForStateKey(this.keyPrefix, StateName.SCHEDULED), Range.unbounded());
            RedisFuture enqueuedResponse = commands.zcount((Object)RedisUtilities.jobQueueForStateKey(this.keyPrefix, StateName.ENQUEUED), Range.unbounded());
            RedisFuture processingResponse = commands.zcount((Object)RedisUtilities.jobQueueForStateKey(this.keyPrefix, StateName.PROCESSING), Range.unbounded());
            RedisFuture succeededResponse = commands.zcount((Object)RedisUtilities.jobQueueForStateKey(this.keyPrefix, StateName.SUCCEEDED), Range.unbounded());
            RedisFuture failedResponse = commands.zcount((Object)RedisUtilities.jobQueueForStateKey(this.keyPrefix, StateName.FAILED), Range.unbounded());
            RedisFuture deletedResponse = commands.zcount((Object)RedisUtilities.jobQueueForStateKey(this.keyPrefix, StateName.DELETED), Range.unbounded());
            RedisFuture recurringJobsResponse = commands.scard((Object)RedisUtilities.recurringJobsKey(this.keyPrefix));
            RedisFuture backgroundJobServerResponse = commands.zcount((Object)RedisUtilities.backgroundJobServersUpdatedKey(this.keyPrefix), Range.unbounded());
            connection.flushCommands();
            LettuceFutures.awaitAll((Duration)Duration.ofSeconds(10L), (Future[])new Future[]{totalSucceededAmountCounterResponse, scheduledResponse, enqueuedResponse, processingResponse, succeededResponse, failedResponse, deletedResponse});
            long scheduledCount = this.getCounterValue((RedisFuture<Long>)scheduledResponse);
            long enqueuedCount = this.getCounterValue((RedisFuture<Long>)enqueuedResponse);
            long processingCount = this.getCounterValue((RedisFuture<Long>)processingResponse);
            long succeededCount = this.getCounterValue((RedisFuture<Long>)succeededResponse);
            long allTimeSucceededCount = this.getAllTimeSucceededCounterValue((RedisFuture<String>)totalSucceededAmountCounterResponse);
            long failedCount = this.getCounterValue((RedisFuture<Long>)failedResponse);
            long deletedCount = this.getCounterValue((RedisFuture<Long>)deletedResponse);
            long total = scheduledCount + enqueuedCount + processingCount + succeededCount + failedCount;
            long recurringJobsCount = this.getCounterValue((RedisFuture<Long>)recurringJobsResponse);
            long backgroundJobServerCount = this.getCounterValue((RedisFuture<Long>)backgroundJobServerResponse);
            JobStats jobStats = new JobStats(instant, total, scheduledCount, enqueuedCount, processingCount, failedCount, succeededCount, allTimeSucceededCount, deletedCount, (int)recurringJobsCount, (int)backgroundJobServerCount);
            return jobStats;
        }
    }

    @Override
    public void publishTotalAmountOfSucceededJobs(int amount) {
        try (StatefulRedisConnection<String, String> connection = this.getConnection();){
            RedisCommands commands = connection.sync();
            commands.hincrby((Object)RedisUtilities.metadataKey(this.keyPrefix, "succeeded-jobs-counter-cluster"), (Object)"value", (long)amount);
        }
    }

    @Override
    public void close() {
        super.close();
        this.pool.close();
    }

    private void insertJob(Job jobToSave, RedisCommands<String, String> commands) {
        if (commands.exists((Object[])new String[]{RedisUtilities.jobKey(this.keyPrefix, jobToSave)}) > 0L) {
            throw new ConcurrentJobModificationException(jobToSave);
        }
        commands.multi();
        this.saveJob(commands, jobToSave);
        TransactionResult result = commands.exec();
        if (result.wasDiscarded()) {
            throw new StorageException("Unable to save job " + jobToSave.getId() + " with version " + jobToSave.getVersion());
        }
    }

    private void updateJob(Job jobToSave, RedisCommands<String, String> commands) {
        commands.watch((Object[])new String[]{RedisUtilities.jobVersionKey(this.keyPrefix, jobToSave)});
        String versionAsString = (String)commands.get((Object)RedisUtilities.jobVersionKey(this.keyPrefix, jobToSave));
        if (versionAsString == null || Integer.parseInt(versionAsString) != jobToSave.getVersion() - 1) {
            throw new ConcurrentJobModificationException(jobToSave);
        }
        commands.multi();
        this.saveJob(commands, jobToSave);
        TransactionResult result = commands.exec();
        if (result == null || result.isEmpty()) {
            throw new ConcurrentJobModificationException(jobToSave);
        }
    }

    private void saveJob(RedisCommands<String, String> commands, Job jobToSave) {
        this.deleteJobMetadataForUpdate(commands, jobToSave);
        commands.set((Object)RedisUtilities.jobVersionKey(this.keyPrefix, jobToSave), (Object)String.valueOf(jobToSave.getVersion()));
        commands.set((Object)RedisUtilities.jobKey(this.keyPrefix, jobToSave), (Object)this.jobMapper.serializeJob(jobToSave));
        commands.zadd((Object)RedisUtilities.jobQueueForStateKey(this.keyPrefix, jobToSave.getState()), (double)RedisUtilities.toMicroSeconds(jobToSave.getUpdatedAt()), (Object)jobToSave.getId().toString());
        commands.sadd((Object)RedisUtilities.jobDetailsKey(this.keyPrefix, jobToSave.getState()), (Object[])new String[]{JobUtils.getJobSignature(jobToSave.getJobDetails())});
        if (StateName.SCHEDULED.equals((Object)jobToSave.getState())) {
            commands.zadd((Object)RedisUtilities.scheduledJobsKey(this.keyPrefix), (double)RedisUtilities.toMicroSeconds(((ScheduledState)jobToSave.getJobState()).getScheduledAt()), (Object)jobToSave.getId().toString());
        }
        jobToSave.getRecurringJobId().ifPresent(recurringJobId -> commands.sadd((Object)RedisUtilities.recurringJobKey(this.keyPrefix, jobToSave.getState()), (Object[])new String[]{recurringJobId}));
    }

    private void deleteJobMetadataForUpdate(RedisCommands<String, String> commands, Job job) {
        String id = job.getId().toString();
        commands.zrem((Object)RedisUtilities.scheduledJobsKey(this.keyPrefix), (Object[])new String[]{id});
        Stream.of(StateName.values()).forEach(stateName -> commands.zrem((Object)RedisUtilities.jobQueueForStateKey(this.keyPrefix, stateName), (Object[])new String[]{id}));
        Stream.of(StateName.values()).filter(stateName -> !StateName.SCHEDULED.equals(stateName)).forEach(stateName -> commands.srem((Object)RedisUtilities.jobDetailsKey(this.keyPrefix, stateName), (Object[])new String[]{JobUtils.getJobSignature(job.getJobDetails())}));
        if (job.hasState(StateName.ENQUEUED) && job.getJobStates().size() >= 2 && job.getJobState(-2) instanceof ScheduledState || job.hasState(StateName.DELETED) && job.getJobStates().size() >= 2 && job.getJobState(-2) instanceof ScheduledState) {
            commands.srem((Object)RedisUtilities.jobDetailsKey(this.keyPrefix, StateName.SCHEDULED), (Object[])new String[]{JobUtils.getJobSignature(job.getJobDetails())});
        }
        job.getRecurringJobId().ifPresent(recurringJobId -> Stream.of(StateName.values()).forEach(stateName -> commands.srem((Object)RedisUtilities.recurringJobKey(this.keyPrefix, stateName), (Object[])new String[]{recurringJobId})));
    }

    private void deleteJobMetadata(RedisCommands<String, String> commands, Job job) {
        String id = job.getId().toString();
        commands.zrem((Object)RedisUtilities.scheduledJobsKey(this.keyPrefix), (Object[])new String[]{id});
        Stream.of(StateName.values()).forEach(stateName -> commands.zrem((Object)RedisUtilities.jobQueueForStateKey(this.keyPrefix, stateName), (Object[])new String[]{id}));
        Stream.of(StateName.values()).forEach(stateName -> commands.srem((Object)RedisUtilities.jobDetailsKey(this.keyPrefix, stateName), (Object[])new String[]{JobUtils.getJobSignature(job.getJobDetails())}));
        job.getRecurringJobId().ifPresent(recurringJobId -> Stream.of(StateName.values()).forEach(stateName -> commands.srem((Object)RedisUtilities.recurringJobKey(this.keyPrefix, stateName), (Object[])new String[]{recurringJobId})));
    }

    private long getCounterValue(RedisFuture<Long> countResponse) {
        try {
            return (Long)countResponse.get();
        }
        catch (InterruptedException | ExecutionException e) {
            Thread.currentThread().interrupt();
            return 0L;
        }
    }

    private long getAllTimeSucceededCounterValue(RedisFuture<String> allTimeSucceededAmountCounterResponse) {
        try {
            return NumberUtils.parseLong((String)allTimeSucceededAmountCounterResponse.get());
        }
        catch (InterruptedException | ExecutionException e) {
            Thread.currentThread().interrupt();
            return 0L;
        }
    }

    protected StatefulRedisConnection<String, String> getConnection() {
        try {
            StatefulRedisConnection statefulRedisConnection = (StatefulRedisConnection)this.pool.borrowObject();
            statefulRedisConnection.setAutoFlushCommands(true);
            return statefulRedisConnection;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }
}

