/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.storage.sql.common;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.LocalDateTime;
import java.util.Comparator;
import java.util.UUID;
import java.util.stream.Stream;
import javax.sql.DataSource;
import org.jobrunr.JobRunrException;
import org.jobrunr.storage.sql.SqlStorageProvider;
import org.jobrunr.storage.sql.common.DatabaseMigrationsProvider;
import org.jobrunr.storage.sql.common.SqlStorageProviderFactory;
import org.jobrunr.storage.sql.common.db.Transaction;
import org.jobrunr.storage.sql.common.migrations.SqlMigration;
import org.jobrunr.storage.sql.common.tables.AnsiDatabaseTablePrefixStatementUpdater;
import org.jobrunr.storage.sql.common.tables.NoOpTablePrefixStatementUpdater;
import org.jobrunr.storage.sql.common.tables.OracleAndDB2TablePrefixStatementUpdater;
import org.jobrunr.storage.sql.common.tables.SqlServerDatabaseTablePrefixStatementUpdater;
import org.jobrunr.storage.sql.common.tables.TablePrefixStatementUpdater;
import org.jobrunr.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseCreator {
    private static final Logger LOGGER = LoggerFactory.getLogger(DatabaseCreator.class);
    private static final String[] JOBRUNR_TABLES = new String[]{"jobrunr_jobs", "jobrunr_recurring_jobs", "jobrunr_backgroundjobservers", "jobrunr_metadata"};
    private final ConnectionProvider connectionProvider;
    private final TablePrefixStatementUpdater tablePrefixStatementUpdater;
    private final DatabaseMigrationsProvider databaseMigrationsProvider;

    public static void main(String[] args) {
        if (args.length < 3) {
            System.out.println("Error: insufficient arguments");
            System.out.println();
            System.out.println("usage: java -cp jobrunr-${jobrunr.version}.jar org.jobrunr.storage.sql.common.DatabaseCreator {jdbcUrl} {userName} {password} ({tablePrefix})");
            return;
        }
        String url = args[0];
        String userName = args[1];
        String password = args[2];
        String tablePrefix = args.length >= 4 ? args[3] : null;
        try {
            System.out.println("==========================================================");
            System.out.println("================== JobRunr Table Creator =================");
            System.out.println("==========================================================");
            new DatabaseCreator(() -> DriverManager.getConnection(url, userName, password), tablePrefix, new SqlStorageProviderFactory().getStorageProviderClassByJdbcUrl(url)).runMigrations();
            System.out.println("Successfully created all tables!");
        }
        catch (Exception e) {
            System.out.println("An error occurred: ");
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            String exceptionAsString = sw.toString();
            System.out.println(exceptionAsString);
        }
    }

    protected DatabaseCreator(DataSource dataSource) {
        this(dataSource, null, null);
    }

    protected DatabaseCreator(DataSource dataSource, String tablePrefix) {
        this(dataSource, tablePrefix, null);
    }

    public DatabaseCreator(DataSource dataSource, Class<? extends SqlStorageProvider> sqlStorageProviderClass) {
        this(dataSource::getConnection, null, sqlStorageProviderClass);
    }

    public DatabaseCreator(DataSource dataSource, String tablePrefix, Class<? extends SqlStorageProvider> sqlStorageProviderClass) {
        this(dataSource::getConnection, tablePrefix, sqlStorageProviderClass);
    }

    public DatabaseCreator(ConnectionProvider connectionProvider, String tablePrefix, Class<? extends SqlStorageProvider> sqlStorageProviderClass) {
        this.connectionProvider = connectionProvider;
        this.tablePrefixStatementUpdater = this.getStatementUpdater(tablePrefix, connectionProvider);
        this.databaseMigrationsProvider = new DatabaseMigrationsProvider(sqlStorageProviderClass);
    }

    public void runMigrations() {
        this.getMigrations().filter(migration -> migration.getFileName().endsWith(".sql")).sorted(Comparator.comparing(SqlMigration::getFileName)).filter(this::isNewMigration).forEach(this::runMigration);
    }

    public void validateTables() {
        try (Connection conn = this.getConnection();
             Transaction tran = new Transaction(conn, false);
             Statement pSt = conn.createStatement();){
            for (String table : JOBRUNR_TABLES) {
                try (ResultSet rs = pSt.executeQuery("select count(*) from " + this.tablePrefixStatementUpdater.getFQTableName(table));){
                    if (!rs.next()) continue;
                    int n = rs.getInt(1);
                }
            }
            tran.commit();
        }
        catch (Exception becauseTableDoesNotExist) {
            throw new JobRunrException("Not all required tables are available by JobRunr!");
        }
    }

    protected Stream<SqlMigration> getMigrations() {
        return this.databaseMigrationsProvider.getMigrations();
    }

    protected void runMigration(SqlMigration migration) {
        LOGGER.info("Running migration {}", (Object)migration);
        try (Connection conn = this.getConnection();
             Transaction tran = new Transaction(conn, false);){
            if (!this.isEmptyMigration(migration)) {
                this.runMigrationStatement(conn, migration);
            }
            this.updateMigrationsTable(conn, migration);
            tran.commit();
        }
        catch (Exception e) {
            throw JobRunrException.shouldNotHappenException(new IllegalStateException("Error running database migration " + migration.getFileName(), e));
        }
    }

    private boolean isEmptyMigration(SqlMigration migration) throws IOException {
        return migration.getMigrationSql().startsWith("-- Empty migration");
    }

    protected void runMigrationStatement(Connection connection, SqlMigration migration) throws IOException, SQLException {
        String sql = migration.getMigrationSql();
        for (String statement : sql.split(";")) {
            try (Statement stmt = connection.createStatement();){
                stmt.execute(this.tablePrefixStatementUpdater.updateStatement(statement).trim());
            }
        }
    }

    protected void updateMigrationsTable(Connection connection, SqlMigration migration) throws SQLException {
        try (PreparedStatement pSt = connection.prepareStatement("insert into " + this.tablePrefixStatementUpdater.getFQTableName("jobrunr_migrations") + " values (?, ?, ?)");){
            pSt.setString(1, UUID.randomUUID().toString());
            pSt.setString(2, migration.getFileName());
            pSt.setString(3, LocalDateTime.now().toString());
            pSt.execute();
        }
    }

    private boolean isNewMigration(SqlMigration migration) {
        return !this.isMigrationApplied(migration);
    }

    /*
     * Exception decompiling
     */
    protected boolean isMigrationApplied(SqlMigration migration) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Connection getConnection() {
        try {
            return this.connectionProvider.getConnection();
        }
        catch (SQLException exception) {
            throw JobRunrException.shouldNotHappenException(exception);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private TablePrefixStatementUpdater getStatementUpdater(String tablePrefix, ConnectionProvider connectionProvider) {
        try {
            if (StringUtils.isNullOrEmpty(tablePrefix)) {
                return new NoOpTablePrefixStatementUpdater();
            }
            try (Connection connection = connectionProvider.getConnection();){
                String databaseProductName = connection.getMetaData().getDatabaseProductName();
                if ("Oracle".equals(databaseProductName) || databaseProductName.startsWith("DB2")) {
                    OracleAndDB2TablePrefixStatementUpdater oracleAndDB2TablePrefixStatementUpdater = new OracleAndDB2TablePrefixStatementUpdater(tablePrefix);
                    return oracleAndDB2TablePrefixStatementUpdater;
                }
                if ("Microsoft SQL Server".equals(databaseProductName)) {
                    SqlServerDatabaseTablePrefixStatementUpdater sqlServerDatabaseTablePrefixStatementUpdater = new SqlServerDatabaseTablePrefixStatementUpdater(tablePrefix);
                    return sqlServerDatabaseTablePrefixStatementUpdater;
                }
                AnsiDatabaseTablePrefixStatementUpdater ansiDatabaseTablePrefixStatementUpdater = new AnsiDatabaseTablePrefixStatementUpdater(tablePrefix);
                return ansiDatabaseTablePrefixStatementUpdater;
            }
        }
        catch (SQLException e) {
            throw JobRunrException.shouldNotHappenException(e);
        }
    }

    @FunctionalInterface
    private static interface ConnectionProvider {
        public Connection getConnection() throws SQLException;
    }
}

