/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.storage.sql.common;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.stream.Collectors;
import org.jobrunr.jobs.RecurringJob;
import org.jobrunr.jobs.mappers.JobMapper;
import org.jobrunr.storage.sql.common.db.Sql;
import org.jobrunr.storage.sql.common.db.SqlResultSet;
import org.jobrunr.storage.sql.common.db.dialect.Dialect;

public class RecurringJobTable
extends Sql<RecurringJob> {
    private final JobMapper jobMapper;

    public RecurringJobTable(Connection connection, Dialect dialect, String tablePrefix, JobMapper jobMapper) {
        this.jobMapper = jobMapper;
        this.using(connection, dialect, tablePrefix, "jobrunr_recurring_jobs").with("jobAsJson", jobMapper::serializeRecurringJob).with("createdAt", (T recurringJob) -> recurringJob.getCreatedAt().toEpochMilli());
    }

    public RecurringJobTable withId(String id) {
        this.with("id", id);
        return this;
    }

    public RecurringJob save(RecurringJob recurringJob) throws SQLException {
        this.withId(recurringJob.getId());
        if (this.selectExists("from jobrunr_recurring_jobs where id = :id")) {
            this.update(recurringJob, "jobrunr_recurring_jobs SET jobAsJson = :jobAsJson, createdAt = :createdAt WHERE id = :id");
        } else {
            this.insert(recurringJob, "into jobrunr_recurring_jobs values(:id, 1, :jobAsJson, :createdAt)");
        }
        return recurringJob;
    }

    public List<RecurringJob> selectAll() {
        return this.select("jobAsJson from jobrunr_recurring_jobs").map(this::toRecurringJob).collect(Collectors.toList());
    }

    public long count() throws SQLException {
        return this.selectCount("from jobrunr_recurring_jobs");
    }

    public int deleteById(String id) throws SQLException {
        return this.withId(id).delete("from jobrunr_recurring_jobs where id = :id");
    }

    private RecurringJob toRecurringJob(SqlResultSet resultSet) {
        return this.jobMapper.deserializeRecurringJob(resultSet.asString("jobAsJson"));
    }
}

