/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.storage.sql.mariadb;

import java.sql.Connection;
import java.sql.SQLException;
import java.time.Instant;
import javax.sql.DataSource;
import org.jobrunr.storage.BackgroundJobServerStatus;
import org.jobrunr.storage.StorageProviderUtils;
import org.jobrunr.storage.sql.common.DefaultSqlStorageProvider;
import org.jobrunr.storage.sql.common.db.dialect.AnsiDialect;
import org.jobrunr.storage.sql.common.db.dialect.Dialect;
import org.jobrunr.utils.exceptions.Exceptions;

public class MariaDbStorageProvider
extends DefaultSqlStorageProvider {
    public MariaDbStorageProvider(DataSource dataSource) {
        this(dataSource, StorageProviderUtils.DatabaseOptions.CREATE);
    }

    public MariaDbStorageProvider(DataSource dataSource, String tablePrefix) {
        this(dataSource, tablePrefix, StorageProviderUtils.DatabaseOptions.CREATE);
    }

    public MariaDbStorageProvider(DataSource dataSource, StorageProviderUtils.DatabaseOptions databaseOptions) {
        this(dataSource, (String)null, databaseOptions);
    }

    public MariaDbStorageProvider(DataSource dataSource, String tablePrefix, StorageProviderUtils.DatabaseOptions databaseOptions) {
        super(dataSource, (Dialect)new AnsiDialect(), tablePrefix, databaseOptions);
        try (Connection connection = dataSource.getConnection();){
            String url;
            String driverName = connection.getMetaData().getDriverName();
            int driverMajorVersion = connection.getMetaData().getDriverMajorVersion();
            if (driverName.toLowerCase().contains("mariadb") && driverMajorVersion >= 3 && !(url = connection.getMetaData().getURL()).contains("useBulkStmts=false")) {
                throw new IllegalStateException("JobRunr requires a MariaDB connection with useBulkStmts=false as otherwise optimistic locking cannot be validated.");
            }
        }
        catch (SQLException e) {
            throw new RuntimeException("Could not query MariaDB driver", e);
        }
    }

    @Override
    public void announceBackgroundJobServer(BackgroundJobServerStatus serverStatus) {
        Exceptions.retryOnException(() -> super.announceBackgroundJobServer(serverStatus), 5);
    }

    @Override
    public int removeTimedOutBackgroundJobServers(Instant heartbeatOlderThan) {
        return Exceptions.retryOnException(() -> super.removeTimedOutBackgroundJobServers(heartbeatOlderThan), 5);
    }

    @Override
    public boolean signalBackgroundJobServerAlive(BackgroundJobServerStatus serverStatus) {
        return Exceptions.retryOnException(() -> super.signalBackgroundJobServerAlive(serverStatus), 5);
    }

    @Override
    public void signalBackgroundJobServerStopped(BackgroundJobServerStatus serverStatus) {
        Exceptions.retryOnException(() -> super.signalBackgroundJobServerStopped(serverStatus), 5);
    }
}

