/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.utils.mapper.gson;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.lang.reflect.Type;
import org.jobrunr.jobs.JobParameter;
import org.jobrunr.jobs.JobParameterNotDeserializableException;
import org.jobrunr.utils.mapper.JsonMapperUtils;
import org.jobrunr.utils.reflection.ReflectionUtils;

public class JobParameterDeserializer
implements JsonDeserializer<JobParameter> {
    public JobParameter deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext context) {
        JsonObject jsonObject = jsonElement.getAsJsonObject();
        String jobParameterMethodType = jsonObject.get("className").getAsString();
        String jobParameterActualType = jsonObject.has("actualClassName") ? jsonObject.get("actualClassName").getAsString() : null;
        try {
            return new JobParameter(jobParameterMethodType, this.deserializeToObject(context, JsonMapperUtils.getActualClassName(jobParameterMethodType, jobParameterActualType), jsonObject.get("object")));
        }
        catch (Exception e) {
            return new JobParameter(new JobParameterNotDeserializableException(JsonMapperUtils.getActualClassName(jobParameterMethodType, jobParameterActualType), e.getMessage()));
        }
    }

    private Object deserializeToObject(JsonDeserializationContext context, String type, JsonElement jsonElement) {
        return context.deserialize(jsonElement, ReflectionUtils.toClass(type));
    }
}

