/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.utils.mapper.jsonb;

import java.io.OutputStream;
import javax.json.bind.Jsonb;
import javax.json.bind.JsonbBuilder;
import javax.json.bind.JsonbConfig;
import javax.json.bind.JsonbException;
import javax.json.bind.adapter.JsonbAdapter;
import javax.json.bind.config.PropertyVisibilityStrategy;
import javax.json.bind.serializer.JsonbDeserializer;
import javax.json.bind.serializer.JsonbSerializer;
import org.jobrunr.utils.mapper.JobParameterJsonMapperException;
import org.jobrunr.utils.mapper.JsonMapper;
import org.jobrunr.utils.mapper.jsonb.FieldAccessStrategy;
import org.jobrunr.utils.mapper.jsonb.JobAdapter;
import org.jobrunr.utils.mapper.jsonb.RecurringJobAdapter;
import org.jobrunr.utils.mapper.jsonb.serializer.DurationTypeDeserializer;
import org.jobrunr.utils.mapper.jsonb.serializer.DurationTypeSerializer;

public class JsonbJsonMapper
implements JsonMapper {
    private final Jsonb jsonb;

    public JsonbJsonMapper() {
        this(new JsonbConfig());
    }

    public JsonbJsonMapper(JsonbConfig jsonbConfig) {
        this.jsonb = JsonbBuilder.create((JsonbConfig)this.initJsonbConfig(jsonbConfig));
    }

    protected JsonbConfig initJsonbConfig(JsonbConfig jsonbConfig) {
        return jsonbConfig.withNullValues(Boolean.valueOf(true)).withSerializers(new JsonbSerializer[]{new DurationTypeSerializer()}).withDeserializers(new JsonbDeserializer[]{new DurationTypeDeserializer()}).withPropertyVisibilityStrategy((PropertyVisibilityStrategy)new FieldAccessStrategy()).withAdapters(new JsonbAdapter[]{new JobAdapter(), new RecurringJobAdapter()});
    }

    @Override
    public String serialize(Object object) {
        try {
            return this.jsonb.toJson(object);
        }
        catch (JsonbException e) {
            throw new JobParameterJsonMapperException("The job parameters are not serializable.", e);
        }
    }

    @Override
    public void serialize(OutputStream outputStream, Object object) {
        this.jsonb.toJson(object, outputStream);
    }

    @Override
    public <T> T deserialize(String serializedObjectAsString, Class<T> clazz) {
        return (T)this.jsonb.fromJson(serializedObjectAsString, clazz);
    }
}

