/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.utils.reflection;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.security.AccessController;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.jobrunr.JobRunrException;
import org.jobrunr.scheduling.exceptions.FieldNotFoundException;
import org.jobrunr.scheduling.exceptions.JobNotFoundException;
import org.jobrunr.utils.StringUtils;
import org.jobrunr.utils.reflection.MethodFinderPredicate;
import org.jobrunr.utils.reflection.autobox.Autoboxer;

public class ReflectionUtils {
    private static final String ROOT_PACKAGE_NAME = "org/jobrunr/";
    private static final Map<Class<?>, Class<?>> PRIMITIVE_TO_TYPE_MAPPING = new HashMap();

    private ReflectionUtils() {
    }

    public static boolean classExists(String className) {
        try {
            ReflectionUtils.loadClass(className);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static <T> Class<T> toClassFromPath(Path path) {
        String classFile = path.toString().substring(path.toString().indexOf(ROOT_PACKAGE_NAME));
        String className = ReflectionUtils.toClassNameFromFileName(classFile);
        return ReflectionUtils.toClass(className);
    }

    public static String toClassNameFromFileName(String classFile) {
        return classFile.replace(".class", "").replace("/", ".");
    }

    public static <T> Class<T> toClass(String className) {
        switch (className) {
            case "boolean": {
                return ReflectionUtils.cast(Boolean.TYPE);
            }
            case "byte": {
                return ReflectionUtils.cast(Byte.TYPE);
            }
            case "short": {
                return ReflectionUtils.cast(Short.TYPE);
            }
            case "int": {
                return ReflectionUtils.cast(Integer.TYPE);
            }
            case "long": {
                return ReflectionUtils.cast(Long.TYPE);
            }
            case "float": {
                return ReflectionUtils.cast(Float.TYPE);
            }
            case "double": {
                return ReflectionUtils.cast(Double.TYPE);
            }
            case "char": {
                return ReflectionUtils.cast(Character.TYPE);
            }
            case "void": {
                return ReflectionUtils.cast(Void.TYPE);
            }
        }
        try {
            return ReflectionUtils.cast(ReflectionUtils.loadClass(className));
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalArgumentException("Class not found: " + className, ex);
        }
    }

    public static Class<?> loadClass(String className) throws ClassNotFoundException {
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            if (classLoader != null) {
                return Class.forName(className, true, classLoader);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return Class.forName(className);
    }

    public static boolean hasDefaultNoArgConstructor(String clazzName) {
        return Stream.of(ReflectionUtils.toClass(clazzName).getConstructors()).anyMatch(c -> c.getParameterCount() == 0);
    }

    public static boolean hasDefaultNoArgConstructor(Class<?> clazz) {
        return Stream.of(clazz.getConstructors()).anyMatch(c -> c.getParameterCount() == 0);
    }

    public static <T> T newInstanceAndSetFieldValues(Class<T> clazz, Map<String, String> fieldValues) {
        Field[] declaredFields;
        T t = ReflectionUtils.newInstance(clazz);
        for (Field field : declaredFields = clazz.getDeclaredFields()) {
            ReflectionUtils.setFieldUsingAutoboxing(field, t, (Object)fieldValues.get(field.getName()));
        }
        return t;
    }

    public static <T> T newInstance(String className, Object ... params) {
        return ReflectionUtils.newInstance(ReflectionUtils.toClass(className), params);
    }

    public static <T> T newInstance(Class<T> clazz, Object ... params) {
        try {
            return ReflectionUtils.newInstanceCE(clazz, params);
        }
        catch (ReflectiveOperationException e) {
            throw JobRunrException.shouldNotHappenException(e);
        }
    }

    public static <T> T newInstanceCE(Class<T> clazz, Object ... params) throws ReflectiveOperationException {
        Constructor<T> declaredConstructor = ReflectionUtils.getConstructorForArgs(clazz, (Class[])Stream.of(params).map(Object::getClass).toArray(Class[]::new));
        ReflectionUtils.makeAccessible(declaredConstructor);
        return declaredConstructor.newInstance(params);
    }

    public static <T> T newInstanceCE(Class<T> clazz) throws ReflectiveOperationException {
        Constructor<T> defaultConstructor = clazz.getDeclaredConstructor(new Class[0]);
        ReflectionUtils.makeAccessible(defaultConstructor);
        return defaultConstructor.newInstance(new Object[0]);
    }

    public static <T> T newInstance(Class<T> clazz) {
        try {
            Constructor<T> defaultConstructor = clazz.getDeclaredConstructor(new Class[0]);
            ReflectionUtils.makeAccessible(defaultConstructor);
            return defaultConstructor.newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw JobRunrException.shouldNotHappenException(e);
        }
    }

    public static Method getMethod(Class<?> clazz, String methodName, Class<?> ... parameterTypes) {
        return ReflectionUtils.findMethod(clazz, methodName, parameterTypes).orElseThrow(() -> new JobNotFoundException(clazz, methodName, parameterTypes));
    }

    public static Optional<Method> findMethod(Object object, String methodName, Class<?> ... parameterTypes) {
        return ReflectionUtils.findMethod(object.getClass(), new MethodFinderPredicate(methodName, parameterTypes));
    }

    public static Optional<Method> findMethod(Class<?> clazz, String methodName, Class<?> ... parameterTypes) {
        return ReflectionUtils.findMethod(clazz, new MethodFinderPredicate(methodName, parameterTypes));
    }

    public static Optional<Method> findMethod(Class<?> clazz, Predicate<Method> predicate) {
        Optional<Method> optionalMethod = Arrays.stream(clazz.getDeclaredMethods()).filter(predicate).findFirst();
        if (optionalMethod.isPresent()) {
            return optionalMethod;
        }
        if (clazz.isInterface()) {
            return Stream.of(clazz.getInterfaces()).map(superInterface -> ReflectionUtils.findMethod(superInterface, predicate)).filter(Optional::isPresent).findFirst().orElse(Optional.empty());
        }
        if (!Object.class.equals(clazz.getSuperclass())) {
            return ReflectionUtils.findMethod(clazz.getSuperclass(), predicate);
        }
        return Optional.empty();
    }

    public static Field getField(Class<?> clazz, String fieldName) {
        return ReflectionUtils.findField(clazz, fieldName).orElseThrow(() -> new FieldNotFoundException(clazz, fieldName));
    }

    public static Optional<Field> findField(Class<?> clazz, String fieldName) {
        return ReflectionUtils.findField(clazz, (Field f) -> fieldName.equals(f.getName()));
    }

    public static Optional<Field> findField(Class<?> clazz, Predicate<Field> predicate) {
        Optional<Field> optionalField = Arrays.stream(clazz.getDeclaredFields()).filter(predicate).findFirst();
        if (optionalField.isPresent()) {
            return optionalField;
        }
        if (!Object.class.equals(clazz.getSuperclass())) {
            return ReflectionUtils.findField(clazz.getSuperclass(), predicate);
        }
        return Optional.empty();
    }

    public static boolean isClassAssignableToObject(Class<?> clazz, Object object) {
        return ReflectionUtils.isClassAssignable(clazz, object.getClass());
    }

    public static boolean isClassAssignable(Class<?> clazz1, Class<?> clazz2) {
        return clazz1.equals(clazz2) || clazz1.isAssignableFrom(clazz2) || clazz1.isPrimitive() && PRIMITIVE_TO_TYPE_MAPPING.get(clazz1).equals(clazz2) || clazz1.isPrimitive() && Boolean.TYPE.equals(clazz1) && Integer.class.equals(clazz2);
    }

    public static boolean objectContainsFieldOrProperty(Object object, String fieldName) {
        if (object == null) {
            return false;
        }
        return ReflectionUtils.objectContainsField(object, fieldName) || ReflectionUtils.objectContainsProperty(object, fieldName);
    }

    public static Object getValueFromFieldOrProperty(Object object, String paramName) {
        Class<?> aClass = object.getClass();
        Optional<Field> optionalField = ReflectionUtils.findField(aClass, paramName);
        if (optionalField.isPresent()) {
            return ReflectionUtils.getValueFromField(optionalField.get(), object);
        }
        Optional<Method> optionalGetMethod = ReflectionUtils.findMethod(aClass, "get" + StringUtils.capitalize(paramName), new Class[0]);
        if (optionalGetMethod.isPresent()) {
            return ReflectionUtils.getValueFromGetMethod(optionalGetMethod.get(), object);
        }
        throw new IllegalArgumentException(String.format("Could not get value '%s' from object with class %s", paramName, object.getClass()));
    }

    public static Object getValueFromField(Field field, Object object) {
        try {
            ReflectionUtils.makeAccessible(field);
            return field.get(object);
        }
        catch (ReflectiveOperationException willNotHappen) {
            throw new IllegalArgumentException(String.format("Could not get value '%s' from object with class %s", field.getName(), object.getClass()));
        }
    }

    public static Object getValueFromGetMethod(Method getter, Object object) {
        try {
            ReflectionUtils.makeAccessible(getter);
            return getter.invoke(object, new Object[0]);
        }
        catch (ReflectiveOperationException willNotHappen) {
            throw new IllegalArgumentException(String.format("Could not get value '%s' from object with class %s", getter.getName(), object.getClass()));
        }
    }

    public static void setFieldUsingAutoboxing(String fieldName, Object object, Object value) {
        if (value == null) {
            return;
        }
        ReflectionUtils.setFieldUsingAutoboxing(ReflectionUtils.getField(object.getClass(), fieldName), object, value);
    }

    public static void setFieldUsingAutoboxing(Field field, Object object, Object value) {
        try {
            if (value == null) {
                return;
            }
            ReflectionUtils.makeAccessible(field);
            Class<?> type = field.getType();
            Object fieldValue = ReflectionUtils.autobox(value, type);
            field.set(object, fieldValue);
        }
        catch (ReflectiveOperationException e) {
            throw JobRunrException.shouldNotHappenException(e);
        }
    }

    public static <T> T autobox(Object value, Class<T> type) {
        return Autoboxer.autobox(value, type);
    }

    public static void makeAccessible(AccessibleObject accessibleObject) {
        AccessController.doPrivileged(() -> {
            accessibleObject.setAccessible(true);
            return null;
        });
    }

    private static <T> Constructor<T> getConstructorForArgs(Class<T> clazz, Class<?>[] args) {
        Constructor<?>[] constructors;
        for (Constructor<?> constructor : constructors = clazz.getConstructors()) {
            Class<?>[] types = constructor.getParameterTypes();
            if (types.length != args.length) continue;
            boolean argumentsMatch = true;
            for (int i = 0; i < args.length; ++i) {
                if (types[i].isAssignableFrom(args[i])) continue;
                argumentsMatch = false;
                break;
            }
            if (!argumentsMatch) continue;
            return (Constructor)ReflectionUtils.cast(constructor);
        }
        throw new JobNotFoundException(clazz, "<init>", args);
    }

    private static <T> Class<T> cast(Class<?> aClass) {
        return aClass;
    }

    public static <T> T cast(Object anObject) {
        return (T)anObject;
    }

    private static boolean objectContainsField(Object object, String fieldName) {
        return ReflectionUtils.findField(object.getClass(), fieldName).isPresent();
    }

    private static boolean objectContainsProperty(Object object, String fieldName) {
        return ReflectionUtils.findMethod(object.getClass(), "get" + StringUtils.capitalize(fieldName), new Class[0]).isPresent();
    }

    static {
        PRIMITIVE_TO_TYPE_MAPPING.put(Boolean.TYPE, Boolean.class);
        PRIMITIVE_TO_TYPE_MAPPING.put(Byte.TYPE, Byte.class);
        PRIMITIVE_TO_TYPE_MAPPING.put(Short.TYPE, Short.class);
        PRIMITIVE_TO_TYPE_MAPPING.put(Character.TYPE, Character.class);
        PRIMITIVE_TO_TYPE_MAPPING.put(Integer.TYPE, Integer.class);
        PRIMITIVE_TO_TYPE_MAPPING.put(Long.TYPE, Long.class);
        PRIMITIVE_TO_TYPE_MAPPING.put(Float.TYPE, Float.class);
        PRIMITIVE_TO_TYPE_MAPPING.put(Double.TYPE, Double.class);
    }
}

