/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.configuration.resolvers;

import java.util.HashMap;
import java.util.Map;
import org.flywaydb.core.internal.configuration.models.EnvironmentModel;
import org.flywaydb.core.internal.configuration.models.ResolvedEnvironment;
import org.flywaydb.core.internal.configuration.resolvers.PropertyResolver;
import org.flywaydb.core.internal.configuration.resolvers.PropertyResolverContextImpl;

public class EnvironmentResolver {
    private final Map<String, PropertyResolver> propertyResolvers;

    public EnvironmentResolver(Map<String, PropertyResolver> propertyResolvers) {
        this.propertyResolvers = propertyResolvers;
    }

    public ResolvedEnvironment resolve(EnvironmentModel environment) {
        Map<String, Map<String, String>> resolversToConfigure = environment.getResolvers();
        PropertyResolverContextImpl context = new PropertyResolverContextImpl(this.propertyResolvers, resolversToConfigure);
        ResolvedEnvironment result = new ResolvedEnvironment();
        result.setDriver(environment.getDriver());
        result.setConnectRetries(environment.getConnectRetries());
        result.setConnectRetriesInterval(environment.getConnectRetriesInterval());
        result.setInitSql(environment.getInitSql());
        result.setSchemas(environment.getSchemas());
        if (environment.getJdbcProperties() != null) {
            HashMap<String, String> jdbcResolvedProps = new HashMap<String, String>();
            for (Map.Entry<String, String> entry : environment.getJdbcProperties().entrySet()) {
                jdbcResolvedProps.put(entry.getKey(), context.resolveValue(entry.getValue()));
            }
            result.setJdbcProperties(jdbcResolvedProps);
        }
        result.setSchemas(environment.getSchemas());
        result.setPassword(context.resolveValue(environment.getPassword()));
        result.setUser(context.resolveValue(environment.getUser()));
        result.setUrl(context.resolveValue(environment.getUrl()));
        result.setToken(context.resolveValue(environment.getToken()));
        return result;
    }
}

