"use strict";
/********************************************************************************
 * Copyright (c) 2022 Anibal Solon and others
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * SPDX-License-Identifier: EPL-2.0
 ********************************************************************************/
Object.defineProperty(exports, "__esModule", { value: true });
const registry_1 = require("./registry");
const util_1 = require("./util");
/**
 * Validates that a Personal Access Token can publish to a namespace.
 */
async function verifyPat(options) {
    util_1.addEnvOptions(options);
    if (!options.pat) {
        throw new Error("A personal access token must be given with the option '--pat'.");
    }
    if (!options.namespace) {
        let error;
        try {
            options.namespace = (await util_1.readManifest()).publisher;
        }
        catch (e) {
            error = e;
        }
        if (!options.namespace) {
            throw new Error(`Unable to read the namespace's name. Please supply it as an argument or run ovsx from the extension folder.` +
                (error ? `\n\n${error}` : ''));
        }
    }
    const registry = new registry_1.Registry(options);
    const result = await registry.verifyPat(options.namespace, options.pat);
    if (result.error) {
        throw new Error(result.error);
    }
    console.log(`\ud83d\ude80  PAT valid to publish at ${options.namespace}`);
}
exports.verifyPat = verifyPat;
//# sourceMappingURL=verify-pat.js.map