"use strict";
/**********************************************************************
 * Copyright (c) 2018-2021 Red Hat, Inc.
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 ***********************************************************************/
Object.defineProperty(exports, "__esModule", { value: true });
exports.replaceInSection = exports.rewriteJson = void 0;
/**
 * Simple code to rewrite parts of JSON files
 * @author Thomas Mäder
 */
const fs = require("fs-extra");
// eslint-disable-next-line @typescript-eslint/no-explicit-any
async function rewriteJson(packageJSONPath, rewriteFunction) {
    const json = await fs.readJSON(packageJSONPath);
    rewriteFunction(json);
    await fs.writeJson(packageJSONPath, json, { encoding: 'utf-8', spaces: 2 });
}
exports.rewriteJson = rewriteJson;
// eslint-disable-next-line @typescript-eslint/no-explicit-any
function replaceInSection(section, replaceVersion) {
    if (section) {
        for (const dep in section) {
            if (section.hasOwnProperty(dep)) {
                const replacement = replaceVersion(dep);
                if (replacement) {
                    section[dep] = replacement;
                }
            }
        }
    }
}
exports.replaceInSection = replaceInSection;
//# sourceMappingURL=json-utils.js.map