# -*- coding: utf-8 -*-
from setuptools import setup

package_dir = \
{'': 'src'}

packages = \
['yacfg', 'yacfg_batch']

package_data = \
{'': ['*'],
 'yacfg': ['profiles/_libs/*',
           'profiles/amq_broker/7.2.0/*',
           'profiles/amq_broker/7.2.0/_modules/bootstrap_xml/*',
           'profiles/amq_broker/7.2.0/cluster/*',
           'profiles/amq_broker/7.2.0/ha/*',
           'profiles/amq_broker/7.2.0/performance/*',
           'profiles/amq_broker/7.2.0/security/gssapi/*',
           'profiles/amq_broker/7.2.0/security/gssapi_ldap/*',
           'profiles/amq_broker/7.2.0/security/ssl/*',
           'profiles/amq_broker/7.2.0/store/jdbc/*',
           'profiles/amq_broker/7.4.0/*',
           'profiles/amq_broker/7.4.0/_modules/bootstrap_xml/*',
           'profiles/amq_broker/7.4.0/_modules/broker_xml/store/*',
           'profiles/amq_broker/7.4.0/cluster/*',
           'profiles/amq_broker/7.4.0/ha/*',
           'profiles/amq_broker/7.4.0/performance/*',
           'profiles/amq_broker/7.4.0/security/gssapi/*',
           'profiles/amq_broker/7.4.0/security/gssapi_ldap/*',
           'profiles/amq_broker/7.4.0/store/jdbc/*',
           'profiles/amq_broker/7.6.0/*',
           'profiles/amq_broker/7.6.0/_modules/bootstrap_xml/*',
           'profiles/amq_broker/7.6.0/_modules/broker_xml/store/*',
           'profiles/amq_broker/7.6.0/cluster/*',
           'profiles/amq_broker/7.6.0/ha/*',
           'profiles/amq_broker/7.6.0/performance/*',
           'profiles/amq_broker/7.6.0/security/gssapi/*',
           'profiles/amq_broker/7.6.0/security/gssapi_ldap/*',
           'profiles/amq_broker/7.6.0/store/jdbc/*',
           'profiles/amq_broker/7.7.0/*',
           'profiles/amq_broker/7.7.0/_modules/bootstrap_xml/*',
           'profiles/amq_broker/7.7.0/_modules/broker_xml/store/*',
           'profiles/amq_broker/7.7.0/cluster/*',
           'profiles/amq_broker/7.7.0/ha/*',
           'profiles/amq_broker/7.7.0/performance/*',
           'profiles/amq_broker/7.7.0/security/gssapi/*',
           'profiles/amq_broker/7.7.0/security/gssapi_ldap/*',
           'profiles/amq_broker/7.7.0/store/jdbc/*',
           'profiles/amq_broker/7.8.0/*',
           'profiles/amq_broker/7.8.0/_modules/bootstrap_xml/*',
           'profiles/amq_broker/7.8.0/_modules/broker_xml/store/*',
           'profiles/amq_broker/7.8.0/cluster/*',
           'profiles/amq_broker/7.8.0/ha/*',
           'profiles/amq_broker/7.8.0/performance/*',
           'profiles/amq_broker/7.8.0/security/gssapi/*',
           'profiles/amq_broker/7.8.0/security/gssapi_ldap/*',
           'profiles/amq_broker/7.8.0/store/jdbc/*',
           'profiles/amq_broker/7.8.1/*',
           'profiles/amq_broker/7.8.1/_modules/bootstrap_xml/*',
           'profiles/amq_broker/7.8.1/_modules/broker_xml/store/*',
           'profiles/amq_broker/7.8.1/cluster/*',
           'profiles/amq_broker/7.8.1/ha/*',
           'profiles/amq_broker/7.8.1/performance/*',
           'profiles/amq_broker/7.8.1/security/gssapi/*',
           'profiles/amq_broker/7.8.1/security/gssapi_ldap/*',
           'profiles/amq_broker/7.8.1/store/jdbc/*',
           'profiles/amq_broker/7.8.2/*',
           'profiles/amq_broker/7.8.2/_modules/bootstrap_xml/*',
           'profiles/amq_broker/7.8.2/_modules/broker_xml/store/*',
           'profiles/amq_broker/7.8.2/cluster/*',
           'profiles/amq_broker/7.8.2/ha/*',
           'profiles/amq_broker/7.8.2/performance/*',
           'profiles/amq_broker/7.8.2/security/gssapi/*',
           'profiles/amq_broker/7.8.2/security/gssapi_ldap/*',
           'profiles/amq_broker/7.8.2/store/jdbc/*',
           'profiles/amq_broker/7.9.0/*',
           'profiles/amq_broker/7.9.0/_modules/bootstrap_xml/*',
           'profiles/amq_broker/7.9.0/_modules/broker_xml/store/*',
           'profiles/amq_broker/7.9.0/cluster/*',
           'profiles/amq_broker/7.9.0/ha/*',
           'profiles/amq_broker/7.9.0/performance/*',
           'profiles/amq_broker/7.9.0/security/gssapi/*',
           'profiles/amq_broker/7.9.0/security/gssapi_ldap/*',
           'profiles/amq_broker/7.9.0/store/jdbc/*',
           'profiles/artemis/2.13.0/*',
           'profiles/artemis/2.13.0/_modules/artemis_profile/*',
           'profiles/artemis/2.13.0/_modules/artemis_profile/performance/*',
           'profiles/artemis/2.13.0/_modules/bootstrap_xml/*',
           'profiles/artemis/2.13.0/_modules/broker_xml/*',
           'profiles/artemis/2.13.0/_modules/broker_xml/acceptors/*',
           'profiles/artemis/2.13.0/_modules/broker_xml/address_settings/*',
           'profiles/artemis/2.13.0/_modules/broker_xml/addresses/*',
           'profiles/artemis/2.13.0/_modules/broker_xml/cluster/*',
           'profiles/artemis/2.13.0/_modules/broker_xml/ha_policy/replication/*',
           'profiles/artemis/2.13.0/_modules/broker_xml/ha_policy/shared_store/*',
           'profiles/artemis/2.13.0/_modules/broker_xml/journal/*',
           'profiles/artemis/2.13.0/_modules/broker_xml/store/*',
           'profiles/artemis/2.13.0/_modules/jolokia_access/*',
           'profiles/artemis/2.13.0/_modules/logging_properties/*',
           'profiles/artemis/2.13.0/_modules/login_config/*',
           'profiles/artemis/2.13.0/_modules/management_xml/*',
           'profiles/artemis/2.13.0/_modules/security/jdk_gssapi/*',
           'profiles/artemis/2.13.0/_modules/users_roles_security/*',
           'profiles/artemis/2.13.0/cluster/*',
           'profiles/artemis/2.13.0/ha/*',
           'profiles/artemis/2.13.0/performance/*',
           'profiles/artemis/2.13.0/security/gssapi/*',
           'profiles/artemis/2.13.0/security/gssapi/ssl_tls/*',
           'profiles/artemis/2.13.0/security/gssapi_ldap/*',
           'profiles/artemis/2.13.0/store/jdbc/*',
           'profiles/artemis/2.14.0/*',
           'profiles/artemis/2.14.0/_modules/artemis_profile/*',
           'profiles/artemis/2.14.0/_modules/artemis_profile/performance/*',
           'profiles/artemis/2.14.0/_modules/bootstrap_xml/*',
           'profiles/artemis/2.14.0/_modules/broker_xml/*',
           'profiles/artemis/2.14.0/_modules/broker_xml/acceptors/*',
           'profiles/artemis/2.14.0/_modules/broker_xml/address_settings/*',
           'profiles/artemis/2.14.0/_modules/broker_xml/addresses/*',
           'profiles/artemis/2.14.0/_modules/broker_xml/cluster/*',
           'profiles/artemis/2.14.0/_modules/broker_xml/ha_policy/replication/*',
           'profiles/artemis/2.14.0/_modules/broker_xml/ha_policy/shared_store/*',
           'profiles/artemis/2.14.0/_modules/broker_xml/journal/*',
           'profiles/artemis/2.14.0/_modules/broker_xml/store/*',
           'profiles/artemis/2.14.0/_modules/jolokia_access/*',
           'profiles/artemis/2.14.0/_modules/logging_properties/*',
           'profiles/artemis/2.14.0/_modules/login_config/*',
           'profiles/artemis/2.14.0/_modules/management_xml/*',
           'profiles/artemis/2.14.0/_modules/security/jdk_gssapi/*',
           'profiles/artemis/2.14.0/_modules/users_roles_security/*',
           'profiles/artemis/2.14.0/cluster/*',
           'profiles/artemis/2.14.0/ha/*',
           'profiles/artemis/2.14.0/performance/*',
           'profiles/artemis/2.14.0/security/gssapi/*',
           'profiles/artemis/2.14.0/security/gssapi/ssl_tls/*',
           'profiles/artemis/2.14.0/security/gssapi_ldap/*',
           'profiles/artemis/2.14.0/store/jdbc/*',
           'profiles/artemis/2.15.0/*',
           'profiles/artemis/2.15.0/_modules/artemis_profile/*',
           'profiles/artemis/2.15.0/_modules/artemis_profile/performance/*',
           'profiles/artemis/2.15.0/_modules/bootstrap_xml/*',
           'profiles/artemis/2.15.0/_modules/broker_xml/*',
           'profiles/artemis/2.15.0/_modules/broker_xml/acceptors/*',
           'profiles/artemis/2.15.0/_modules/broker_xml/address_settings/*',
           'profiles/artemis/2.15.0/_modules/broker_xml/addresses/*',
           'profiles/artemis/2.15.0/_modules/broker_xml/cluster/*',
           'profiles/artemis/2.15.0/_modules/broker_xml/ha_policy/replication/*',
           'profiles/artemis/2.15.0/_modules/broker_xml/ha_policy/shared_store/*',
           'profiles/artemis/2.15.0/_modules/broker_xml/journal/*',
           'profiles/artemis/2.15.0/_modules/broker_xml/store/*',
           'profiles/artemis/2.15.0/_modules/jolokia_access/*',
           'profiles/artemis/2.15.0/_modules/logging_properties/*',
           'profiles/artemis/2.15.0/_modules/login_config/*',
           'profiles/artemis/2.15.0/_modules/management_xml/*',
           'profiles/artemis/2.15.0/_modules/security/jdk_gssapi/*',
           'profiles/artemis/2.15.0/_modules/users_roles_security/*',
           'profiles/artemis/2.15.0/cluster/*',
           'profiles/artemis/2.15.0/ha/*',
           'profiles/artemis/2.15.0/performance/*',
           'profiles/artemis/2.15.0/security/gssapi/*',
           'profiles/artemis/2.15.0/security/gssapi/ssl_tls/*',
           'profiles/artemis/2.15.0/security/gssapi_ldap/*',
           'profiles/artemis/2.15.0/store/jdbc/*',
           'profiles/artemis/2.16.0/*',
           'profiles/artemis/2.16.0/_modules/artemis_profile/*',
           'profiles/artemis/2.16.0/_modules/artemis_profile/performance/*',
           'profiles/artemis/2.16.0/_modules/bootstrap_xml/*',
           'profiles/artemis/2.16.0/_modules/broker_xml/*',
           'profiles/artemis/2.16.0/_modules/broker_xml/acceptors/*',
           'profiles/artemis/2.16.0/_modules/broker_xml/address_settings/*',
           'profiles/artemis/2.16.0/_modules/broker_xml/addresses/*',
           'profiles/artemis/2.16.0/_modules/broker_xml/cluster/*',
           'profiles/artemis/2.16.0/_modules/broker_xml/ha_policy/replication/*',
           'profiles/artemis/2.16.0/_modules/broker_xml/ha_policy/shared_store/*',
           'profiles/artemis/2.16.0/_modules/broker_xml/journal/*',
           'profiles/artemis/2.16.0/_modules/broker_xml/store/*',
           'profiles/artemis/2.16.0/_modules/jolokia_access/*',
           'profiles/artemis/2.16.0/_modules/logging_properties/*',
           'profiles/artemis/2.16.0/_modules/login_config/*',
           'profiles/artemis/2.16.0/_modules/management_xml/*',
           'profiles/artemis/2.16.0/_modules/security/jdk_gssapi/*',
           'profiles/artemis/2.16.0/_modules/users_roles_security/*',
           'profiles/artemis/2.16.0/cluster/*',
           'profiles/artemis/2.16.0/ha/*',
           'profiles/artemis/2.16.0/performance/*',
           'profiles/artemis/2.16.0/security/gssapi/*',
           'profiles/artemis/2.16.0/security/gssapi/ssl_tls/*',
           'profiles/artemis/2.16.0/security/gssapi_ldap/*',
           'profiles/artemis/2.16.0/store/jdbc/*',
           'profiles/artemis/2.17.0/*',
           'profiles/artemis/2.17.0/_modules/artemis_profile/*',
           'profiles/artemis/2.17.0/_modules/artemis_profile/performance/*',
           'profiles/artemis/2.17.0/_modules/bootstrap_xml/*',
           'profiles/artemis/2.17.0/_modules/broker_xml/*',
           'profiles/artemis/2.17.0/_modules/broker_xml/acceptors/*',
           'profiles/artemis/2.17.0/_modules/broker_xml/address_settings/*',
           'profiles/artemis/2.17.0/_modules/broker_xml/addresses/*',
           'profiles/artemis/2.17.0/_modules/broker_xml/cluster/*',
           'profiles/artemis/2.17.0/_modules/broker_xml/ha_policy/replication/*',
           'profiles/artemis/2.17.0/_modules/broker_xml/ha_policy/shared_store/*',
           'profiles/artemis/2.17.0/_modules/broker_xml/journal/*',
           'profiles/artemis/2.17.0/_modules/broker_xml/store/*',
           'profiles/artemis/2.17.0/_modules/jolokia_access/*',
           'profiles/artemis/2.17.0/_modules/logging_properties/*',
           'profiles/artemis/2.17.0/_modules/login_config/*',
           'profiles/artemis/2.17.0/_modules/management_xml/*',
           'profiles/artemis/2.17.0/_modules/security/jdk_gssapi/*',
           'profiles/artemis/2.17.0/_modules/users_roles_security/*',
           'profiles/artemis/2.17.0/cluster/*',
           'profiles/artemis/2.17.0/ha/*',
           'profiles/artemis/2.17.0/performance/*',
           'profiles/artemis/2.17.0/security/gssapi/*',
           'profiles/artemis/2.17.0/security/gssapi/ssl_tls/*',
           'profiles/artemis/2.17.0/security/gssapi_ldap/*',
           'profiles/artemis/2.17.0/store/jdbc/*',
           'profiles/artemis/2.18.0/*',
           'profiles/artemis/2.18.0/_modules/artemis_profile/*',
           'profiles/artemis/2.18.0/_modules/artemis_profile/performance/*',
           'profiles/artemis/2.18.0/_modules/bootstrap_xml/*',
           'profiles/artemis/2.18.0/_modules/broker_xml/*',
           'profiles/artemis/2.18.0/_modules/broker_xml/acceptors/*',
           'profiles/artemis/2.18.0/_modules/broker_xml/address_settings/*',
           'profiles/artemis/2.18.0/_modules/broker_xml/addresses/*',
           'profiles/artemis/2.18.0/_modules/broker_xml/cluster/*',
           'profiles/artemis/2.18.0/_modules/broker_xml/ha_policy/replication/*',
           'profiles/artemis/2.18.0/_modules/broker_xml/ha_policy/shared_store/*',
           'profiles/artemis/2.18.0/_modules/broker_xml/journal/*',
           'profiles/artemis/2.18.0/_modules/broker_xml/security_settings/*',
           'profiles/artemis/2.18.0/_modules/broker_xml/store/*',
           'profiles/artemis/2.18.0/_modules/jolokia_access/*',
           'profiles/artemis/2.18.0/_modules/logging_properties/*',
           'profiles/artemis/2.18.0/_modules/login_config/*',
           'profiles/artemis/2.18.0/_modules/management_xml/*',
           'profiles/artemis/2.18.0/_modules/security/jdk_gssapi/*',
           'profiles/artemis/2.18.0/_modules/users_roles_security/*',
           'profiles/artemis/2.18.0/cluster/*',
           'profiles/artemis/2.18.0/ha/*',
           'profiles/artemis/2.18.0/performance/*',
           'profiles/artemis/2.18.0/security/gssapi/*',
           'profiles/artemis/2.18.0/security/gssapi/ssl_tls/*',
           'profiles/artemis/2.18.0/security/gssapi_ldap/*',
           'profiles/artemis/2.18.0/store/jdbc/*',
           'profiles/artemis/2.5.0/*',
           'profiles/artemis/2.5.0/_modules/artemis_profile/*',
           'profiles/artemis/2.5.0/_modules/artemis_profile/performance/*',
           'profiles/artemis/2.5.0/_modules/bootstrap_xml/*',
           'profiles/artemis/2.5.0/_modules/broker_xml/*',
           'profiles/artemis/2.5.0/_modules/broker_xml/acceptors/*',
           'profiles/artemis/2.5.0/_modules/broker_xml/address_settings/*',
           'profiles/artemis/2.5.0/_modules/broker_xml/addresses/*',
           'profiles/artemis/2.5.0/_modules/broker_xml/cluster/*',
           'profiles/artemis/2.5.0/_modules/broker_xml/ha_policy/replication/*',
           'profiles/artemis/2.5.0/_modules/broker_xml/ha_policy/shared_store/*',
           'profiles/artemis/2.5.0/_modules/broker_xml/journal/*',
           'profiles/artemis/2.5.0/_modules/broker_xml/store/*',
           'profiles/artemis/2.5.0/_modules/jolokia_access/*',
           'profiles/artemis/2.5.0/_modules/logging_properties/*',
           'profiles/artemis/2.5.0/_modules/login_config/*',
           'profiles/artemis/2.5.0/_modules/management_xml/*',
           'profiles/artemis/2.5.0/_modules/security/jdk_gssapi/*',
           'profiles/artemis/2.5.0/_modules/users_roles_security/*',
           'profiles/artemis/2.5.0/cluster/*',
           'profiles/artemis/2.5.0/ha/*',
           'profiles/artemis/2.5.0/performance/*',
           'profiles/artemis/2.5.0/security/gssapi/*',
           'profiles/artemis/2.5.0/store/jdbc/*',
           'profiles/artemis/2.6.0/*',
           'profiles/artemis/2.6.0/_modules/artemis_profile/*',
           'profiles/artemis/2.6.0/_modules/artemis_profile/performance/*',
           'profiles/artemis/2.6.0/_modules/bootstrap_xml/*',
           'profiles/artemis/2.6.0/_modules/broker_xml/*',
           'profiles/artemis/2.6.0/_modules/broker_xml/acceptors/*',
           'profiles/artemis/2.6.0/_modules/broker_xml/address_settings/*',
           'profiles/artemis/2.6.0/_modules/broker_xml/addresses/*',
           'profiles/artemis/2.6.0/_modules/broker_xml/cluster/*',
           'profiles/artemis/2.6.0/_modules/broker_xml/ha_policy/replication/*',
           'profiles/artemis/2.6.0/_modules/broker_xml/ha_policy/shared_store/*',
           'profiles/artemis/2.6.0/_modules/broker_xml/journal/*',
           'profiles/artemis/2.6.0/_modules/broker_xml/store/*',
           'profiles/artemis/2.6.0/_modules/jolokia_access/*',
           'profiles/artemis/2.6.0/_modules/logging_properties/*',
           'profiles/artemis/2.6.0/_modules/login_config/*',
           'profiles/artemis/2.6.0/_modules/management_xml/*',
           'profiles/artemis/2.6.0/_modules/security/jdk_gssapi/*',
           'profiles/artemis/2.6.0/_modules/users_roles_security/*',
           'profiles/artemis/2.6.0/cluster/*',
           'profiles/artemis/2.6.0/ha/*',
           'profiles/artemis/2.6.0/performance/*',
           'profiles/artemis/2.6.0/security/gssapi/*',
           'profiles/artemis/2.6.0/security/gssapi/ssl_tls/*',
           'profiles/artemis/2.6.0/security/gssapi_ldap/*',
           'profiles/artemis/2.6.0/store/jdbc/*',
           'profiles/artemis/2.9.0/*',
           'profiles/artemis/2.9.0/_modules/artemis_profile/*',
           'profiles/artemis/2.9.0/_modules/artemis_profile/performance/*',
           'profiles/artemis/2.9.0/_modules/bootstrap_xml/*',
           'profiles/artemis/2.9.0/_modules/broker_xml/*',
           'profiles/artemis/2.9.0/_modules/broker_xml/acceptors/*',
           'profiles/artemis/2.9.0/_modules/broker_xml/address_settings/*',
           'profiles/artemis/2.9.0/_modules/broker_xml/addresses/*',
           'profiles/artemis/2.9.0/_modules/broker_xml/cluster/*',
           'profiles/artemis/2.9.0/_modules/broker_xml/ha_policy/replication/*',
           'profiles/artemis/2.9.0/_modules/broker_xml/ha_policy/shared_store/*',
           'profiles/artemis/2.9.0/_modules/broker_xml/journal/*',
           'profiles/artemis/2.9.0/_modules/broker_xml/store/*',
           'profiles/artemis/2.9.0/_modules/jolokia_access/*',
           'profiles/artemis/2.9.0/_modules/logging_properties/*',
           'profiles/artemis/2.9.0/_modules/login_config/*',
           'profiles/artemis/2.9.0/_modules/management_xml/*',
           'profiles/artemis/2.9.0/_modules/security/jdk_gssapi/*',
           'profiles/artemis/2.9.0/_modules/users_roles_security/*',
           'profiles/artemis/2.9.0/cluster/*',
           'profiles/artemis/2.9.0/ha/*',
           'profiles/artemis/2.9.0/performance/*',
           'profiles/artemis/2.9.0/security/gssapi/*',
           'profiles/artemis/2.9.0/security/gssapi/ssl_tls/*',
           'profiles/artemis/2.9.0/security/gssapi_ldap/*',
           'profiles/artemis/2.9.0/store/jdbc/*',
           'templates/artemis/2.13.0/*',
           'templates/artemis/2.13.0/modules/broker_xml/*',
           'templates/artemis/2.13.0/modules/broker_xml/ha_policy/*',
           'templates/artemis/2.13.0/modules/broker_xml/security_settings/*',
           'templates/artemis/2.13.0/modules/broker_xml/store/*',
           'templates/artemis/2.14.0/*',
           'templates/artemis/2.14.0/modules/broker_xml/*',
           'templates/artemis/2.14.0/modules/broker_xml/ha_policy/*',
           'templates/artemis/2.14.0/modules/broker_xml/security_settings/*',
           'templates/artemis/2.14.0/modules/broker_xml/store/*',
           'templates/artemis/2.15.0/*',
           'templates/artemis/2.15.0/modules/broker_xml/*',
           'templates/artemis/2.15.0/modules/broker_xml/ha_policy/*',
           'templates/artemis/2.15.0/modules/broker_xml/security_settings/*',
           'templates/artemis/2.15.0/modules/broker_xml/store/*',
           'templates/artemis/2.16.0/*',
           'templates/artemis/2.16.0/modules/broker_xml/*',
           'templates/artemis/2.16.0/modules/broker_xml/ha_policy/*',
           'templates/artemis/2.16.0/modules/broker_xml/security_settings/*',
           'templates/artemis/2.16.0/modules/broker_xml/store/*',
           'templates/artemis/2.17.0/*',
           'templates/artemis/2.17.0/modules/broker_xml/*',
           'templates/artemis/2.17.0/modules/broker_xml/ha_policy/*',
           'templates/artemis/2.17.0/modules/broker_xml/security_settings/*',
           'templates/artemis/2.17.0/modules/broker_xml/store/*',
           'templates/artemis/2.18.0/*',
           'templates/artemis/2.18.0/modules/broker_xml/*',
           'templates/artemis/2.18.0/modules/broker_xml/ha_policy/*',
           'templates/artemis/2.18.0/modules/broker_xml/security_settings/*',
           'templates/artemis/2.18.0/modules/broker_xml/store/*',
           'templates/artemis/2.5.0/*',
           'templates/artemis/2.5.0/modules/broker_xml/*',
           'templates/artemis/2.5.0/modules/broker_xml/ha_policy/*',
           'templates/artemis/2.5.0/modules/broker_xml/security_settings/*',
           'templates/artemis/2.5.0/modules/broker_xml/store/*',
           'templates/artemis/2.6.0/*',
           'templates/artemis/2.6.0/modules/broker_xml/*',
           'templates/artemis/2.6.0/modules/broker_xml/ha_policy/*',
           'templates/artemis/2.6.0/modules/broker_xml/security_settings/*',
           'templates/artemis/2.6.0/modules/broker_xml/store/*',
           'templates/artemis/2.9.0/*',
           'templates/artemis/2.9.0/modules/broker_xml/*',
           'templates/artemis/2.9.0/modules/broker_xml/ha_policy/*',
           'templates/artemis/2.9.0/modules/broker_xml/security_settings/*',
           'templates/artemis/2.9.0/modules/broker_xml/store/*',
           'templates/libs/*',
           'templates/libs/headers/*',
           'templates/libs/licenses/apache-2.0/*']}

install_requires = \
['PyYAML==5.4.1', 'jinja2>=1.10.3,<=2.11.3']

extras_require = \
{':python_version < "3.8"': ['importlib-metadata>=4.6.3,<5.0.0'],
 'color_log': ['colorlog>=5.0.1,<6.0.0', 'colorama>=0.4.4,<0.5.0']}

entry_points = \
{'console_scripts': ['yacfg = yacfg.yacfg_cli:main',
                     'yacfg-batch = yacfg_batch.yacfg_batch_cli:main']}

setup_kwargs = {
    'name': 'yacfg',
    'version': '0.9.3',
    'description': 'Template based configuration files generator based on jinja2 and yaml.',
    'long_description': '# yacfg - YAML Configurator\n\nThis tool can generate a set of configuration files mainly needed for\nAMQ Broker, but it is not limited to only generating files for one product.\n\nIt has a user facing Command Line Tool for quick and easy command line usage.\nFurthermore, it is possible to use its API in your python code.\n\n## Getting started\n\n* Python 3.5+\n* Python Poetry\n\n### From git\n\n```bash\ngit clone git@github.com:rh-messaging-qe/yacfg.git\npoetry install\nyacfg --help\n```\n\n### From PyPI\n\n```bash\npip install yacfg\nyacfg --help\n```\n\n## User (CLI) guide\n\n```bash\nyacfg --help\n\nyacfg --list-profiles\nyacfg --list-templates\n\n# perform a generation of a default profile\nyacfg --profile artemis/2.5.0/default.yaml.jinja2\n# also save result to [OUTDIR] directory\nyacfg --profile [PROFILE] --output [OUTDIR]\n```\n\n## Customization\n\nQuickest way to customize data is to use hot-variables, basically variables\nthat the profile itself provides for tuning. Next step is to write (modify) custom\nprofile with completely custom values.\nIf that does not satisfy your needs, then a custom template might be required.\n\n### Profile tuning\n\nSimply export tuning values from profile you want to tune and change those you\nneed to change. Then supply the custom tuning file(s) when generating the profile.\n\n```bash\nyacfg --profile [PROFILE] --export-tuning my_values.yaml\nvim my_values.yaml\nyacfg --profile [PROFILE] --tune my_values.yaml\n\n# multiple tuning files can be overlaid\n# they are updated in sequence, only values present are overwritten\nyacfg --profile [PROFILE] --tune my_values.yaml --tune machine_specific.yaml \\\n       --tune logging_debug.yaml --output [OUTDIR]\n```\n\n## Custom profiles\n\nWrite your own, or simply export an existing profile and modify that.\n\nYou can export dynamic version with includes of some modules, that would still\n work. Either you can use imports from package, or your own local files.\n\nOr you can export completely rendered profile file without any includes or\nvariables and modify that as you like.\n\n\n```bash\n# export profile with dynamic includes still active jinja2 files\nyacfg --profile [PROFILE] --new-profile my_new_profile.yaml.jinja2\n# export completely generated profile without any jinja2 fields, plain yaml\nyacfg --profile [PROFILE] --new-profile-static my_new_profile.yaml\nvim my_new_profile.yaml\nyacfg --profile my_new_profile.yaml\n```\n\nProfile is just another jinja2 file that enables customization of profile data\n -- that is tuning. Becuase of that we recommend to keep the extension `.yaml.jinja2`\n unless it is static profile withou any jinja2 capabilities, in that case it could\n be named `.yaml`. That way we can run yaml lint against static profiles and verify\n that they are correct.\n\n All profiles have to be used to generate files without any tuning. That means,\n if they are tune-able, they have to contain all default values in `_defaults` section.\n That section is also used for tuning, so any variable in there will be exported as tuning.\n\n## Custom templates\n\nThe last resort is to export a template and modify that. But remember a template,\nor more correctly a template set is a directory containing a set of main\ntemplates that subsequently generate_via_tuning_files a new file.\n\nOf course feel free to write your own templates. Especially when you need to\ngenerate_via_tuning_files files for something that is not packaged.\n\nJust remember for a template set to be identified the directory must contain\na file named \'_template\' and then main templates ending with \'.jinja2\'.\n\n```bash\nyacfg --template [TEMPLATE] --new-template my_new_template\nvim my_new_template/[MAIN_TEMPLATES].jinja2\nyacfg --template my_new_template --profile [PROFILE]\n\n```\n\n## API guide\n\nDirect use of API is to use `generate()` nearly the same as the CLI.\nWith option to use tuning values directly.\n\nTuning data will be overlaid in order of appearance, using python\ndict.update(), so values that will appear later will overwrite previous\nvalues. We recommend that tuning values are always flat, because update\nis not recursive. The same applies for data from tuning files as well\nas the directly provided data.\n\nData application order:\n\n- profile defaults\n- data from tuning files (in order of appearance) `tuning_files_list`\n- data provided directly (in order of appearance) `tuning_data_list`\n\n\n```python\nimport yacfg\n\n# generating only broker.xml config using default values from profile,\n# no tuning, writing output to a target path\nyacfg.generate(\n    profile=\'artemis/2.5.0/default.yaml.jinja2\',\n    output_filter=[\'broker.xml\'],\n    output_path=\'/opt/artemis-2.5.0-i0/etc/\',\n)\n\n# using both files and direct values, and writing generated configs to\n# a target directory\nyacfg.generate(\n    profile=\'artemis/2.5.0/default.yaml.jinja2\',\n    tuning_files_list=[\n        \'my_values.yaml\',\n        \'machine_specific.yaml\',\n        \'logging_debug.yaml\'\n    ],\n    tuning_data_list=[\n        {\'name\': \'custom name\', \'config\': \'option_a\'},\n        {\'address\': \'10.0.0.1\'},\n        {\'LOG_LEVEL\': \'debug\'},\n    ],\n    output_path=\'/opt/artemis-2.5.0-i0/etc/\',\n)\n\n# just get generated data for further processing, using just tuning files\ndata = yacfg.generate(\n    profile=\'artemis/2.5.0/default.yaml.jinja2\',\n    tuning_files_list=[\n        \'my_values.yaml\',\n        \'machine_specific.yaml\',\n        \'logging_debug.yaml\'\n    ],\n)\nprint(data[\'broker.xml\'])\n```\n\n## Batch configurations\n\nIn case you have multiple services to configure in your environment,\nthat you probably will have at some point, there is a tool for that\nas well. The tool is called yacfg-batch. It has only yaml input and\nit uses yacfg to generate configurations as you are already used to.\n\nInput yaml file defines all services you need to generate, what\nprofiles to use, and what tuning to provide to `yacfg`.\nIt allows you to configure defaults and common for services.\n\n### Batch profile file\n\nAs said it is YAML. It has two special sections: `_default` and `_common`.\nAs the name suggests, `_default` values are used when values are not\ndefined per specific section. Where `_common` is added to the values\nof all sections. The important thing here is that `_default` has lower\npriority than `_common` and that has lower priority than specific section\nvalues.\n\nEvery section has 4 values: `profile`, `template`, `tuning_files`,\n and `tuning`. As the name suggests, `profile` defines what generation profile\n to select, and it directly correlates with `yacfg`\'s `--profile`.\n `template` defines what generation template to use\n (overrides one in the profile if defined), and it directly correlates with\n `--template` from `yacfg`. `tuning_files` option is a list of tuning\n files to use, when combining defaults, commons, and specific values,\n tuning_files list is concatenated. Finally `tuning` is a map of\n specific tuning values, correlates with `--opt` of `yacfg`. When combining\n defaults, commons, and specifics, it will be updated over using python\n dict.update() and it will work only on first level, so it is recommended\n to use flat values for tuning only.\n\nExample:\n```yaml\n\n_default:\n    profile: artemis/2.5.0/default.yaml.jinja2\n    tuning_files:\n      - defaults/broker_default.yaml\n\n_common:\n    tuning_files:\n      - common/security.yaml\n      - common/logging.yaml\n    tuning_values:\n      LOG_LEVEL_ALL: INFO\n\nbrokerA/opt/artemis/etc:\n    pass: true\n\nbrokerB/opt/artemis/etc:\n    profile: artemis/2.5.0/AIOBasic.yaml.jinja2\n    tuning_files:\n      - brokerB/queues.yaml\n\n---\n\n_default:\n    profile: amq_broker/7.2.0/default.yaml.jinja2\n    tuning_files:\n      - defaults/amq_broker_default.yaml\n\nbrokerC/opt/amq/etc:\n    tuning:\n      LOG_LEVEL_ALL: DEBUG\n\n```\n\nAs you can see, `yacfg-batch` supports multiple sections, in single\nbatch profile file, that allows you to generate multiple groups using\nseparated `_default` and `_common` sections for that.\n\n### executing batch\n\nWhen you have defined all tuning files you need, and in the root of this\nbatch configuration you have your batch profile file, you can now simply\nrun `yacfg-batch`:\n\n```bash\n\nyacfg-batch --input [batch_profile_file] --output [output_path]\n```\n\nYou can use multiple input files and all of those will be generated\nconsecutively. In the output path, new subdirectories will be created\nfor every item you configure (every section), section key will be used\nfor that subdirectory. If the section name resembles a path, whole\npath will be created. For example for `brokerA/opt/artemis/etc`\nthe configuration will be generated into\n`[output_path]/brokerA/opt/artemis/etc/`.\n\n## Documentation\nFormatted documentation can be viewed at [rh-messaging-qe.github.io/yacfg/](https://rh-messaging-qe.github.io/yacfg/).\n\n\n## Contributing\n\nIf you find a bug or room for improvement, submit either a ticket or PR.\n\n## Contributors\n\n_Alphabetically ordered_\n\n* Dominik Lenoch <dlenoch@redhat.com> (maintainer)\n* Michal Tóth <mtoth@redhat.com>\n* Otavio Piske <opiske@redhat.com>\n* Sean Davey <sdavey@redhat.com>\n* Zdenek Kraus <zkraus@redhat.com> (author)\n\n## License\n\nCopyright 2018-2021 Red Hat Inc.\n\nLicensed under the Apache License, Version 2.0 (the "License");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n   http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an "AS IS" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n## Acknowledgments\n\n* [jinja2](http://jinja.pocoo.org/docs/2.10/) -- awesome templating engine\n* [yaml](http://yaml.org/) -- very convenient user readable format\n* [learn_yaml](https://learnxinyminutes.com/docs/yaml/) -- great YAML cheat sheet\n* [pyyaml](https://github.com/yaml/pyyaml) -- python YAML parser\n* [jq](https://stedolan.github.io/jq/) -- great tool for working with structured data (JSON)\n* [yq](https://yq.readthedocs.io/en/latest/) -- YAML variant of jq\n* [github templates examples](https://github.com/stevemao/github-issue-templates/tree/master/simple) -- Nice set of ISSUE_TEMPLATE.md and PULL_REQUESTS_TEMPLATE.md examples\n* [contributing example](https://gist.github.com/PurpleBooth/b24679402957c63ec426) -- example/template of CONTRIBUTING.md\n* [Fedora Project code-of-conduct](https://docs.fedoraproject.org/en-US/project/code-of-conduct/) -- the inspiration for CODE_OF_CONDUCT.md\n',
    'author': 'Zdenek Kraus',
    'author_email': 'zkraus@redhat.com',
    'maintainer': 'Dominik Lenoch',
    'maintainer_email': 'dlenoch@redhat.com',
    'url': 'https://github.com/rh-messaging-qe/yacfg',
    'package_dir': package_dir,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'extras_require': extras_require,
    'entry_points': entry_points,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)