// Code generated by go-swagger; DO NOT EDIT.

package installer

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/openshift/assisted-service/models"
)

// DownloadClusterLogsReader is a Reader for the DownloadClusterLogs structure.
type DownloadClusterLogsReader struct {
	formats strfmt.Registry
	writer  io.Writer
}

// ReadResponse reads a server response into the received o.
func (o *DownloadClusterLogsReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewDownloadClusterLogsOK(o.writer)
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 401:
		result := NewDownloadClusterLogsUnauthorized()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewDownloadClusterLogsForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 404:
		result := NewDownloadClusterLogsNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 405:
		result := NewDownloadClusterLogsMethodNotAllowed()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 409:
		result := NewDownloadClusterLogsConflict()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewDownloadClusterLogsInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result

	default:
		return nil, runtime.NewAPIError("response status code does not match any response statuses defined for this endpoint in the swagger spec", response, response.Code())
	}
}

// NewDownloadClusterLogsOK creates a DownloadClusterLogsOK with default headers values
func NewDownloadClusterLogsOK(writer io.Writer) *DownloadClusterLogsOK {
	return &DownloadClusterLogsOK{
		Payload: writer,
	}
}

/*DownloadClusterLogsOK handles this case with default header values.

Success.
*/
type DownloadClusterLogsOK struct {
	Payload io.Writer
}

func (o *DownloadClusterLogsOK) Error() string {
	return fmt.Sprintf("[GET /clusters/{cluster_id}/logs][%d] downloadClusterLogsOK  %+v", 200, o.Payload)
}

func (o *DownloadClusterLogsOK) GetPayload() io.Writer {
	return o.Payload
}

func (o *DownloadClusterLogsOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDownloadClusterLogsUnauthorized creates a DownloadClusterLogsUnauthorized with default headers values
func NewDownloadClusterLogsUnauthorized() *DownloadClusterLogsUnauthorized {
	return &DownloadClusterLogsUnauthorized{}
}

/*DownloadClusterLogsUnauthorized handles this case with default header values.

Unauthorized.
*/
type DownloadClusterLogsUnauthorized struct {
	Payload *models.InfraError
}

func (o *DownloadClusterLogsUnauthorized) Error() string {
	return fmt.Sprintf("[GET /clusters/{cluster_id}/logs][%d] downloadClusterLogsUnauthorized  %+v", 401, o.Payload)
}

func (o *DownloadClusterLogsUnauthorized) GetPayload() *models.InfraError {
	return o.Payload
}

func (o *DownloadClusterLogsUnauthorized) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.InfraError)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDownloadClusterLogsForbidden creates a DownloadClusterLogsForbidden with default headers values
func NewDownloadClusterLogsForbidden() *DownloadClusterLogsForbidden {
	return &DownloadClusterLogsForbidden{}
}

/*DownloadClusterLogsForbidden handles this case with default header values.

Forbidden.
*/
type DownloadClusterLogsForbidden struct {
	Payload *models.InfraError
}

func (o *DownloadClusterLogsForbidden) Error() string {
	return fmt.Sprintf("[GET /clusters/{cluster_id}/logs][%d] downloadClusterLogsForbidden  %+v", 403, o.Payload)
}

func (o *DownloadClusterLogsForbidden) GetPayload() *models.InfraError {
	return o.Payload
}

func (o *DownloadClusterLogsForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.InfraError)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDownloadClusterLogsNotFound creates a DownloadClusterLogsNotFound with default headers values
func NewDownloadClusterLogsNotFound() *DownloadClusterLogsNotFound {
	return &DownloadClusterLogsNotFound{}
}

/*DownloadClusterLogsNotFound handles this case with default header values.

Error.
*/
type DownloadClusterLogsNotFound struct {
	Payload *models.Error
}

func (o *DownloadClusterLogsNotFound) Error() string {
	return fmt.Sprintf("[GET /clusters/{cluster_id}/logs][%d] downloadClusterLogsNotFound  %+v", 404, o.Payload)
}

func (o *DownloadClusterLogsNotFound) GetPayload() *models.Error {
	return o.Payload
}

func (o *DownloadClusterLogsNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Error)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDownloadClusterLogsMethodNotAllowed creates a DownloadClusterLogsMethodNotAllowed with default headers values
func NewDownloadClusterLogsMethodNotAllowed() *DownloadClusterLogsMethodNotAllowed {
	return &DownloadClusterLogsMethodNotAllowed{}
}

/*DownloadClusterLogsMethodNotAllowed handles this case with default header values.

Method Not Allowed.
*/
type DownloadClusterLogsMethodNotAllowed struct {
	Payload *models.Error
}

func (o *DownloadClusterLogsMethodNotAllowed) Error() string {
	return fmt.Sprintf("[GET /clusters/{cluster_id}/logs][%d] downloadClusterLogsMethodNotAllowed  %+v", 405, o.Payload)
}

func (o *DownloadClusterLogsMethodNotAllowed) GetPayload() *models.Error {
	return o.Payload
}

func (o *DownloadClusterLogsMethodNotAllowed) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Error)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDownloadClusterLogsConflict creates a DownloadClusterLogsConflict with default headers values
func NewDownloadClusterLogsConflict() *DownloadClusterLogsConflict {
	return &DownloadClusterLogsConflict{}
}

/*DownloadClusterLogsConflict handles this case with default header values.

Error.
*/
type DownloadClusterLogsConflict struct {
	Payload *models.Error
}

func (o *DownloadClusterLogsConflict) Error() string {
	return fmt.Sprintf("[GET /clusters/{cluster_id}/logs][%d] downloadClusterLogsConflict  %+v", 409, o.Payload)
}

func (o *DownloadClusterLogsConflict) GetPayload() *models.Error {
	return o.Payload
}

func (o *DownloadClusterLogsConflict) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Error)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDownloadClusterLogsInternalServerError creates a DownloadClusterLogsInternalServerError with default headers values
func NewDownloadClusterLogsInternalServerError() *DownloadClusterLogsInternalServerError {
	return &DownloadClusterLogsInternalServerError{}
}

/*DownloadClusterLogsInternalServerError handles this case with default header values.

Error.
*/
type DownloadClusterLogsInternalServerError struct {
	Payload *models.Error
}

func (o *DownloadClusterLogsInternalServerError) Error() string {
	return fmt.Sprintf("[GET /clusters/{cluster_id}/logs][%d] downloadClusterLogsInternalServerError  %+v", 500, o.Payload)
}

func (o *DownloadClusterLogsInternalServerError) GetPayload() *models.Error {
	return o.Payload
}

func (o *DownloadClusterLogsInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Error)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
