// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// ImageCreateParams image create params
//
// swagger:model image-create-params
type ImageCreateParams struct {

	// Type of image that should be generated.
	ImageType ImageType `json:"image_type,omitempty"`

	// configuration of the mirror registries for discovery ISO and installed nodes
	MirrorRegistriesCaConfig *MirrorRegistriesCaConfig `json:"mirror_registries_ca_config,omitempty"`

	// SSH public key for debugging the installation.
	SSHPublicKey string `json:"ssh_public_key,omitempty"`

	// static network config
	StaticNetworkConfig []*HostStaticNetworkConfig `json:"static_network_config"`
}

// Validate validates this image create params
func (m *ImageCreateParams) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateImageType(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateMirrorRegistriesCaConfig(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStaticNetworkConfig(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ImageCreateParams) validateImageType(formats strfmt.Registry) error {

	if swag.IsZero(m.ImageType) { // not required
		return nil
	}

	if err := m.ImageType.Validate(formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("image_type")
		}
		return err
	}

	return nil
}

func (m *ImageCreateParams) validateMirrorRegistriesCaConfig(formats strfmt.Registry) error {

	if swag.IsZero(m.MirrorRegistriesCaConfig) { // not required
		return nil
	}

	if m.MirrorRegistriesCaConfig != nil {
		if err := m.MirrorRegistriesCaConfig.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("mirror_registries_ca_config")
			}
			return err
		}
	}

	return nil
}

func (m *ImageCreateParams) validateStaticNetworkConfig(formats strfmt.Registry) error {

	if swag.IsZero(m.StaticNetworkConfig) { // not required
		return nil
	}

	for i := 0; i < len(m.StaticNetworkConfig); i++ {
		if swag.IsZero(m.StaticNetworkConfig[i]) { // not required
			continue
		}

		if m.StaticNetworkConfig[i] != nil {
			if err := m.StaticNetworkConfig[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("static_network_config" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *ImageCreateParams) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ImageCreateParams) UnmarshalBinary(b []byte) error {
	var res ImageCreateParams
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
