// Code generated by go-swagger; DO NOT EDIT.

package installer

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/swag"

	"github.com/openshift/assisted-service/models"
)

// DownloadClusterISOHeadersOKCode is the HTTP code returned for type DownloadClusterISOHeadersOK
const DownloadClusterISOHeadersOKCode int = 200

/*DownloadClusterISOHeadersOK Success.

swagger:response downloadClusterISOHeadersOK
*/
type DownloadClusterISOHeadersOK struct {
	/*Size of the ISO in bytes

	 */
	ContentLength int64 `json:"Content-Length"`
}

// NewDownloadClusterISOHeadersOK creates DownloadClusterISOHeadersOK with default headers values
func NewDownloadClusterISOHeadersOK() *DownloadClusterISOHeadersOK {

	return &DownloadClusterISOHeadersOK{}
}

// WithContentLength adds the contentLength to the download cluster i s o headers o k response
func (o *DownloadClusterISOHeadersOK) WithContentLength(contentLength int64) *DownloadClusterISOHeadersOK {
	o.ContentLength = contentLength
	return o
}

// SetContentLength sets the contentLength to the download cluster i s o headers o k response
func (o *DownloadClusterISOHeadersOK) SetContentLength(contentLength int64) {
	o.ContentLength = contentLength
}

// WriteResponse to the client
func (o *DownloadClusterISOHeadersOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Content-Length

	contentLength := swag.FormatInt64(o.ContentLength)
	if contentLength != "" {
		rw.Header().Set("Content-Length", contentLength)
	}

	rw.Header().Del(runtime.HeaderContentType) //Remove Content-Type on empty responses

	rw.WriteHeader(200)
}

// DownloadClusterISOHeadersBadRequestCode is the HTTP code returned for type DownloadClusterISOHeadersBadRequest
const DownloadClusterISOHeadersBadRequestCode int = 400

/*DownloadClusterISOHeadersBadRequest Error.

swagger:response downloadClusterISOHeadersBadRequest
*/
type DownloadClusterISOHeadersBadRequest struct {

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewDownloadClusterISOHeadersBadRequest creates DownloadClusterISOHeadersBadRequest with default headers values
func NewDownloadClusterISOHeadersBadRequest() *DownloadClusterISOHeadersBadRequest {

	return &DownloadClusterISOHeadersBadRequest{}
}

// WithPayload adds the payload to the download cluster i s o headers bad request response
func (o *DownloadClusterISOHeadersBadRequest) WithPayload(payload *models.Error) *DownloadClusterISOHeadersBadRequest {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the download cluster i s o headers bad request response
func (o *DownloadClusterISOHeadersBadRequest) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *DownloadClusterISOHeadersBadRequest) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(400)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// DownloadClusterISOHeadersUnauthorizedCode is the HTTP code returned for type DownloadClusterISOHeadersUnauthorized
const DownloadClusterISOHeadersUnauthorizedCode int = 401

/*DownloadClusterISOHeadersUnauthorized Unauthorized.

swagger:response downloadClusterISOHeadersUnauthorized
*/
type DownloadClusterISOHeadersUnauthorized struct {

	/*
	  In: Body
	*/
	Payload *models.InfraError `json:"body,omitempty"`
}

// NewDownloadClusterISOHeadersUnauthorized creates DownloadClusterISOHeadersUnauthorized with default headers values
func NewDownloadClusterISOHeadersUnauthorized() *DownloadClusterISOHeadersUnauthorized {

	return &DownloadClusterISOHeadersUnauthorized{}
}

// WithPayload adds the payload to the download cluster i s o headers unauthorized response
func (o *DownloadClusterISOHeadersUnauthorized) WithPayload(payload *models.InfraError) *DownloadClusterISOHeadersUnauthorized {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the download cluster i s o headers unauthorized response
func (o *DownloadClusterISOHeadersUnauthorized) SetPayload(payload *models.InfraError) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *DownloadClusterISOHeadersUnauthorized) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(401)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// DownloadClusterISOHeadersForbiddenCode is the HTTP code returned for type DownloadClusterISOHeadersForbidden
const DownloadClusterISOHeadersForbiddenCode int = 403

/*DownloadClusterISOHeadersForbidden Forbidden.

swagger:response downloadClusterISOHeadersForbidden
*/
type DownloadClusterISOHeadersForbidden struct {

	/*
	  In: Body
	*/
	Payload *models.InfraError `json:"body,omitempty"`
}

// NewDownloadClusterISOHeadersForbidden creates DownloadClusterISOHeadersForbidden with default headers values
func NewDownloadClusterISOHeadersForbidden() *DownloadClusterISOHeadersForbidden {

	return &DownloadClusterISOHeadersForbidden{}
}

// WithPayload adds the payload to the download cluster i s o headers forbidden response
func (o *DownloadClusterISOHeadersForbidden) WithPayload(payload *models.InfraError) *DownloadClusterISOHeadersForbidden {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the download cluster i s o headers forbidden response
func (o *DownloadClusterISOHeadersForbidden) SetPayload(payload *models.InfraError) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *DownloadClusterISOHeadersForbidden) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(403)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// DownloadClusterISOHeadersNotFoundCode is the HTTP code returned for type DownloadClusterISOHeadersNotFound
const DownloadClusterISOHeadersNotFoundCode int = 404

/*DownloadClusterISOHeadersNotFound Error.

swagger:response downloadClusterISOHeadersNotFound
*/
type DownloadClusterISOHeadersNotFound struct {

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewDownloadClusterISOHeadersNotFound creates DownloadClusterISOHeadersNotFound with default headers values
func NewDownloadClusterISOHeadersNotFound() *DownloadClusterISOHeadersNotFound {

	return &DownloadClusterISOHeadersNotFound{}
}

// WithPayload adds the payload to the download cluster i s o headers not found response
func (o *DownloadClusterISOHeadersNotFound) WithPayload(payload *models.Error) *DownloadClusterISOHeadersNotFound {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the download cluster i s o headers not found response
func (o *DownloadClusterISOHeadersNotFound) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *DownloadClusterISOHeadersNotFound) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(404)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// DownloadClusterISOHeadersMethodNotAllowedCode is the HTTP code returned for type DownloadClusterISOHeadersMethodNotAllowed
const DownloadClusterISOHeadersMethodNotAllowedCode int = 405

/*DownloadClusterISOHeadersMethodNotAllowed Method Not Allowed.

swagger:response downloadClusterISOHeadersMethodNotAllowed
*/
type DownloadClusterISOHeadersMethodNotAllowed struct {
}

// NewDownloadClusterISOHeadersMethodNotAllowed creates DownloadClusterISOHeadersMethodNotAllowed with default headers values
func NewDownloadClusterISOHeadersMethodNotAllowed() *DownloadClusterISOHeadersMethodNotAllowed {

	return &DownloadClusterISOHeadersMethodNotAllowed{}
}

// WriteResponse to the client
func (o *DownloadClusterISOHeadersMethodNotAllowed) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.Header().Del(runtime.HeaderContentType) //Remove Content-Type on empty responses

	rw.WriteHeader(405)
}

// DownloadClusterISOHeadersConflictCode is the HTTP code returned for type DownloadClusterISOHeadersConflict
const DownloadClusterISOHeadersConflictCode int = 409

/*DownloadClusterISOHeadersConflict Error.

swagger:response downloadClusterISOHeadersConflict
*/
type DownloadClusterISOHeadersConflict struct {

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewDownloadClusterISOHeadersConflict creates DownloadClusterISOHeadersConflict with default headers values
func NewDownloadClusterISOHeadersConflict() *DownloadClusterISOHeadersConflict {

	return &DownloadClusterISOHeadersConflict{}
}

// WithPayload adds the payload to the download cluster i s o headers conflict response
func (o *DownloadClusterISOHeadersConflict) WithPayload(payload *models.Error) *DownloadClusterISOHeadersConflict {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the download cluster i s o headers conflict response
func (o *DownloadClusterISOHeadersConflict) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *DownloadClusterISOHeadersConflict) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(409)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// DownloadClusterISOHeadersInternalServerErrorCode is the HTTP code returned for type DownloadClusterISOHeadersInternalServerError
const DownloadClusterISOHeadersInternalServerErrorCode int = 500

/*DownloadClusterISOHeadersInternalServerError Error.

swagger:response downloadClusterISOHeadersInternalServerError
*/
type DownloadClusterISOHeadersInternalServerError struct {

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewDownloadClusterISOHeadersInternalServerError creates DownloadClusterISOHeadersInternalServerError with default headers values
func NewDownloadClusterISOHeadersInternalServerError() *DownloadClusterISOHeadersInternalServerError {

	return &DownloadClusterISOHeadersInternalServerError{}
}

// WithPayload adds the payload to the download cluster i s o headers internal server error response
func (o *DownloadClusterISOHeadersInternalServerError) WithPayload(payload *models.Error) *DownloadClusterISOHeadersInternalServerError {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the download cluster i s o headers internal server error response
func (o *DownloadClusterISOHeadersInternalServerError) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *DownloadClusterISOHeadersInternalServerError) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(500)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
