/*
Copyright (c) 2020 Red Hat, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// IMPORTANT: This file has been generated automatically, refrain from modifying it manually as all
// your changes will be lost when the file is generated again.

package v1 // github.com/openshift-online/ocm-sdk-go/accountsmgmt/v1

import (
	"context"
	"net/http"

	"github.com/golang/glog"
	"github.com/openshift-online/ocm-sdk-go/errors"
)

// NotifyServer represents the interface the manages the 'notify' resource.
type NotifyServer interface {

	// Add handles a request for the 'add' method.
	//
	// Notify user related to subscription/cluster via email
	Add(ctx context.Context, request *NotifyAddServerRequest, response *NotifyAddServerResponse) error
}

// NotifyAddServerRequest is the request for the 'add' method.
type NotifyAddServerRequest struct {
	body *SubscriptionNotify
}

// Body returns the value of the 'body' parameter.
//
//
func (r *NotifyAddServerRequest) Body() *SubscriptionNotify {
	if r == nil {
		return nil
	}
	return r.body
}

// GetBody returns the value of the 'body' parameter and
// a flag indicating if the parameter has a value.
//
//
func (r *NotifyAddServerRequest) GetBody() (value *SubscriptionNotify, ok bool) {
	ok = r != nil && r.body != nil
	if ok {
		value = r.body
	}
	return
}

// NotifyAddServerResponse is the response for the 'add' method.
type NotifyAddServerResponse struct {
	status int
	err    *errors.Error
	body   *SubscriptionNotify
}

// Body sets the value of the 'body' parameter.
//
//
func (r *NotifyAddServerResponse) Body(value *SubscriptionNotify) *NotifyAddServerResponse {
	r.body = value
	return r
}

// Status sets the status code.
func (r *NotifyAddServerResponse) Status(value int) *NotifyAddServerResponse {
	r.status = value
	return r
}

// dispatchNotify navigates the servers tree rooted at the given server
// till it finds one that matches the given set of path segments, and then invokes
// the corresponding server.
func dispatchNotify(w http.ResponseWriter, r *http.Request, server NotifyServer, segments []string) {
	if len(segments) == 0 {
		switch r.Method {
		case "POST":
			adaptNotifyAddRequest(w, r, server)
			return
		default:
			errors.SendMethodNotAllowed(w, r)
			return
		}
	}
	switch segments[0] {
	default:
		errors.SendNotFound(w, r)
		return
	}
}

// adaptNotifyAddRequest translates the given HTTP request into a call to
// the corresponding method of the given server. Then it translates the
// results returned by that method into an HTTP response.
func adaptNotifyAddRequest(w http.ResponseWriter, r *http.Request, server NotifyServer) {
	request := &NotifyAddServerRequest{}
	err := readNotifyAddRequest(request, r)
	if err != nil {
		glog.Errorf(
			"Can't read request for method '%s' and path '%s': %v",
			r.Method, r.URL.Path, err,
		)
		errors.SendInternalServerError(w, r)
		return
	}
	response := &NotifyAddServerResponse{}
	response.status = 201
	err = server.Add(r.Context(), request, response)
	if err != nil {
		glog.Errorf(
			"Can't process request for method '%s' and path '%s': %v",
			r.Method, r.URL.Path, err,
		)
		errors.SendInternalServerError(w, r)
		return
	}
	err = writeNotifyAddResponse(response, w)
	if err != nil {
		glog.Errorf(
			"Can't write response for method '%s' and path '%s': %v",
			r.Method, r.URL.Path, err,
		)
		return
	}
}
