// Code generated by go-swagger; DO NOT EDIT.

package installer

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"

	"github.com/openshift/assisted-service/models"
)

// NewRegisterHostParams creates a new RegisterHostParams object
// with the default values initialized.
func NewRegisterHostParams() *RegisterHostParams {
	var ()
	return &RegisterHostParams{

		timeout: cr.DefaultTimeout,
	}
}

// NewRegisterHostParamsWithTimeout creates a new RegisterHostParams object
// with the default values initialized, and the ability to set a timeout on a request
func NewRegisterHostParamsWithTimeout(timeout time.Duration) *RegisterHostParams {
	var ()
	return &RegisterHostParams{

		timeout: timeout,
	}
}

// NewRegisterHostParamsWithContext creates a new RegisterHostParams object
// with the default values initialized, and the ability to set a context for a request
func NewRegisterHostParamsWithContext(ctx context.Context) *RegisterHostParams {
	var ()
	return &RegisterHostParams{

		Context: ctx,
	}
}

// NewRegisterHostParamsWithHTTPClient creates a new RegisterHostParams object
// with the default values initialized, and the ability to set a custom HTTPClient for a request
func NewRegisterHostParamsWithHTTPClient(client *http.Client) *RegisterHostParams {
	var ()
	return &RegisterHostParams{
		HTTPClient: client,
	}
}

/*RegisterHostParams contains all the parameters to send to the API endpoint
for the register host operation typically these are written to a http.Request
*/
type RegisterHostParams struct {

	/*ClusterID*/
	ClusterID strfmt.UUID
	/*DiscoveryAgentVersion*/
	DiscoveryAgentVersion *string
	/*NewHostParams*/
	NewHostParams *models.HostCreateParams

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithTimeout adds the timeout to the register host params
func (o *RegisterHostParams) WithTimeout(timeout time.Duration) *RegisterHostParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the register host params
func (o *RegisterHostParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the register host params
func (o *RegisterHostParams) WithContext(ctx context.Context) *RegisterHostParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the register host params
func (o *RegisterHostParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the register host params
func (o *RegisterHostParams) WithHTTPClient(client *http.Client) *RegisterHostParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the register host params
func (o *RegisterHostParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithClusterID adds the clusterID to the register host params
func (o *RegisterHostParams) WithClusterID(clusterID strfmt.UUID) *RegisterHostParams {
	o.SetClusterID(clusterID)
	return o
}

// SetClusterID adds the clusterId to the register host params
func (o *RegisterHostParams) SetClusterID(clusterID strfmt.UUID) {
	o.ClusterID = clusterID
}

// WithDiscoveryAgentVersion adds the discoveryAgentVersion to the register host params
func (o *RegisterHostParams) WithDiscoveryAgentVersion(discoveryAgentVersion *string) *RegisterHostParams {
	o.SetDiscoveryAgentVersion(discoveryAgentVersion)
	return o
}

// SetDiscoveryAgentVersion adds the discoveryAgentVersion to the register host params
func (o *RegisterHostParams) SetDiscoveryAgentVersion(discoveryAgentVersion *string) {
	o.DiscoveryAgentVersion = discoveryAgentVersion
}

// WithNewHostParams adds the newHostParams to the register host params
func (o *RegisterHostParams) WithNewHostParams(newHostParams *models.HostCreateParams) *RegisterHostParams {
	o.SetNewHostParams(newHostParams)
	return o
}

// SetNewHostParams adds the newHostParams to the register host params
func (o *RegisterHostParams) SetNewHostParams(newHostParams *models.HostCreateParams) {
	o.NewHostParams = newHostParams
}

// WriteToRequest writes these params to a swagger request
func (o *RegisterHostParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param cluster_id
	if err := r.SetPathParam("cluster_id", o.ClusterID.String()); err != nil {
		return err
	}

	if o.DiscoveryAgentVersion != nil {

		// header param discovery_agent_version
		if err := r.SetHeaderParam("discovery_agent_version", *o.DiscoveryAgentVersion); err != nil {
			return err
		}

	}

	if o.NewHostParams != nil {
		if err := r.SetBodyParam(o.NewHostParams); err != nil {
			return err
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
