// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// HostProgressInfo host progress info
//
// swagger:model host-progress-info
type HostProgressInfo struct {

	// current stage
	// Required: true
	CurrentStage HostStage `json:"current_stage"`

	// progress info
	ProgressInfo string `json:"progress_info,omitempty" gorm:"type:varchar(2048)"`

	// Time at which the current progress stage started
	// Format: date-time
	StageStartedAt strfmt.DateTime `json:"stage_started_at,omitempty" gorm:"type:timestamp with time zone"`

	// Time at which the current progress stage was last updated
	// Format: date-time
	StageUpdatedAt strfmt.DateTime `json:"stage_updated_at,omitempty" gorm:"type:timestamp with time zone"`
}

// Validate validates this host progress info
func (m *HostProgressInfo) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateCurrentStage(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStageStartedAt(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStageUpdatedAt(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HostProgressInfo) validateCurrentStage(formats strfmt.Registry) error {

	if err := m.CurrentStage.Validate(formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("current_stage")
		}
		return err
	}

	return nil
}

func (m *HostProgressInfo) validateStageStartedAt(formats strfmt.Registry) error {

	if swag.IsZero(m.StageStartedAt) { // not required
		return nil
	}

	if err := validate.FormatOf("stage_started_at", "body", "date-time", m.StageStartedAt.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *HostProgressInfo) validateStageUpdatedAt(formats strfmt.Registry) error {

	if swag.IsZero(m.StageUpdatedAt) { // not required
		return nil
	}

	if err := validate.FormatOf("stage_updated_at", "body", "date-time", m.StageUpdatedAt.String(), formats); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *HostProgressInfo) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *HostProgressInfo) UnmarshalBinary(b []byte) error {
	var res HostProgressInfo
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
