// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// InfraError infra error
//
// swagger:model infra_error
type InfraError struct {

	// Numeric identifier of the error.
	// Required: true
	// Maximum: 403
	// Minimum: 401
	Code *int32 `json:"code"`

	// Human readable description of the error.
	// Required: true
	Message *string `json:"message"`
}

// Validate validates this infra error
func (m *InfraError) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateCode(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateMessage(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *InfraError) validateCode(formats strfmt.Registry) error {

	if err := validate.Required("code", "body", m.Code); err != nil {
		return err
	}

	if err := validate.MinimumInt("code", "body", int64(*m.Code), 401, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("code", "body", int64(*m.Code), 403, false); err != nil {
		return err
	}

	return nil
}

func (m *InfraError) validateMessage(formats strfmt.Registry) error {

	if err := validate.Required("message", "body", m.Message); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *InfraError) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *InfraError) UnmarshalBinary(b []byte) error {
	var res InfraError
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
