// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// DhcpAllocationRequest dhcp allocation request
//
// swagger:model dhcp_allocation_request
type DhcpAllocationRequest struct {

	// Contents of lease file to be used for API virtual IP.
	APIVipLease string `json:"api_vip_lease,omitempty"`

	// MAC address for the API virtual IP.
	// Required: true
	// Format: mac
	APIVipMac *strfmt.MAC `json:"api_vip_mac"`

	// Contents of lease file to be used for for Ingress virtual IP.
	IngressVipLease string `json:"ingress_vip_lease,omitempty"`

	// MAC address for the Ingress virtual IP.
	// Required: true
	// Format: mac
	IngressVipMac *strfmt.MAC `json:"ingress_vip_mac"`

	// The network interface (NIC) to run the DHCP requests on.
	// Required: true
	Interface *string `json:"interface"`
}

// Validate validates this dhcp allocation request
func (m *DhcpAllocationRequest) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateAPIVipMac(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateIngressVipMac(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateInterface(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DhcpAllocationRequest) validateAPIVipMac(formats strfmt.Registry) error {

	if err := validate.Required("api_vip_mac", "body", m.APIVipMac); err != nil {
		return err
	}

	if err := validate.FormatOf("api_vip_mac", "body", "mac", m.APIVipMac.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *DhcpAllocationRequest) validateIngressVipMac(formats strfmt.Registry) error {

	if err := validate.Required("ingress_vip_mac", "body", m.IngressVipMac); err != nil {
		return err
	}

	if err := validate.FormatOf("ingress_vip_mac", "body", "mac", m.IngressVipMac.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *DhcpAllocationRequest) validateInterface(formats strfmt.Registry) error {

	if err := validate.Required("interface", "body", m.Interface); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this dhcp allocation request based on context it is used
func (m *DhcpAllocationRequest) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *DhcpAllocationRequest) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DhcpAllocationRequest) UnmarshalBinary(b []byte) error {
	var res DhcpAllocationRequest
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
