// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// ImportClusterParams import cluster params
//
// swagger:model import-cluster-params
type ImportClusterParams struct {

	// The domain name used to reach the OpenShift cluster API.
	// Required: true
	APIVipDnsname *string `json:"api_vip_dnsname"`

	// OpenShift cluster name.
	// Required: true
	Name *string `json:"name"`

	// The id of the OCP cluster, that hosts will be added to
	// Required: true
	// Format: uuid
	OpenshiftClusterID *strfmt.UUID `json:"openshift_cluster_id"`

	// Version of the OpenShift cluster.
	OpenshiftVersion string `json:"openshift_version,omitempty"`
}

// Validate validates this import cluster params
func (m *ImportClusterParams) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateAPIVipDnsname(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateName(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateOpenshiftClusterID(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ImportClusterParams) validateAPIVipDnsname(formats strfmt.Registry) error {

	if err := validate.Required("api_vip_dnsname", "body", m.APIVipDnsname); err != nil {
		return err
	}

	return nil
}

func (m *ImportClusterParams) validateName(formats strfmt.Registry) error {

	if err := validate.Required("name", "body", m.Name); err != nil {
		return err
	}

	return nil
}

func (m *ImportClusterParams) validateOpenshiftClusterID(formats strfmt.Registry) error {

	if err := validate.Required("openshift_cluster_id", "body", m.OpenshiftClusterID); err != nil {
		return err
	}

	if err := validate.FormatOf("openshift_cluster_id", "body", "uuid", m.OpenshiftClusterID.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this import cluster params based on context it is used
func (m *ImportClusterParams) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *ImportClusterParams) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ImportClusterParams) UnmarshalBinary(b []byte) error {
	var res ImportClusterParams
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
