// Code generated by go-swagger; DO NOT EDIT.

package events

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewV2ListEventsParams creates a new V2ListEventsParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewV2ListEventsParams() *V2ListEventsParams {
	return &V2ListEventsParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewV2ListEventsParamsWithTimeout creates a new V2ListEventsParams object
// with the ability to set a timeout on a request.
func NewV2ListEventsParamsWithTimeout(timeout time.Duration) *V2ListEventsParams {
	return &V2ListEventsParams{
		timeout: timeout,
	}
}

// NewV2ListEventsParamsWithContext creates a new V2ListEventsParams object
// with the ability to set a context for a request.
func NewV2ListEventsParamsWithContext(ctx context.Context) *V2ListEventsParams {
	return &V2ListEventsParams{
		Context: ctx,
	}
}

// NewV2ListEventsParamsWithHTTPClient creates a new V2ListEventsParams object
// with the ability to set a custom HTTPClient for a request.
func NewV2ListEventsParamsWithHTTPClient(client *http.Client) *V2ListEventsParams {
	return &V2ListEventsParams{
		HTTPClient: client,
	}
}

/* V2ListEventsParams contains all the parameters to send to the API endpoint
   for the v2 list events operation.

   Typically these are written to a http.Request.
*/
type V2ListEventsParams struct {

	/* Categories.

	   A comma-separated list of event categories.
	*/
	Categories []string

	/* ClusterID.

	   The cluster to return events for.

	   Format: uuid
	*/
	ClusterID *strfmt.UUID

	/* HostID.

	   A host in the specified cluster to return events for.

	   Format: uuid
	*/
	HostID *strfmt.UUID

	/* InfraEnvID.

	   The infra-env to return events for.

	   Format: uuid
	*/
	InfraEnvID *strfmt.UUID

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the v2 list events params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *V2ListEventsParams) WithDefaults() *V2ListEventsParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the v2 list events params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *V2ListEventsParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the v2 list events params
func (o *V2ListEventsParams) WithTimeout(timeout time.Duration) *V2ListEventsParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the v2 list events params
func (o *V2ListEventsParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the v2 list events params
func (o *V2ListEventsParams) WithContext(ctx context.Context) *V2ListEventsParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the v2 list events params
func (o *V2ListEventsParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the v2 list events params
func (o *V2ListEventsParams) WithHTTPClient(client *http.Client) *V2ListEventsParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the v2 list events params
func (o *V2ListEventsParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithCategories adds the categories to the v2 list events params
func (o *V2ListEventsParams) WithCategories(categories []string) *V2ListEventsParams {
	o.SetCategories(categories)
	return o
}

// SetCategories adds the categories to the v2 list events params
func (o *V2ListEventsParams) SetCategories(categories []string) {
	o.Categories = categories
}

// WithClusterID adds the clusterID to the v2 list events params
func (o *V2ListEventsParams) WithClusterID(clusterID *strfmt.UUID) *V2ListEventsParams {
	o.SetClusterID(clusterID)
	return o
}

// SetClusterID adds the clusterId to the v2 list events params
func (o *V2ListEventsParams) SetClusterID(clusterID *strfmt.UUID) {
	o.ClusterID = clusterID
}

// WithHostID adds the hostID to the v2 list events params
func (o *V2ListEventsParams) WithHostID(hostID *strfmt.UUID) *V2ListEventsParams {
	o.SetHostID(hostID)
	return o
}

// SetHostID adds the hostId to the v2 list events params
func (o *V2ListEventsParams) SetHostID(hostID *strfmt.UUID) {
	o.HostID = hostID
}

// WithInfraEnvID adds the infraEnvID to the v2 list events params
func (o *V2ListEventsParams) WithInfraEnvID(infraEnvID *strfmt.UUID) *V2ListEventsParams {
	o.SetInfraEnvID(infraEnvID)
	return o
}

// SetInfraEnvID adds the infraEnvId to the v2 list events params
func (o *V2ListEventsParams) SetInfraEnvID(infraEnvID *strfmt.UUID) {
	o.InfraEnvID = infraEnvID
}

// WriteToRequest writes these params to a swagger request
func (o *V2ListEventsParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Categories != nil {

		// binding items for categories
		joinedCategories := o.bindParamCategories(reg)

		// query array param categories
		if err := r.SetQueryParam("categories", joinedCategories...); err != nil {
			return err
		}
	}

	if o.ClusterID != nil {

		// query param cluster_id
		var qrClusterID strfmt.UUID

		if o.ClusterID != nil {
			qrClusterID = *o.ClusterID
		}
		qClusterID := qrClusterID.String()
		if qClusterID != "" {

			if err := r.SetQueryParam("cluster_id", qClusterID); err != nil {
				return err
			}
		}
	}

	if o.HostID != nil {

		// query param host_id
		var qrHostID strfmt.UUID

		if o.HostID != nil {
			qrHostID = *o.HostID
		}
		qHostID := qrHostID.String()
		if qHostID != "" {

			if err := r.SetQueryParam("host_id", qHostID); err != nil {
				return err
			}
		}
	}

	if o.InfraEnvID != nil {

		// query param infra_env_id
		var qrInfraEnvID strfmt.UUID

		if o.InfraEnvID != nil {
			qrInfraEnvID = *o.InfraEnvID
		}
		qInfraEnvID := qrInfraEnvID.String()
		if qInfraEnvID != "" {

			if err := r.SetQueryParam("infra_env_id", qInfraEnvID); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamV2ListEvents binds the parameter categories
func (o *V2ListEventsParams) bindParamCategories(formats strfmt.Registry) []string {
	categoriesIR := o.Categories

	var categoriesIC []string
	for _, categoriesIIR := range categoriesIR { // explode []string

		categoriesIIV := categoriesIIR // string as string
		categoriesIC = append(categoriesIC, categoriesIIV)
	}

	// items.CollectionFormat: ""
	categoriesIS := swag.JoinByFormat(categoriesIC, "")

	return categoriesIS
}
