// Code generated by go-swagger; DO NOT EDIT.

package installer

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
)

// NewGetInfraEnvPresignedFileURLParams creates a new GetInfraEnvPresignedFileURLParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewGetInfraEnvPresignedFileURLParams() *GetInfraEnvPresignedFileURLParams {
	return &GetInfraEnvPresignedFileURLParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewGetInfraEnvPresignedFileURLParamsWithTimeout creates a new GetInfraEnvPresignedFileURLParams object
// with the ability to set a timeout on a request.
func NewGetInfraEnvPresignedFileURLParamsWithTimeout(timeout time.Duration) *GetInfraEnvPresignedFileURLParams {
	return &GetInfraEnvPresignedFileURLParams{
		timeout: timeout,
	}
}

// NewGetInfraEnvPresignedFileURLParamsWithContext creates a new GetInfraEnvPresignedFileURLParams object
// with the ability to set a context for a request.
func NewGetInfraEnvPresignedFileURLParamsWithContext(ctx context.Context) *GetInfraEnvPresignedFileURLParams {
	return &GetInfraEnvPresignedFileURLParams{
		Context: ctx,
	}
}

// NewGetInfraEnvPresignedFileURLParamsWithHTTPClient creates a new GetInfraEnvPresignedFileURLParams object
// with the ability to set a custom HTTPClient for a request.
func NewGetInfraEnvPresignedFileURLParamsWithHTTPClient(client *http.Client) *GetInfraEnvPresignedFileURLParams {
	return &GetInfraEnvPresignedFileURLParams{
		HTTPClient: client,
	}
}

/* GetInfraEnvPresignedFileURLParams contains all the parameters to send to the API endpoint
   for the get infra env presigned file URL operation.

   Typically these are written to a http.Request.
*/
type GetInfraEnvPresignedFileURLParams struct {

	/* FileName.

	   The file to be downloaded.
	*/
	FileName string

	/* InfraEnvID.

	   The file's infra-env.

	   Format: uuid
	*/
	InfraEnvID strfmt.UUID

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the get infra env presigned file URL params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GetInfraEnvPresignedFileURLParams) WithDefaults() *GetInfraEnvPresignedFileURLParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the get infra env presigned file URL params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GetInfraEnvPresignedFileURLParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the get infra env presigned file URL params
func (o *GetInfraEnvPresignedFileURLParams) WithTimeout(timeout time.Duration) *GetInfraEnvPresignedFileURLParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the get infra env presigned file URL params
func (o *GetInfraEnvPresignedFileURLParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the get infra env presigned file URL params
func (o *GetInfraEnvPresignedFileURLParams) WithContext(ctx context.Context) *GetInfraEnvPresignedFileURLParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the get infra env presigned file URL params
func (o *GetInfraEnvPresignedFileURLParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the get infra env presigned file URL params
func (o *GetInfraEnvPresignedFileURLParams) WithHTTPClient(client *http.Client) *GetInfraEnvPresignedFileURLParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the get infra env presigned file URL params
func (o *GetInfraEnvPresignedFileURLParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithFileName adds the fileName to the get infra env presigned file URL params
func (o *GetInfraEnvPresignedFileURLParams) WithFileName(fileName string) *GetInfraEnvPresignedFileURLParams {
	o.SetFileName(fileName)
	return o
}

// SetFileName adds the fileName to the get infra env presigned file URL params
func (o *GetInfraEnvPresignedFileURLParams) SetFileName(fileName string) {
	o.FileName = fileName
}

// WithInfraEnvID adds the infraEnvID to the get infra env presigned file URL params
func (o *GetInfraEnvPresignedFileURLParams) WithInfraEnvID(infraEnvID strfmt.UUID) *GetInfraEnvPresignedFileURLParams {
	o.SetInfraEnvID(infraEnvID)
	return o
}

// SetInfraEnvID adds the infraEnvId to the get infra env presigned file URL params
func (o *GetInfraEnvPresignedFileURLParams) SetInfraEnvID(infraEnvID strfmt.UUID) {
	o.InfraEnvID = infraEnvID
}

// WriteToRequest writes these params to a swagger request
func (o *GetInfraEnvPresignedFileURLParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// query param file_name
	qrFileName := o.FileName
	qFileName := qrFileName
	if qFileName != "" {

		if err := r.SetQueryParam("file_name", qFileName); err != nil {
			return err
		}
	}

	// path param infra_env_id
	if err := r.SetPathParam("infra_env_id", o.InfraEnvID.String()); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
