// Code generated by go-swagger; DO NOT EDIT.

package installer

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"io"

	"github.com/go-openapi/runtime"

	strfmt "github.com/go-openapi/strfmt"
)

//go:generate mockery -name API -inpkg

// API is the interface of the installer client
type API interface {
	/*
	   BindHost Bind host to a cluster*/
	BindHost(ctx context.Context, params *BindHostParams) (*BindHostOK, error)
	/*
	   DeregisterInfraEnv Deletes an infra-env.*/
	DeregisterInfraEnv(ctx context.Context, params *DeregisterInfraEnvParams) (*DeregisterInfraEnvNoContent, error)
	/*
	   DownloadMinimalInitrd Get the initial ramdisk for minimal ISO based installations.
	*/
	DownloadMinimalInitrd(ctx context.Context, params *DownloadMinimalInitrdParams, writer io.Writer) (*DownloadMinimalInitrdOK, *DownloadMinimalInitrdNoContent, error)
	/*
	   GetClusterSupportedPlatforms A list of platforms that this cluster can support in its current configuration.*/
	GetClusterSupportedPlatforms(ctx context.Context, params *GetClusterSupportedPlatformsParams) (*GetClusterSupportedPlatformsOK, error)
	/*
	   GetInfraEnv Retrieves the details of the infra-env.*/
	GetInfraEnv(ctx context.Context, params *GetInfraEnvParams) (*GetInfraEnvOK, error)
	/*
	   GetInfraEnvDownloadURL Creates a new pre-signed image download URL for the infra-env.*/
	GetInfraEnvDownloadURL(ctx context.Context, params *GetInfraEnvDownloadURLParams) (*GetInfraEnvDownloadURLOK, error)
	/*
	   GetInfraEnvPresignedFileURL Creates a new pre-signed download URL for the infra-env.*/
	GetInfraEnvPresignedFileURL(ctx context.Context, params *GetInfraEnvPresignedFileURLParams) (*GetInfraEnvPresignedFileURLOK, error)
	/*
	   ListClusterHosts Get a list of cluster hosts according to supplied filters.*/
	ListClusterHosts(ctx context.Context, params *ListClusterHostsParams) (*ListClusterHostsOK, error)
	/*
	   ListInfraEnvs Retrieves the list of infra-envs.*/
	ListInfraEnvs(ctx context.Context, params *ListInfraEnvsParams) (*ListInfraEnvsOK, error)
	/*
	   RegenerateInfraEnvSigningKey Regenerate InfraEnv token signing key.*/
	RegenerateInfraEnvSigningKey(ctx context.Context, params *RegenerateInfraEnvSigningKeyParams) (*RegenerateInfraEnvSigningKeyNoContent, error)
	/*
	   RegisterInfraEnv Creates a new OpenShift Discovery ISO.*/
	RegisterInfraEnv(ctx context.Context, params *RegisterInfraEnvParams) (*RegisterInfraEnvCreated, error)
	/*
	   TransformClusterToDay2 Transforming cluster to day2 and allowing adding hosts*/
	TransformClusterToDay2(ctx context.Context, params *TransformClusterToDay2Params) (*TransformClusterToDay2Accepted, error)
	/*
	   UnbindHost Unbind host to a cluster*/
	UnbindHost(ctx context.Context, params *UnbindHostParams) (*UnbindHostOK, error)
	/*
	   UpdateInfraEnv Updates an infra-env.*/
	UpdateInfraEnv(ctx context.Context, params *UpdateInfraEnvParams) (*UpdateInfraEnvCreated, error)
	/*
	   V2CancelInstallation Cancels an ongoing installation.*/
	V2CancelInstallation(ctx context.Context, params *V2CancelInstallationParams) (*V2CancelInstallationAccepted, error)
	/*
	   V2DownloadClusterCredentials Downloads credentials relating to the installed/installing cluster.*/
	V2DownloadClusterCredentials(ctx context.Context, params *V2DownloadClusterCredentialsParams, writer io.Writer) (*V2DownloadClusterCredentialsOK, error)
	/*
	   V2DownloadClusterFiles Downloads files relating to the installed/installing cluster.*/
	V2DownloadClusterFiles(ctx context.Context, params *V2DownloadClusterFilesParams, writer io.Writer) (*V2DownloadClusterFilesOK, error)
	/*
	   V2DownloadClusterLogs Download cluster logs.*/
	V2DownloadClusterLogs(ctx context.Context, params *V2DownloadClusterLogsParams, writer io.Writer) (*V2DownloadClusterLogsOK, error)
	/*
	   V2GetClusterDefaultConfig Get the default values for various cluster properties.*/
	V2GetClusterDefaultConfig(ctx context.Context, params *V2GetClusterDefaultConfigParams) (*V2GetClusterDefaultConfigOK, error)
	/*
	   V2GetCredentials Get the cluster admin credentials.*/
	V2GetCredentials(ctx context.Context, params *V2GetCredentialsParams) (*V2GetCredentialsOK, error)
	/*
	   V2GetPresignedForClusterCredentials Get the cluster admin credentials.*/
	V2GetPresignedForClusterCredentials(ctx context.Context, params *V2GetPresignedForClusterCredentialsParams) (*V2GetPresignedForClusterCredentialsOK, error)
	/*
	   V2GetPresignedForClusterFiles Retrieves a pre-signed S3 URL for downloading cluster files.*/
	V2GetPresignedForClusterFiles(ctx context.Context, params *V2GetPresignedForClusterFilesParams) (*V2GetPresignedForClusterFilesOK, error)
	/*
	   V2UpdateCluster Updates an OpenShift cluster definition.*/
	V2UpdateCluster(ctx context.Context, params *V2UpdateClusterParams) (*V2UpdateClusterCreated, error)
	/*
	   V2UploadLogs Agent API to upload logs.*/
	V2UploadLogs(ctx context.Context, params *V2UploadLogsParams) (*V2UploadLogsNoContent, error)
	/*
	   V2CompleteInstallation Agent API to mark a finalizing installation as complete.*/
	V2CompleteInstallation(ctx context.Context, params *V2CompleteInstallationParams) (*V2CompleteInstallationAccepted, error)
	/*
	   V2DeregisterCluster Deletes an OpenShift cluster definition.*/
	V2DeregisterCluster(ctx context.Context, params *V2DeregisterClusterParams) (*V2DeregisterClusterNoContent, error)
	/*
	   V2DeregisterHost Deregisters an OpenShift host.*/
	V2DeregisterHost(ctx context.Context, params *V2DeregisterHostParams) (*V2DeregisterHostNoContent, error)
	/*
	   V2DownloadHostIgnition Downloads the customized ignition file for this bound host, produces octet stream. For unbound host - error is returned*/
	V2DownloadHostIgnition(ctx context.Context, params *V2DownloadHostIgnitionParams, writer io.Writer) (*V2DownloadHostIgnitionOK, error)
	/*
	   V2DownloadInfraEnvFiles Downloads the customized ignition file for this host*/
	V2DownloadInfraEnvFiles(ctx context.Context, params *V2DownloadInfraEnvFilesParams, writer io.Writer) (*V2DownloadInfraEnvFilesOK, error)
	/*
	   V2GetCluster Retrieves the details of the OpenShift cluster.*/
	V2GetCluster(ctx context.Context, params *V2GetClusterParams) (*V2GetClusterOK, error)
	/*
	   V2GetClusterInstallConfig Get the cluster's install config YAML.*/
	V2GetClusterInstallConfig(ctx context.Context, params *V2GetClusterInstallConfigParams) (*V2GetClusterInstallConfigOK, error)
	/*
	   V2GetHost Retrieves the details of the OpenShift host.*/
	V2GetHost(ctx context.Context, params *V2GetHostParams) (*V2GetHostOK, error)
	/*
	   V2GetHostIgnition Fetch the ignition file for this host as a string. In case of unbound host produces an error*/
	V2GetHostIgnition(ctx context.Context, params *V2GetHostIgnitionParams) (*V2GetHostIgnitionOK, error)
	/*
	   V2GetNextSteps Retrieves the next operations that the host agent needs to perform.*/
	V2GetNextSteps(ctx context.Context, params *V2GetNextStepsParams) (*V2GetNextStepsOK, error)
	/*
	   V2GetPreflightRequirements Get preflight requirements for a cluster.*/
	V2GetPreflightRequirements(ctx context.Context, params *V2GetPreflightRequirementsParams) (*V2GetPreflightRequirementsOK, error)
	/*
	   V2ImportCluster Import an AI cluster using minimal data assosiated with existing OCP cluster, in order to allow adding day2 hosts to that cluster*/
	V2ImportCluster(ctx context.Context, params *V2ImportClusterParams) (*V2ImportClusterCreated, error)
	/*
	   V2InstallCluster Installs the OpenShift cluster.*/
	V2InstallCluster(ctx context.Context, params *V2InstallClusterParams) (*V2InstallClusterAccepted, error)
	/*
	   V2InstallHost install specific host for day2 cluster.*/
	V2InstallHost(ctx context.Context, params *V2InstallHostParams) (*V2InstallHostAccepted, error)
	/*
	   V2ListClusters Retrieves the list of OpenShift clusters.*/
	V2ListClusters(ctx context.Context, params *V2ListClustersParams) (*V2ListClustersOK, error)
	/*
	   V2ListFeatureSupportLevels Retrieves the support levels for features for each OpenShift version.*/
	V2ListFeatureSupportLevels(ctx context.Context, params *V2ListFeatureSupportLevelsParams) (*V2ListFeatureSupportLevelsOK, error)
	/*
	   V2ListHosts Retrieves the list of OpenShift hosts that belong the infra-env.*/
	V2ListHosts(ctx context.Context, params *V2ListHostsParams) (*V2ListHostsOK, error)
	/*
	   V2PostStepReply Posts the result of the operations from the host agent.*/
	V2PostStepReply(ctx context.Context, params *V2PostStepReplyParams) (*V2PostStepReplyNoContent, error)
	/*
	   V2RegisterCluster Creates a new OpenShift cluster definition.*/
	V2RegisterCluster(ctx context.Context, params *V2RegisterClusterParams) (*V2RegisterClusterCreated, error)
	/*
	   V2RegisterHost Registers a new OpenShift agent.*/
	V2RegisterHost(ctx context.Context, params *V2RegisterHostParams) (*V2RegisterHostCreated, error)
	/*
	   V2ResetCluster Resets a failed installation.*/
	V2ResetCluster(ctx context.Context, params *V2ResetClusterParams) (*V2ResetClusterAccepted, error)
	/*
	   V2ResetHost reset a failed host for day2 cluster.*/
	V2ResetHost(ctx context.Context, params *V2ResetHostParams) (*V2ResetHostOK, error)
	/*
	   V2ResetHostValidation resets failed host validation

	   Reset failed host validation. It may be performed on any host validation with persistent validation result.*/
	V2ResetHostValidation(ctx context.Context, params *V2ResetHostValidationParams) (*V2ResetHostValidationOK, error)
	/*
	   V2UpdateClusterInstallConfig Override values in the install config.*/
	V2UpdateClusterInstallConfig(ctx context.Context, params *V2UpdateClusterInstallConfigParams) (*V2UpdateClusterInstallConfigCreated, error)
	/*
	   V2UpdateClusterLogsProgress Update log collection state and progress.*/
	V2UpdateClusterLogsProgress(ctx context.Context, params *V2UpdateClusterLogsProgressParams) (*V2UpdateClusterLogsProgressNoContent, error)
	/*
	   V2UpdateHost Update an Openshift host*/
	V2UpdateHost(ctx context.Context, params *V2UpdateHostParams) (*V2UpdateHostCreated, error)
	/*
	   V2UpdateHostIgnition Patch the ignition file for this host*/
	V2UpdateHostIgnition(ctx context.Context, params *V2UpdateHostIgnitionParams) (*V2UpdateHostIgnitionCreated, error)
	/*
	   V2UpdateHostInstallProgress Update installation progress.*/
	V2UpdateHostInstallProgress(ctx context.Context, params *V2UpdateHostInstallProgressParams) (*V2UpdateHostInstallProgressOK, error)
	/*
	   V2UpdateHostInstallerArgs Updates a host's installer arguments.*/
	V2UpdateHostInstallerArgs(ctx context.Context, params *V2UpdateHostInstallerArgsParams) (*V2UpdateHostInstallerArgsCreated, error)
	/*
	   V2UpdateHostLogsProgress Update log collection state and progress.*/
	V2UpdateHostLogsProgress(ctx context.Context, params *V2UpdateHostLogsProgressParams) (*V2UpdateHostLogsProgressNoContent, error)
	/*
	   V2UploadClusterIngressCert Transfer the ingress certificate for the cluster.*/
	V2UploadClusterIngressCert(ctx context.Context, params *V2UploadClusterIngressCertParams) (*V2UploadClusterIngressCertCreated, error)
}

// New creates a new installer API client.
func New(transport runtime.ClientTransport, formats strfmt.Registry, authInfo runtime.ClientAuthInfoWriter) *Client {
	return &Client{
		transport: transport,
		formats:   formats,
		authInfo:  authInfo,
	}
}

/*
Client for installer API
*/
type Client struct {
	transport runtime.ClientTransport
	formats   strfmt.Registry
	authInfo  runtime.ClientAuthInfoWriter
}

/*
BindHost Bind host to a cluster
*/
func (a *Client) BindHost(ctx context.Context, params *BindHostParams) (*BindHostOK, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "BindHost",
		Method:             "POST",
		PathPattern:        "/v2/infra-envs/{infra_env_id}/hosts/{host_id}/actions/bind",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &BindHostReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*BindHostOK), nil

}

/*
DeregisterInfraEnv Deletes an infra-env.
*/
func (a *Client) DeregisterInfraEnv(ctx context.Context, params *DeregisterInfraEnvParams) (*DeregisterInfraEnvNoContent, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "DeregisterInfraEnv",
		Method:             "DELETE",
		PathPattern:        "/v2/infra-envs/{infra_env_id}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &DeregisterInfraEnvReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*DeregisterInfraEnvNoContent), nil

}

/*
DownloadMinimalInitrd Get the initial ramdisk for minimal ISO based installations.

*/
func (a *Client) DownloadMinimalInitrd(ctx context.Context, params *DownloadMinimalInitrdParams, writer io.Writer) (*DownloadMinimalInitrdOK, *DownloadMinimalInitrdNoContent, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "DownloadMinimalInitrd",
		Method:             "GET",
		PathPattern:        "/v2/infra-envs/{infra_env_id}/downloads/minimal-initrd",
		ProducesMediaTypes: []string{"application/octet-stream"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &DownloadMinimalInitrdReader{formats: a.formats, writer: writer},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *DownloadMinimalInitrdOK:
		return value, nil, nil
	case *DownloadMinimalInitrdNoContent:
		return nil, value, nil
	}
	return nil, nil, nil

}

/*
GetClusterSupportedPlatforms A list of platforms that this cluster can support in its current configuration.
*/
func (a *Client) GetClusterSupportedPlatforms(ctx context.Context, params *GetClusterSupportedPlatformsParams) (*GetClusterSupportedPlatformsOK, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "GetClusterSupportedPlatforms",
		Method:             "GET",
		PathPattern:        "/v2/clusters/{cluster_id}/supported-platforms",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &GetClusterSupportedPlatformsReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*GetClusterSupportedPlatformsOK), nil

}

/*
GetInfraEnv Retrieves the details of the infra-env.
*/
func (a *Client) GetInfraEnv(ctx context.Context, params *GetInfraEnvParams) (*GetInfraEnvOK, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "GetInfraEnv",
		Method:             "GET",
		PathPattern:        "/v2/infra-envs/{infra_env_id}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &GetInfraEnvReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*GetInfraEnvOK), nil

}

/*
GetInfraEnvDownloadURL Creates a new pre-signed image download URL for the infra-env.
*/
func (a *Client) GetInfraEnvDownloadURL(ctx context.Context, params *GetInfraEnvDownloadURLParams) (*GetInfraEnvDownloadURLOK, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "GetInfraEnvDownloadURL",
		Method:             "GET",
		PathPattern:        "/v2/infra-envs/{infra_env_id}/downloads/image-url",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &GetInfraEnvDownloadURLReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*GetInfraEnvDownloadURLOK), nil

}

/*
GetInfraEnvPresignedFileURL Creates a new pre-signed download URL for the infra-env.
*/
func (a *Client) GetInfraEnvPresignedFileURL(ctx context.Context, params *GetInfraEnvPresignedFileURLParams) (*GetInfraEnvPresignedFileURLOK, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "GetInfraEnvPresignedFileURL",
		Method:             "GET",
		PathPattern:        "/v2/infra-envs/{infra_env_id}/downloads/files-presigned",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &GetInfraEnvPresignedFileURLReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*GetInfraEnvPresignedFileURLOK), nil

}

/*
ListClusterHosts Get a list of cluster hosts according to supplied filters.
*/
func (a *Client) ListClusterHosts(ctx context.Context, params *ListClusterHostsParams) (*ListClusterHostsOK, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "ListClusterHosts",
		Method:             "GET",
		PathPattern:        "/v2/clusters/{cluster_id}/hosts",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &ListClusterHostsReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*ListClusterHostsOK), nil

}

/*
ListInfraEnvs Retrieves the list of infra-envs.
*/
func (a *Client) ListInfraEnvs(ctx context.Context, params *ListInfraEnvsParams) (*ListInfraEnvsOK, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "ListInfraEnvs",
		Method:             "GET",
		PathPattern:        "/v2/infra-envs",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &ListInfraEnvsReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*ListInfraEnvsOK), nil

}

/*
RegenerateInfraEnvSigningKey Regenerate InfraEnv token signing key.
*/
func (a *Client) RegenerateInfraEnvSigningKey(ctx context.Context, params *RegenerateInfraEnvSigningKeyParams) (*RegenerateInfraEnvSigningKeyNoContent, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "RegenerateInfraEnvSigningKey",
		Method:             "POST",
		PathPattern:        "/v2/infra-envs/{infra_env_id}/regenerate-signing-key",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &RegenerateInfraEnvSigningKeyReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*RegenerateInfraEnvSigningKeyNoContent), nil

}

/*
RegisterInfraEnv Creates a new OpenShift Discovery ISO.
*/
func (a *Client) RegisterInfraEnv(ctx context.Context, params *RegisterInfraEnvParams) (*RegisterInfraEnvCreated, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "RegisterInfraEnv",
		Method:             "POST",
		PathPattern:        "/v2/infra-envs",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &RegisterInfraEnvReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*RegisterInfraEnvCreated), nil

}

/*
TransformClusterToDay2 Transforming cluster to day2 and allowing adding hosts
*/
func (a *Client) TransformClusterToDay2(ctx context.Context, params *TransformClusterToDay2Params) (*TransformClusterToDay2Accepted, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "TransformClusterToDay2",
		Method:             "POST",
		PathPattern:        "/v2/clusters/{cluster_id}/actions/allow-add-workers",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &TransformClusterToDay2Reader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*TransformClusterToDay2Accepted), nil

}

/*
UnbindHost Unbind host to a cluster
*/
func (a *Client) UnbindHost(ctx context.Context, params *UnbindHostParams) (*UnbindHostOK, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "UnbindHost",
		Method:             "POST",
		PathPattern:        "/v2/infra-envs/{infra_env_id}/hosts/{host_id}/actions/unbind",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &UnbindHostReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*UnbindHostOK), nil

}

/*
UpdateInfraEnv Updates an infra-env.
*/
func (a *Client) UpdateInfraEnv(ctx context.Context, params *UpdateInfraEnvParams) (*UpdateInfraEnvCreated, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "UpdateInfraEnv",
		Method:             "PATCH",
		PathPattern:        "/v2/infra-envs/{infra_env_id}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &UpdateInfraEnvReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*UpdateInfraEnvCreated), nil

}

/*
V2CancelInstallation Cancels an ongoing installation.
*/
func (a *Client) V2CancelInstallation(ctx context.Context, params *V2CancelInstallationParams) (*V2CancelInstallationAccepted, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "V2CancelInstallation",
		Method:             "POST",
		PathPattern:        "/v2/clusters/{cluster_id}/actions/cancel",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &V2CancelInstallationReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*V2CancelInstallationAccepted), nil

}

/*
V2DownloadClusterCredentials Downloads credentials relating to the installed/installing cluster.
*/
func (a *Client) V2DownloadClusterCredentials(ctx context.Context, params *V2DownloadClusterCredentialsParams, writer io.Writer) (*V2DownloadClusterCredentialsOK, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "V2DownloadClusterCredentials",
		Method:             "GET",
		PathPattern:        "/v2/clusters/{cluster_id}/downloads/credentials",
		ProducesMediaTypes: []string{"application/octet-stream"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &V2DownloadClusterCredentialsReader{formats: a.formats, writer: writer},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*V2DownloadClusterCredentialsOK), nil

}

/*
V2DownloadClusterFiles Downloads files relating to the installed/installing cluster.
*/
func (a *Client) V2DownloadClusterFiles(ctx context.Context, params *V2DownloadClusterFilesParams, writer io.Writer) (*V2DownloadClusterFilesOK, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "V2DownloadClusterFiles",
		Method:             "GET",
		PathPattern:        "/v2/clusters/{cluster_id}/downloads/files",
		ProducesMediaTypes: []string{"application/octet-stream"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &V2DownloadClusterFilesReader{formats: a.formats, writer: writer},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*V2DownloadClusterFilesOK), nil

}

/*
V2DownloadClusterLogs Download cluster logs.
*/
func (a *Client) V2DownloadClusterLogs(ctx context.Context, params *V2DownloadClusterLogsParams, writer io.Writer) (*V2DownloadClusterLogsOK, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "V2DownloadClusterLogs",
		Method:             "GET",
		PathPattern:        "/v2/clusters/{cluster_id}/logs",
		ProducesMediaTypes: []string{"application/octet-stream"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &V2DownloadClusterLogsReader{formats: a.formats, writer: writer},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*V2DownloadClusterLogsOK), nil

}

/*
V2GetClusterDefaultConfig Get the default values for various cluster properties.
*/
func (a *Client) V2GetClusterDefaultConfig(ctx context.Context, params *V2GetClusterDefaultConfigParams) (*V2GetClusterDefaultConfigOK, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "V2GetClusterDefaultConfig",
		Method:             "GET",
		PathPattern:        "/v2/clusters/default-config",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &V2GetClusterDefaultConfigReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*V2GetClusterDefaultConfigOK), nil

}

/*
V2GetCredentials Get the cluster admin credentials.
*/
func (a *Client) V2GetCredentials(ctx context.Context, params *V2GetCredentialsParams) (*V2GetCredentialsOK, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "V2GetCredentials",
		Method:             "GET",
		PathPattern:        "/v2/clusters/{cluster_id}/credentials",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &V2GetCredentialsReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*V2GetCredentialsOK), nil

}

/*
V2GetPresignedForClusterCredentials Get the cluster admin credentials.
*/
func (a *Client) V2GetPresignedForClusterCredentials(ctx context.Context, params *V2GetPresignedForClusterCredentialsParams) (*V2GetPresignedForClusterCredentialsOK, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "V2GetPresignedForClusterCredentials",
		Method:             "GET",
		PathPattern:        "/v2/clusters/{cluster_id}/downloads/credentials-presigned",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &V2GetPresignedForClusterCredentialsReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*V2GetPresignedForClusterCredentialsOK), nil

}

/*
V2GetPresignedForClusterFiles Retrieves a pre-signed S3 URL for downloading cluster files.
*/
func (a *Client) V2GetPresignedForClusterFiles(ctx context.Context, params *V2GetPresignedForClusterFilesParams) (*V2GetPresignedForClusterFilesOK, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "V2GetPresignedForClusterFiles",
		Method:             "GET",
		PathPattern:        "/v2/clusters/{cluster_id}/downloads/files-presigned",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &V2GetPresignedForClusterFilesReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*V2GetPresignedForClusterFilesOK), nil

}

/*
V2UpdateCluster Updates an OpenShift cluster definition.
*/
func (a *Client) V2UpdateCluster(ctx context.Context, params *V2UpdateClusterParams) (*V2UpdateClusterCreated, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "V2UpdateCluster",
		Method:             "PATCH",
		PathPattern:        "/v2/clusters/{cluster_id}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &V2UpdateClusterReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*V2UpdateClusterCreated), nil

}

/*
V2UploadLogs Agent API to upload logs.
*/
func (a *Client) V2UploadLogs(ctx context.Context, params *V2UploadLogsParams) (*V2UploadLogsNoContent, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "V2UploadLogs",
		Method:             "POST",
		PathPattern:        "/v2/clusters/{cluster_id}/logs",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"multipart/form-data"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &V2UploadLogsReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*V2UploadLogsNoContent), nil

}

/*
V2CompleteInstallation Agent API to mark a finalizing installation as complete.
*/
func (a *Client) V2CompleteInstallation(ctx context.Context, params *V2CompleteInstallationParams) (*V2CompleteInstallationAccepted, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "v2CompleteInstallation",
		Method:             "POST",
		PathPattern:        "/v2/clusters/{cluster_id}/actions/complete-installation",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &V2CompleteInstallationReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*V2CompleteInstallationAccepted), nil

}

/*
V2DeregisterCluster Deletes an OpenShift cluster definition.
*/
func (a *Client) V2DeregisterCluster(ctx context.Context, params *V2DeregisterClusterParams) (*V2DeregisterClusterNoContent, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "v2DeregisterCluster",
		Method:             "DELETE",
		PathPattern:        "/v2/clusters/{cluster_id}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &V2DeregisterClusterReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*V2DeregisterClusterNoContent), nil

}

/*
V2DeregisterHost Deregisters an OpenShift host.
*/
func (a *Client) V2DeregisterHost(ctx context.Context, params *V2DeregisterHostParams) (*V2DeregisterHostNoContent, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "v2DeregisterHost",
		Method:             "DELETE",
		PathPattern:        "/v2/infra-envs/{infra_env_id}/hosts/{host_id}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &V2DeregisterHostReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*V2DeregisterHostNoContent), nil

}

/*
V2DownloadHostIgnition Downloads the customized ignition file for this bound host, produces octet stream. For unbound host - error is returned
*/
func (a *Client) V2DownloadHostIgnition(ctx context.Context, params *V2DownloadHostIgnitionParams, writer io.Writer) (*V2DownloadHostIgnitionOK, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "v2DownloadHostIgnition",
		Method:             "GET",
		PathPattern:        "/v2/infra-env/{infra_env_id}/hosts/{host_id}/downloads/ignition",
		ProducesMediaTypes: []string{"application/octet-stream"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &V2DownloadHostIgnitionReader{formats: a.formats, writer: writer},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*V2DownloadHostIgnitionOK), nil

}

/*
V2DownloadInfraEnvFiles Downloads the customized ignition file for this host
*/
func (a *Client) V2DownloadInfraEnvFiles(ctx context.Context, params *V2DownloadInfraEnvFilesParams, writer io.Writer) (*V2DownloadInfraEnvFilesOK, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "v2DownloadInfraEnvFiles",
		Method:             "GET",
		PathPattern:        "/v2/infra-envs/{infra_env_id}/downloads/files",
		ProducesMediaTypes: []string{"application/octet-stream"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &V2DownloadInfraEnvFilesReader{formats: a.formats, writer: writer},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*V2DownloadInfraEnvFilesOK), nil

}

/*
V2GetCluster Retrieves the details of the OpenShift cluster.
*/
func (a *Client) V2GetCluster(ctx context.Context, params *V2GetClusterParams) (*V2GetClusterOK, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "v2GetCluster",
		Method:             "GET",
		PathPattern:        "/v2/clusters/{cluster_id}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &V2GetClusterReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*V2GetClusterOK), nil

}

/*
V2GetClusterInstallConfig Get the cluster's install config YAML.
*/
func (a *Client) V2GetClusterInstallConfig(ctx context.Context, params *V2GetClusterInstallConfigParams) (*V2GetClusterInstallConfigOK, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "v2GetClusterInstallConfig",
		Method:             "GET",
		PathPattern:        "/v2/clusters/{cluster_id}/install-config",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &V2GetClusterInstallConfigReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*V2GetClusterInstallConfigOK), nil

}

/*
V2GetHost Retrieves the details of the OpenShift host.
*/
func (a *Client) V2GetHost(ctx context.Context, params *V2GetHostParams) (*V2GetHostOK, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "v2GetHost",
		Method:             "GET",
		PathPattern:        "/v2/infra-envs/{infra_env_id}/hosts/{host_id}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &V2GetHostReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*V2GetHostOK), nil

}

/*
V2GetHostIgnition Fetch the ignition file for this host as a string. In case of unbound host produces an error
*/
func (a *Client) V2GetHostIgnition(ctx context.Context, params *V2GetHostIgnitionParams) (*V2GetHostIgnitionOK, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "v2GetHostIgnition",
		Method:             "GET",
		PathPattern:        "/v2/infra-envs/{infra_env_id}/hosts/{host_id}/ignition",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &V2GetHostIgnitionReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*V2GetHostIgnitionOK), nil

}

/*
V2GetNextSteps Retrieves the next operations that the host agent needs to perform.
*/
func (a *Client) V2GetNextSteps(ctx context.Context, params *V2GetNextStepsParams) (*V2GetNextStepsOK, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "v2GetNextSteps",
		Method:             "GET",
		PathPattern:        "/v2/infra-envs/{infra_env_id}/hosts/{host_id}/instructions",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &V2GetNextStepsReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*V2GetNextStepsOK), nil

}

/*
V2GetPreflightRequirements Get preflight requirements for a cluster.
*/
func (a *Client) V2GetPreflightRequirements(ctx context.Context, params *V2GetPreflightRequirementsParams) (*V2GetPreflightRequirementsOK, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "v2GetPreflightRequirements",
		Method:             "GET",
		PathPattern:        "/v2/clusters/{cluster_id}/preflight-requirements",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &V2GetPreflightRequirementsReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*V2GetPreflightRequirementsOK), nil

}

/*
V2ImportCluster Import an AI cluster using minimal data assosiated with existing OCP cluster, in order to allow adding day2 hosts to that cluster
*/
func (a *Client) V2ImportCluster(ctx context.Context, params *V2ImportClusterParams) (*V2ImportClusterCreated, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "v2ImportCluster",
		Method:             "POST",
		PathPattern:        "/v2/clusters/import",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &V2ImportClusterReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*V2ImportClusterCreated), nil

}

/*
V2InstallCluster Installs the OpenShift cluster.
*/
func (a *Client) V2InstallCluster(ctx context.Context, params *V2InstallClusterParams) (*V2InstallClusterAccepted, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "v2InstallCluster",
		Method:             "POST",
		PathPattern:        "/v2/clusters/{cluster_id}/actions/install",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &V2InstallClusterReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*V2InstallClusterAccepted), nil

}

/*
V2InstallHost install specific host for day2 cluster.
*/
func (a *Client) V2InstallHost(ctx context.Context, params *V2InstallHostParams) (*V2InstallHostAccepted, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "v2InstallHost",
		Method:             "POST",
		PathPattern:        "/v2/infra-envs/{infra_env_id}/hosts/{host_id}/actions/install",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &V2InstallHostReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*V2InstallHostAccepted), nil

}

/*
V2ListClusters Retrieves the list of OpenShift clusters.
*/
func (a *Client) V2ListClusters(ctx context.Context, params *V2ListClustersParams) (*V2ListClustersOK, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "v2ListClusters",
		Method:             "GET",
		PathPattern:        "/v2/clusters",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &V2ListClustersReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*V2ListClustersOK), nil

}

/*
V2ListFeatureSupportLevels Retrieves the support levels for features for each OpenShift version.
*/
func (a *Client) V2ListFeatureSupportLevels(ctx context.Context, params *V2ListFeatureSupportLevelsParams) (*V2ListFeatureSupportLevelsOK, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "v2ListFeatureSupportLevels",
		Method:             "GET",
		PathPattern:        "/v2/feature-support-levels",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &V2ListFeatureSupportLevelsReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*V2ListFeatureSupportLevelsOK), nil

}

/*
V2ListHosts Retrieves the list of OpenShift hosts that belong the infra-env.
*/
func (a *Client) V2ListHosts(ctx context.Context, params *V2ListHostsParams) (*V2ListHostsOK, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "v2ListHosts",
		Method:             "GET",
		PathPattern:        "/v2/infra-envs/{infra_env_id}/hosts",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &V2ListHostsReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*V2ListHostsOK), nil

}

/*
V2PostStepReply Posts the result of the operations from the host agent.
*/
func (a *Client) V2PostStepReply(ctx context.Context, params *V2PostStepReplyParams) (*V2PostStepReplyNoContent, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "v2PostStepReply",
		Method:             "POST",
		PathPattern:        "/v2/infra-envs/{infra_env_id}/hosts/{host_id}/instructions",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &V2PostStepReplyReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*V2PostStepReplyNoContent), nil

}

/*
V2RegisterCluster Creates a new OpenShift cluster definition.
*/
func (a *Client) V2RegisterCluster(ctx context.Context, params *V2RegisterClusterParams) (*V2RegisterClusterCreated, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "v2RegisterCluster",
		Method:             "POST",
		PathPattern:        "/v2/clusters",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &V2RegisterClusterReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*V2RegisterClusterCreated), nil

}

/*
V2RegisterHost Registers a new OpenShift agent.
*/
func (a *Client) V2RegisterHost(ctx context.Context, params *V2RegisterHostParams) (*V2RegisterHostCreated, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "v2RegisterHost",
		Method:             "POST",
		PathPattern:        "/v2/infra-envs/{infra_env_id}/hosts",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &V2RegisterHostReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*V2RegisterHostCreated), nil

}

/*
V2ResetCluster Resets a failed installation.
*/
func (a *Client) V2ResetCluster(ctx context.Context, params *V2ResetClusterParams) (*V2ResetClusterAccepted, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "v2ResetCluster",
		Method:             "POST",
		PathPattern:        "/v2/clusters/{cluster_id}/actions/reset",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &V2ResetClusterReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*V2ResetClusterAccepted), nil

}

/*
V2ResetHost reset a failed host for day2 cluster.
*/
func (a *Client) V2ResetHost(ctx context.Context, params *V2ResetHostParams) (*V2ResetHostOK, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "v2ResetHost",
		Method:             "POST",
		PathPattern:        "/v2/infra-envs/{infra_env_id}/hosts/{host_id}/actions/reset",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &V2ResetHostReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*V2ResetHostOK), nil

}

/*
V2ResetHostValidation resets failed host validation

Reset failed host validation. It may be performed on any host validation with persistent validation result.
*/
func (a *Client) V2ResetHostValidation(ctx context.Context, params *V2ResetHostValidationParams) (*V2ResetHostValidationOK, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "v2ResetHostValidation",
		Method:             "PATCH",
		PathPattern:        "/v2/infra-envs/{infra_env_id}/hosts/{host_id}/actions/reset-validation/{validation_id}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &V2ResetHostValidationReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*V2ResetHostValidationOK), nil

}

/*
V2UpdateClusterInstallConfig Override values in the install config.
*/
func (a *Client) V2UpdateClusterInstallConfig(ctx context.Context, params *V2UpdateClusterInstallConfigParams) (*V2UpdateClusterInstallConfigCreated, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "v2UpdateClusterInstallConfig",
		Method:             "PATCH",
		PathPattern:        "/v2/clusters/{cluster_id}/install-config",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &V2UpdateClusterInstallConfigReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*V2UpdateClusterInstallConfigCreated), nil

}

/*
V2UpdateClusterLogsProgress Update log collection state and progress.
*/
func (a *Client) V2UpdateClusterLogsProgress(ctx context.Context, params *V2UpdateClusterLogsProgressParams) (*V2UpdateClusterLogsProgressNoContent, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "v2UpdateClusterLogsProgress",
		Method:             "PUT",
		PathPattern:        "/v2/clusters/{cluster_id}/logs-progress",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &V2UpdateClusterLogsProgressReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*V2UpdateClusterLogsProgressNoContent), nil

}

/*
V2UpdateHost Update an Openshift host
*/
func (a *Client) V2UpdateHost(ctx context.Context, params *V2UpdateHostParams) (*V2UpdateHostCreated, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "v2UpdateHost",
		Method:             "PATCH",
		PathPattern:        "/v2/infra-envs/{infra_env_id}/hosts/{host_id}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &V2UpdateHostReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*V2UpdateHostCreated), nil

}

/*
V2UpdateHostIgnition Patch the ignition file for this host
*/
func (a *Client) V2UpdateHostIgnition(ctx context.Context, params *V2UpdateHostIgnitionParams) (*V2UpdateHostIgnitionCreated, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "v2UpdateHostIgnition",
		Method:             "PATCH",
		PathPattern:        "/v2/infra-envs/{infra_env_id}/hosts/{host_id}/ignition",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &V2UpdateHostIgnitionReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*V2UpdateHostIgnitionCreated), nil

}

/*
V2UpdateHostInstallProgress Update installation progress.
*/
func (a *Client) V2UpdateHostInstallProgress(ctx context.Context, params *V2UpdateHostInstallProgressParams) (*V2UpdateHostInstallProgressOK, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "v2UpdateHostInstallProgress",
		Method:             "PUT",
		PathPattern:        "/v2/infra-envs/{infra_env_id}/hosts/{host_id}/progress",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &V2UpdateHostInstallProgressReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*V2UpdateHostInstallProgressOK), nil

}

/*
V2UpdateHostInstallerArgs Updates a host's installer arguments.
*/
func (a *Client) V2UpdateHostInstallerArgs(ctx context.Context, params *V2UpdateHostInstallerArgsParams) (*V2UpdateHostInstallerArgsCreated, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "v2UpdateHostInstallerArgs",
		Method:             "PATCH",
		PathPattern:        "/v2/infra-envs/{infra_env_id}/hosts/{host_id}/installer-args",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &V2UpdateHostInstallerArgsReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*V2UpdateHostInstallerArgsCreated), nil

}

/*
V2UpdateHostLogsProgress Update log collection state and progress.
*/
func (a *Client) V2UpdateHostLogsProgress(ctx context.Context, params *V2UpdateHostLogsProgressParams) (*V2UpdateHostLogsProgressNoContent, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "v2UpdateHostLogsProgress",
		Method:             "PUT",
		PathPattern:        "/v2/infra-envs/{infra_env_id}/hosts/{host_id}/logs-progress",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &V2UpdateHostLogsProgressReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*V2UpdateHostLogsProgressNoContent), nil

}

/*
V2UploadClusterIngressCert Transfer the ingress certificate for the cluster.
*/
func (a *Client) V2UploadClusterIngressCert(ctx context.Context, params *V2UploadClusterIngressCertParams) (*V2UploadClusterIngressCertCreated, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "v2UploadClusterIngressCert",
		Method:             "POST",
		PathPattern:        "/v2/clusters/{cluster_id}/uploads/ingress-cert",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &V2UploadClusterIngressCertReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*V2UploadClusterIngressCertCreated), nil

}
