// Code generated by go-swagger; DO NOT EDIT.

package installer

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
)

// NewV2DownloadClusterFilesParams creates a new V2DownloadClusterFilesParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewV2DownloadClusterFilesParams() *V2DownloadClusterFilesParams {
	return &V2DownloadClusterFilesParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewV2DownloadClusterFilesParamsWithTimeout creates a new V2DownloadClusterFilesParams object
// with the ability to set a timeout on a request.
func NewV2DownloadClusterFilesParamsWithTimeout(timeout time.Duration) *V2DownloadClusterFilesParams {
	return &V2DownloadClusterFilesParams{
		timeout: timeout,
	}
}

// NewV2DownloadClusterFilesParamsWithContext creates a new V2DownloadClusterFilesParams object
// with the ability to set a context for a request.
func NewV2DownloadClusterFilesParamsWithContext(ctx context.Context) *V2DownloadClusterFilesParams {
	return &V2DownloadClusterFilesParams{
		Context: ctx,
	}
}

// NewV2DownloadClusterFilesParamsWithHTTPClient creates a new V2DownloadClusterFilesParams object
// with the ability to set a custom HTTPClient for a request.
func NewV2DownloadClusterFilesParamsWithHTTPClient(client *http.Client) *V2DownloadClusterFilesParams {
	return &V2DownloadClusterFilesParams{
		HTTPClient: client,
	}
}

/* V2DownloadClusterFilesParams contains all the parameters to send to the API endpoint
   for the v2 download cluster files operation.

   Typically these are written to a http.Request.
*/
type V2DownloadClusterFilesParams struct {

	/* ClusterID.

	   The cluster that owns the file that should be downloaded.

	   Format: uuid
	*/
	ClusterID strfmt.UUID

	/* DiscoveryAgentVersion.

	   The software version of the discovery agent that is downloading the file.
	*/
	DiscoveryAgentVersion *string

	/* FileName.

	   The file to be downloaded.
	*/
	FileName string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the v2 download cluster files params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *V2DownloadClusterFilesParams) WithDefaults() *V2DownloadClusterFilesParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the v2 download cluster files params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *V2DownloadClusterFilesParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the v2 download cluster files params
func (o *V2DownloadClusterFilesParams) WithTimeout(timeout time.Duration) *V2DownloadClusterFilesParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the v2 download cluster files params
func (o *V2DownloadClusterFilesParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the v2 download cluster files params
func (o *V2DownloadClusterFilesParams) WithContext(ctx context.Context) *V2DownloadClusterFilesParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the v2 download cluster files params
func (o *V2DownloadClusterFilesParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the v2 download cluster files params
func (o *V2DownloadClusterFilesParams) WithHTTPClient(client *http.Client) *V2DownloadClusterFilesParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the v2 download cluster files params
func (o *V2DownloadClusterFilesParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithClusterID adds the clusterID to the v2 download cluster files params
func (o *V2DownloadClusterFilesParams) WithClusterID(clusterID strfmt.UUID) *V2DownloadClusterFilesParams {
	o.SetClusterID(clusterID)
	return o
}

// SetClusterID adds the clusterId to the v2 download cluster files params
func (o *V2DownloadClusterFilesParams) SetClusterID(clusterID strfmt.UUID) {
	o.ClusterID = clusterID
}

// WithDiscoveryAgentVersion adds the discoveryAgentVersion to the v2 download cluster files params
func (o *V2DownloadClusterFilesParams) WithDiscoveryAgentVersion(discoveryAgentVersion *string) *V2DownloadClusterFilesParams {
	o.SetDiscoveryAgentVersion(discoveryAgentVersion)
	return o
}

// SetDiscoveryAgentVersion adds the discoveryAgentVersion to the v2 download cluster files params
func (o *V2DownloadClusterFilesParams) SetDiscoveryAgentVersion(discoveryAgentVersion *string) {
	o.DiscoveryAgentVersion = discoveryAgentVersion
}

// WithFileName adds the fileName to the v2 download cluster files params
func (o *V2DownloadClusterFilesParams) WithFileName(fileName string) *V2DownloadClusterFilesParams {
	o.SetFileName(fileName)
	return o
}

// SetFileName adds the fileName to the v2 download cluster files params
func (o *V2DownloadClusterFilesParams) SetFileName(fileName string) {
	o.FileName = fileName
}

// WriteToRequest writes these params to a swagger request
func (o *V2DownloadClusterFilesParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param cluster_id
	if err := r.SetPathParam("cluster_id", o.ClusterID.String()); err != nil {
		return err
	}

	if o.DiscoveryAgentVersion != nil {

		// header param discovery_agent_version
		if err := r.SetHeaderParam("discovery_agent_version", *o.DiscoveryAgentVersion); err != nil {
			return err
		}
	}

	// query param file_name
	qrFileName := o.FileName
	qFileName := qrFileName
	if qFileName != "" {

		if err := r.SetQueryParam("file_name", qFileName); err != nil {
			return err
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
