# Boot Discovery Image on AWS EC2

This procedure describes the required steps to get a discovery image generated by AI booting on an AWS EC2 instance.

We can boot the image using two different processes:
* Network boot using an iPXE ami
* installing a CentOS instance and configuring GRUB

## Network boot with iPXE
We will download the discovery iso, copy the required files to a webserver and then launch a new instance using an iPXE AMI image

### Steps
1. Generate the iso (full) on the AI UI
2. Run the following commands to download the ISO and extract the files
    ```
    sudo mkdir -p /var/tmp/discovery-files

    # Download ISO
    wget -O /var/tmp/discovery-image.iso 'https://<long s3 url provided by AI SaaS>'

    # Mount ISO image to extract files
    sudo mount -o loop /var/tmp/discovery-image.iso /mnt

    # Copy needed files
    sudo cp -v /mnt/images/pxeboot/* /var/tmp/discovery-files
    gzip -dc /mnt/images/ignition.img | sudo cpio -ivD /var/tmp/discovery-files

    # Umount ISO
    sudo umount /mnt
    ```

3. Copy the files to a webserver. In this example we will install a webserver in the same host
    ```
    # Install nginx
    sudo dnf install -y nginx
    sudo sed -i 's%/usr/share/nginx/html%/var/www%g' /etc/nginx/nginx.conf
    sudo systemctl start nginx

    # Copy files to webserver
    sudo cp -vr /var/tmp/discovery-files /var/www

    # Update selinux security context if needed
    sudo chcon -Rt httpd_sys_content_t /var/www/discovery-files
    ```

4. Create a new AWS EC2 instance
    Note that we need to set the webserver IP address or domain name in the second line of the user data
    - find and select the AMI `iPXE 1.21.1 (gfa012) (x86_64)`
    - In the section `Configure Instance Details`, in `Advanced Details` we will set the following `User data`:
        ```
        #!ipxe
        set web http://<IP-OF-WEBSERVER>/discovery-files
        kernel ${web}/vmlinuz coreos.live.rootfs_url=${web}/rootfs.img ignition.config.url=${web}/config.ign ignition.firstboot ignition.platform.id=metal ip=dhcp
        initrd ${web}/initrd.img
        boot
        ```

5. The new instance will boot the discovery image

## Installing CentOS and configuring GRUB
We will get the discovery image downloaded in a CentOS 8 instance and GRUB will be configured to load the discovery image on next boot.

### Steps

1. Generate the iso (small - for virtual media) on the AI UI.
2. Run an EC2 instance using a CentOS 8 AMI.
3. Connect to the EC2 instance using SSH.
4. Once connected to the instance run the following commands in order to get the iso downloaded and check the rootfs location:

    ~~~sh
    sudo wget -O /var/tmp/discovery-image.iso 'https://<long s3 url provided by AI SaaS>'
    sudo mount -o loop /var/tmp/discovery-image.iso /mnt/
    sudo cat /mnt/isolinux/isolinux.cfg 
    ~~~

    > **NOTE**: Above command will output the rootfs used by the ISO, you need this information in the grub config file we will create below.
    ~~~
    label linux
    menu label ^RHEL CoreOS (Live)
    menu default
    kernel /images/pxeboot/vmlinuz
    append initrd=/images/pxeboot/initrd.img,/images/ignition.img,/images/assisted_installer_custom.img random.trust_cpu=on ignition.firstboot ignition.platform.id=metal coreos.live.rootfs_url=https://mirror.openshift.com/pub/openshift-v4/dependencies/rhcos/4.8/4.8.2/rhcos-live-rootfs.x86_64.img
    ~~~
5. Run the following commands to get GRUB configured and the instance rebooted.

    ~~~sh
    sudo vi /etc/grub.d/40_custom

    ----40_custom content start (do not copy this line)----
    #!/bin/sh
    exec tail -n +3 $0
    # This file provides an easy way to add custom menu entries.  Simply type the
    # menu entries you want to add after this comment.  Be careful not to change
    # the 'exec tail' line above.

    menuentry "Discovery Image RHCOS" {
            set iso="/var/tmp/discovery-image.iso"
            loopback loop ${iso}
            linux (loop)/images/pxeboot/vmlinuz boot=images iso-scan/filename=${iso} persistent noeject noprompt ignition.firstboot ignition.platform.id=metal coreos.live.rootfs_url='<rootfs file location from step 4>'
            initrd (loop)/images/pxeboot/initrd.img (loop)/images/ignition.img (loop)/images/assisted_installer_custom.img
            }
    ---- 40_custom content end (do not copy this line)----

    sudo grub2-set-default 'Discovery Image RHCOS'
    sudo grub2-mkconfig -o /boot/grub2/grub.cfg
    sudo reboot
    ~~~
6. Instance will be rebooted and will boot the discovery image.
