// Code generated by client-gen. DO NOT EDIT.

package v1beta1

import (
	"context"
	"time"

	v1beta1 "github.com/openshift/api/helm/v1beta1"
	scheme "github.com/openshift/client-go/helm/clientset/versioned/scheme"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
)

// ProjectHelmChartRepositoriesGetter has a method to return a ProjectHelmChartRepositoryInterface.
// A group's client should implement this interface.
type ProjectHelmChartRepositoriesGetter interface {
	ProjectHelmChartRepositories(namespace string) ProjectHelmChartRepositoryInterface
}

// ProjectHelmChartRepositoryInterface has methods to work with ProjectHelmChartRepository resources.
type ProjectHelmChartRepositoryInterface interface {
	Create(ctx context.Context, projectHelmChartRepository *v1beta1.ProjectHelmChartRepository, opts v1.CreateOptions) (*v1beta1.ProjectHelmChartRepository, error)
	Update(ctx context.Context, projectHelmChartRepository *v1beta1.ProjectHelmChartRepository, opts v1.UpdateOptions) (*v1beta1.ProjectHelmChartRepository, error)
	UpdateStatus(ctx context.Context, projectHelmChartRepository *v1beta1.ProjectHelmChartRepository, opts v1.UpdateOptions) (*v1beta1.ProjectHelmChartRepository, error)
	Delete(ctx context.Context, name string, opts v1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error
	Get(ctx context.Context, name string, opts v1.GetOptions) (*v1beta1.ProjectHelmChartRepository, error)
	List(ctx context.Context, opts v1.ListOptions) (*v1beta1.ProjectHelmChartRepositoryList, error)
	Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1beta1.ProjectHelmChartRepository, err error)
	ProjectHelmChartRepositoryExpansion
}

// projectHelmChartRepositories implements ProjectHelmChartRepositoryInterface
type projectHelmChartRepositories struct {
	client rest.Interface
	ns     string
}

// newProjectHelmChartRepositories returns a ProjectHelmChartRepositories
func newProjectHelmChartRepositories(c *HelmV1beta1Client, namespace string) *projectHelmChartRepositories {
	return &projectHelmChartRepositories{
		client: c.RESTClient(),
		ns:     namespace,
	}
}

// Get takes name of the projectHelmChartRepository, and returns the corresponding projectHelmChartRepository object, and an error if there is any.
func (c *projectHelmChartRepositories) Get(ctx context.Context, name string, options v1.GetOptions) (result *v1beta1.ProjectHelmChartRepository, err error) {
	result = &v1beta1.ProjectHelmChartRepository{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("projecthelmchartrepositories").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do(ctx).
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of ProjectHelmChartRepositories that match those selectors.
func (c *projectHelmChartRepositories) List(ctx context.Context, opts v1.ListOptions) (result *v1beta1.ProjectHelmChartRepositoryList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1beta1.ProjectHelmChartRepositoryList{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("projecthelmchartrepositories").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do(ctx).
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested projectHelmChartRepositories.
func (c *projectHelmChartRepositories) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Namespace(c.ns).
		Resource("projecthelmchartrepositories").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch(ctx)
}

// Create takes the representation of a projectHelmChartRepository and creates it.  Returns the server's representation of the projectHelmChartRepository, and an error, if there is any.
func (c *projectHelmChartRepositories) Create(ctx context.Context, projectHelmChartRepository *v1beta1.ProjectHelmChartRepository, opts v1.CreateOptions) (result *v1beta1.ProjectHelmChartRepository, err error) {
	result = &v1beta1.ProjectHelmChartRepository{}
	err = c.client.Post().
		Namespace(c.ns).
		Resource("projecthelmchartrepositories").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(projectHelmChartRepository).
		Do(ctx).
		Into(result)
	return
}

// Update takes the representation of a projectHelmChartRepository and updates it. Returns the server's representation of the projectHelmChartRepository, and an error, if there is any.
func (c *projectHelmChartRepositories) Update(ctx context.Context, projectHelmChartRepository *v1beta1.ProjectHelmChartRepository, opts v1.UpdateOptions) (result *v1beta1.ProjectHelmChartRepository, err error) {
	result = &v1beta1.ProjectHelmChartRepository{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("projecthelmchartrepositories").
		Name(projectHelmChartRepository.Name).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(projectHelmChartRepository).
		Do(ctx).
		Into(result)
	return
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *projectHelmChartRepositories) UpdateStatus(ctx context.Context, projectHelmChartRepository *v1beta1.ProjectHelmChartRepository, opts v1.UpdateOptions) (result *v1beta1.ProjectHelmChartRepository, err error) {
	result = &v1beta1.ProjectHelmChartRepository{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("projecthelmchartrepositories").
		Name(projectHelmChartRepository.Name).
		SubResource("status").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(projectHelmChartRepository).
		Do(ctx).
		Into(result)
	return
}

// Delete takes name of the projectHelmChartRepository and deletes it. Returns an error if one occurs.
func (c *projectHelmChartRepositories) Delete(ctx context.Context, name string, opts v1.DeleteOptions) error {
	return c.client.Delete().
		Namespace(c.ns).
		Resource("projecthelmchartrepositories").
		Name(name).
		Body(&opts).
		Do(ctx).
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *projectHelmChartRepositories) DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error {
	var timeout time.Duration
	if listOpts.TimeoutSeconds != nil {
		timeout = time.Duration(*listOpts.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Namespace(c.ns).
		Resource("projecthelmchartrepositories").
		VersionedParams(&listOpts, scheme.ParameterCodec).
		Timeout(timeout).
		Body(&opts).
		Do(ctx).
		Error()
}

// Patch applies the patch and returns the patched projectHelmChartRepository.
func (c *projectHelmChartRepositories) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1beta1.ProjectHelmChartRepository, err error) {
	result = &v1beta1.ProjectHelmChartRepository{}
	err = c.client.Patch(pt).
		Namespace(c.ns).
		Resource("projecthelmchartrepositories").
		Name(name).
		SubResource(subresources...).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}
