// Code generated by go-swagger; DO NOT EDIT.

package installer

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/openshift/assisted-service/models"
)

// V2RegisterHostReader is a Reader for the V2RegisterHost structure.
type V2RegisterHostReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *V2RegisterHostReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 201:
		result := NewV2RegisterHostCreated()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewV2RegisterHostBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 401:
		result := NewV2RegisterHostUnauthorized()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewV2RegisterHostForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 404:
		result := NewV2RegisterHostNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 405:
		result := NewV2RegisterHostMethodNotAllowed()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 409:
		result := NewV2RegisterHostConflict()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewV2RegisterHostInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 501:
		result := NewV2RegisterHostNotImplemented()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 503:
		result := NewV2RegisterHostServiceUnavailable()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("response status code does not match any response statuses defined for this endpoint in the swagger spec", response, response.Code())
	}
}

// NewV2RegisterHostCreated creates a V2RegisterHostCreated with default headers values
func NewV2RegisterHostCreated() *V2RegisterHostCreated {
	return &V2RegisterHostCreated{}
}

/* V2RegisterHostCreated describes a response with status code 201, with default header values.

Success.
*/
type V2RegisterHostCreated struct {
	Payload *models.HostRegistrationResponse
}

func (o *V2RegisterHostCreated) Error() string {
	return fmt.Sprintf("[POST /v2/infra-envs/{infra_env_id}/hosts][%d] v2RegisterHostCreated  %+v", 201, o.Payload)
}
func (o *V2RegisterHostCreated) GetPayload() *models.HostRegistrationResponse {
	return o.Payload
}

func (o *V2RegisterHostCreated) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HostRegistrationResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewV2RegisterHostBadRequest creates a V2RegisterHostBadRequest with default headers values
func NewV2RegisterHostBadRequest() *V2RegisterHostBadRequest {
	return &V2RegisterHostBadRequest{}
}

/* V2RegisterHostBadRequest describes a response with status code 400, with default header values.

Error.
*/
type V2RegisterHostBadRequest struct {
	Payload *models.Error
}

func (o *V2RegisterHostBadRequest) Error() string {
	return fmt.Sprintf("[POST /v2/infra-envs/{infra_env_id}/hosts][%d] v2RegisterHostBadRequest  %+v", 400, o.Payload)
}
func (o *V2RegisterHostBadRequest) GetPayload() *models.Error {
	return o.Payload
}

func (o *V2RegisterHostBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Error)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewV2RegisterHostUnauthorized creates a V2RegisterHostUnauthorized with default headers values
func NewV2RegisterHostUnauthorized() *V2RegisterHostUnauthorized {
	return &V2RegisterHostUnauthorized{}
}

/* V2RegisterHostUnauthorized describes a response with status code 401, with default header values.

Unauthorized.
*/
type V2RegisterHostUnauthorized struct {
	Payload *models.InfraError
}

func (o *V2RegisterHostUnauthorized) Error() string {
	return fmt.Sprintf("[POST /v2/infra-envs/{infra_env_id}/hosts][%d] v2RegisterHostUnauthorized  %+v", 401, o.Payload)
}
func (o *V2RegisterHostUnauthorized) GetPayload() *models.InfraError {
	return o.Payload
}

func (o *V2RegisterHostUnauthorized) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.InfraError)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewV2RegisterHostForbidden creates a V2RegisterHostForbidden with default headers values
func NewV2RegisterHostForbidden() *V2RegisterHostForbidden {
	return &V2RegisterHostForbidden{}
}

/* V2RegisterHostForbidden describes a response with status code 403, with default header values.

Forbidden.
*/
type V2RegisterHostForbidden struct {
	Payload *models.InfraError
}

func (o *V2RegisterHostForbidden) Error() string {
	return fmt.Sprintf("[POST /v2/infra-envs/{infra_env_id}/hosts][%d] v2RegisterHostForbidden  %+v", 403, o.Payload)
}
func (o *V2RegisterHostForbidden) GetPayload() *models.InfraError {
	return o.Payload
}

func (o *V2RegisterHostForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.InfraError)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewV2RegisterHostNotFound creates a V2RegisterHostNotFound with default headers values
func NewV2RegisterHostNotFound() *V2RegisterHostNotFound {
	return &V2RegisterHostNotFound{}
}

/* V2RegisterHostNotFound describes a response with status code 404, with default header values.

Error.
*/
type V2RegisterHostNotFound struct {
	Payload *models.Error
}

func (o *V2RegisterHostNotFound) Error() string {
	return fmt.Sprintf("[POST /v2/infra-envs/{infra_env_id}/hosts][%d] v2RegisterHostNotFound  %+v", 404, o.Payload)
}
func (o *V2RegisterHostNotFound) GetPayload() *models.Error {
	return o.Payload
}

func (o *V2RegisterHostNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Error)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewV2RegisterHostMethodNotAllowed creates a V2RegisterHostMethodNotAllowed with default headers values
func NewV2RegisterHostMethodNotAllowed() *V2RegisterHostMethodNotAllowed {
	return &V2RegisterHostMethodNotAllowed{}
}

/* V2RegisterHostMethodNotAllowed describes a response with status code 405, with default header values.

Method Not Allowed.
*/
type V2RegisterHostMethodNotAllowed struct {
	Payload *models.Error
}

func (o *V2RegisterHostMethodNotAllowed) Error() string {
	return fmt.Sprintf("[POST /v2/infra-envs/{infra_env_id}/hosts][%d] v2RegisterHostMethodNotAllowed  %+v", 405, o.Payload)
}
func (o *V2RegisterHostMethodNotAllowed) GetPayload() *models.Error {
	return o.Payload
}

func (o *V2RegisterHostMethodNotAllowed) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Error)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewV2RegisterHostConflict creates a V2RegisterHostConflict with default headers values
func NewV2RegisterHostConflict() *V2RegisterHostConflict {
	return &V2RegisterHostConflict{}
}

/* V2RegisterHostConflict describes a response with status code 409, with default header values.

Cluster cannot accept new agents due to its current state.
*/
type V2RegisterHostConflict struct {
	Payload *models.Error
}

func (o *V2RegisterHostConflict) Error() string {
	return fmt.Sprintf("[POST /v2/infra-envs/{infra_env_id}/hosts][%d] v2RegisterHostConflict  %+v", 409, o.Payload)
}
func (o *V2RegisterHostConflict) GetPayload() *models.Error {
	return o.Payload
}

func (o *V2RegisterHostConflict) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Error)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewV2RegisterHostInternalServerError creates a V2RegisterHostInternalServerError with default headers values
func NewV2RegisterHostInternalServerError() *V2RegisterHostInternalServerError {
	return &V2RegisterHostInternalServerError{}
}

/* V2RegisterHostInternalServerError describes a response with status code 500, with default header values.

Error.
*/
type V2RegisterHostInternalServerError struct {
	Payload *models.Error
}

func (o *V2RegisterHostInternalServerError) Error() string {
	return fmt.Sprintf("[POST /v2/infra-envs/{infra_env_id}/hosts][%d] v2RegisterHostInternalServerError  %+v", 500, o.Payload)
}
func (o *V2RegisterHostInternalServerError) GetPayload() *models.Error {
	return o.Payload
}

func (o *V2RegisterHostInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Error)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewV2RegisterHostNotImplemented creates a V2RegisterHostNotImplemented with default headers values
func NewV2RegisterHostNotImplemented() *V2RegisterHostNotImplemented {
	return &V2RegisterHostNotImplemented{}
}

/* V2RegisterHostNotImplemented describes a response with status code 501, with default header values.

Not implemented.
*/
type V2RegisterHostNotImplemented struct {
	Payload *models.Error
}

func (o *V2RegisterHostNotImplemented) Error() string {
	return fmt.Sprintf("[POST /v2/infra-envs/{infra_env_id}/hosts][%d] v2RegisterHostNotImplemented  %+v", 501, o.Payload)
}
func (o *V2RegisterHostNotImplemented) GetPayload() *models.Error {
	return o.Payload
}

func (o *V2RegisterHostNotImplemented) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Error)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewV2RegisterHostServiceUnavailable creates a V2RegisterHostServiceUnavailable with default headers values
func NewV2RegisterHostServiceUnavailable() *V2RegisterHostServiceUnavailable {
	return &V2RegisterHostServiceUnavailable{}
}

/* V2RegisterHostServiceUnavailable describes a response with status code 503, with default header values.

Unavailable.
*/
type V2RegisterHostServiceUnavailable struct {
	Payload *models.Error
}

func (o *V2RegisterHostServiceUnavailable) Error() string {
	return fmt.Sprintf("[POST /v2/infra-envs/{infra_env_id}/hosts][%d] v2RegisterHostServiceUnavailable  %+v", 503, o.Payload)
}
func (o *V2RegisterHostServiceUnavailable) GetPayload() *models.Error {
	return o.Payload
}

func (o *V2RegisterHostServiceUnavailable) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Error)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
