// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// LogsGatherCmdRequest logs gather cmd request
//
// swagger:model logs_gather_cmd_request
type LogsGatherCmdRequest struct {

	// Host is bootstrap or not
	// Required: true
	Bootstrap *bool `json:"bootstrap"`

	// Cluster id
	// Required: true
	// Format: uuid
	ClusterID *strfmt.UUID `json:"cluster_id"`

	// Host id
	// Required: true
	// Format: uuid
	HostID *strfmt.UUID `json:"host_id"`

	// Infra env id
	// Required: true
	// Format: uuid
	InfraEnvID *strfmt.UUID `json:"infra_env_id"`

	// Run installer gather logs
	// Required: true
	InstallerGather bool `json:"installer_gather"`

	// List of master ips
	MasterIps []string `json:"master_ips"`
}

// Validate validates this logs gather cmd request
func (m *LogsGatherCmdRequest) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateBootstrap(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateClusterID(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateHostID(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateInfraEnvID(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateInstallerGather(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateMasterIps(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LogsGatherCmdRequest) validateBootstrap(formats strfmt.Registry) error {

	if err := validate.Required("bootstrap", "body", m.Bootstrap); err != nil {
		return err
	}

	return nil
}

func (m *LogsGatherCmdRequest) validateClusterID(formats strfmt.Registry) error {

	if err := validate.Required("cluster_id", "body", m.ClusterID); err != nil {
		return err
	}

	if err := validate.FormatOf("cluster_id", "body", "uuid", m.ClusterID.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *LogsGatherCmdRequest) validateHostID(formats strfmt.Registry) error {

	if err := validate.Required("host_id", "body", m.HostID); err != nil {
		return err
	}

	if err := validate.FormatOf("host_id", "body", "uuid", m.HostID.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *LogsGatherCmdRequest) validateInfraEnvID(formats strfmt.Registry) error {

	if err := validate.Required("infra_env_id", "body", m.InfraEnvID); err != nil {
		return err
	}

	if err := validate.FormatOf("infra_env_id", "body", "uuid", m.InfraEnvID.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *LogsGatherCmdRequest) validateInstallerGather(formats strfmt.Registry) error {

	if err := validate.Required("installer_gather", "body", bool(m.InstallerGather)); err != nil {
		return err
	}

	return nil
}

func (m *LogsGatherCmdRequest) validateMasterIps(formats strfmt.Registry) error {
	if swag.IsZero(m.MasterIps) { // not required
		return nil
	}

	for i := 0; i < len(m.MasterIps); i++ {

		if err := validate.Pattern("master_ips"+"."+strconv.Itoa(i), "body", m.MasterIps[i], `^(?:(?:(?:[0-9]{1,3}\.){3}[0-9]{1,3})|(?:(?:[0-9a-fA-F]*:[0-9a-fA-F]*){2,}))$`); err != nil {
			return err
		}

	}

	return nil
}

// ContextValidate validates this logs gather cmd request based on context it is used
func (m *LogsGatherCmdRequest) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *LogsGatherCmdRequest) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *LogsGatherCmdRequest) UnmarshalBinary(b []byte) error {
	var res LogsGatherCmdRequest
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
