// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// ServiceNetwork IP address block for service IP blocks.
//
// swagger:model service_network
type ServiceNetwork struct {

	// The IP block address pool.
	Cidr Subnet `json:"cidr,omitempty" gorm:"primaryKey"`

	// A network to use for service IP addresses. If you need to access the services from an external network, configure load balancers and routers to manage the traffic.
	// Format: uuid
	ClusterID strfmt.UUID `json:"cluster_id,omitempty" gorm:"primaryKey"`
}

// Validate validates this service network
func (m *ServiceNetwork) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateCidr(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateClusterID(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ServiceNetwork) validateCidr(formats strfmt.Registry) error {
	if swag.IsZero(m.Cidr) { // not required
		return nil
	}

	if err := m.Cidr.Validate(formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("cidr")
		} else if ce, ok := err.(*errors.CompositeError); ok {
			return ce.ValidateName("cidr")
		}
		return err
	}

	return nil
}

func (m *ServiceNetwork) validateClusterID(formats strfmt.Registry) error {
	if swag.IsZero(m.ClusterID) { // not required
		return nil
	}

	if err := validate.FormatOf("cluster_id", "body", "uuid", m.ClusterID.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this service network based on the context it is used
func (m *ServiceNetwork) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateCidr(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ServiceNetwork) contextValidateCidr(ctx context.Context, formats strfmt.Registry) error {

	if err := m.Cidr.ContextValidate(ctx, formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("cidr")
		} else if ce, ok := err.(*errors.CompositeError); ok {
			return ce.ValidateName("cidr")
		}
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ServiceNetwork) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ServiceNetwork) UnmarshalBinary(b []byte) error {
	var res ServiceNetwork
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
