// Code generated by go-swagger; DO NOT EDIT.

package installer

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/runtime/middleware"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// NewListClusterHostsParams creates a new ListClusterHostsParams object
//
// There are no default values defined in the spec.
func NewListClusterHostsParams() ListClusterHostsParams {

	return ListClusterHostsParams{}
}

// ListClusterHostsParams contains all the bound params for the list cluster hosts operation
// typically these are obtained from a http.Request
//
// swagger:parameters ListClusterHosts
type ListClusterHostsParams struct {

	// HTTP Request Object
	HTTPRequest *http.Request `json:"-"`

	/*The cluster whose hosts should be retrieved.
	  Required: true
	  In: path
	*/
	ClusterID strfmt.UUID
	/*Role to request.
	  In: query
	*/
	Role *string
	/*Hosts status to request.
	  In: query
	*/
	Status *string
	/*If true return the host's connectivity.
	  In: query
	*/
	WithConnectivity *bool
	/*If true return the host's inventory.
	  In: query
	*/
	WithInventory *bool
}

// BindRequest both binds and validates a request, it assumes that complex things implement a Validatable(strfmt.Registry) error interface
// for simple values it will use straight method calls.
//
// To ensure default values, the struct must have been initialized with NewListClusterHostsParams() beforehand.
func (o *ListClusterHostsParams) BindRequest(r *http.Request, route *middleware.MatchedRoute) error {
	var res []error

	o.HTTPRequest = r

	qs := runtime.Values(r.URL.Query())

	rClusterID, rhkClusterID, _ := route.Params.GetOK("cluster_id")
	if err := o.bindClusterID(rClusterID, rhkClusterID, route.Formats); err != nil {
		res = append(res, err)
	}

	qRole, qhkRole, _ := qs.GetOK("role")
	if err := o.bindRole(qRole, qhkRole, route.Formats); err != nil {
		res = append(res, err)
	}

	qStatus, qhkStatus, _ := qs.GetOK("status")
	if err := o.bindStatus(qStatus, qhkStatus, route.Formats); err != nil {
		res = append(res, err)
	}

	qWithConnectivity, qhkWithConnectivity, _ := qs.GetOK("with-connectivity")
	if err := o.bindWithConnectivity(qWithConnectivity, qhkWithConnectivity, route.Formats); err != nil {
		res = append(res, err)
	}

	qWithInventory, qhkWithInventory, _ := qs.GetOK("with-inventory")
	if err := o.bindWithInventory(qWithInventory, qhkWithInventory, route.Formats); err != nil {
		res = append(res, err)
	}
	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindClusterID binds and validates parameter ClusterID from path.
func (o *ListClusterHostsParams) bindClusterID(rawData []string, hasKey bool, formats strfmt.Registry) error {
	var raw string
	if len(rawData) > 0 {
		raw = rawData[len(rawData)-1]
	}

	// Required: true
	// Parameter is provided by construction from the route

	// Format: uuid
	value, err := formats.Parse("uuid", raw)
	if err != nil {
		return errors.InvalidType("cluster_id", "path", "strfmt.UUID", raw)
	}
	o.ClusterID = *(value.(*strfmt.UUID))

	if err := o.validateClusterID(formats); err != nil {
		return err
	}

	return nil
}

// validateClusterID carries on validations for parameter ClusterID
func (o *ListClusterHostsParams) validateClusterID(formats strfmt.Registry) error {

	if err := validate.FormatOf("cluster_id", "path", "uuid", o.ClusterID.String(), formats); err != nil {
		return err
	}
	return nil
}

// bindRole binds and validates parameter Role from query.
func (o *ListClusterHostsParams) bindRole(rawData []string, hasKey bool, formats strfmt.Registry) error {
	var raw string
	if len(rawData) > 0 {
		raw = rawData[len(rawData)-1]
	}

	// Required: false
	// AllowEmptyValue: false

	if raw == "" { // empty values pass all other validations
		return nil
	}
	o.Role = &raw

	if err := o.validateRole(formats); err != nil {
		return err
	}

	return nil
}

// validateRole carries on validations for parameter Role
func (o *ListClusterHostsParams) validateRole(formats strfmt.Registry) error {

	if err := validate.EnumCase("role", "query", *o.Role, []interface{}{"master", "worker", "auto-assign"}, true); err != nil {
		return err
	}

	return nil
}

// bindStatus binds and validates parameter Status from query.
func (o *ListClusterHostsParams) bindStatus(rawData []string, hasKey bool, formats strfmt.Registry) error {
	var raw string
	if len(rawData) > 0 {
		raw = rawData[len(rawData)-1]
	}

	// Required: false
	// AllowEmptyValue: false

	if raw == "" { // empty values pass all other validations
		return nil
	}
	o.Status = &raw

	return nil
}

// bindWithConnectivity binds and validates parameter WithConnectivity from query.
func (o *ListClusterHostsParams) bindWithConnectivity(rawData []string, hasKey bool, formats strfmt.Registry) error {
	var raw string
	if len(rawData) > 0 {
		raw = rawData[len(rawData)-1]
	}

	// Required: false
	// AllowEmptyValue: false

	if raw == "" { // empty values pass all other validations
		return nil
	}

	value, err := swag.ConvertBool(raw)
	if err != nil {
		return errors.InvalidType("with-connectivity", "query", "bool", raw)
	}
	o.WithConnectivity = &value

	return nil
}

// bindWithInventory binds and validates parameter WithInventory from query.
func (o *ListClusterHostsParams) bindWithInventory(rawData []string, hasKey bool, formats strfmt.Registry) error {
	var raw string
	if len(rawData) > 0 {
		raw = rawData[len(rawData)-1]
	}

	// Required: false
	// AllowEmptyValue: false

	if raw == "" { // empty values pass all other validations
		return nil
	}

	value, err := swag.ConvertBool(raw)
	if err != nil {
		return errors.InvalidType("with-inventory", "query", "bool", raw)
	}
	o.WithInventory = &value

	return nil
}
