// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// ConnectivityCheckNic connectivity check nic
//
// swagger:model connectivity-check-nic
type ConnectivityCheckNic struct {

	// ip addresses
	IPAddresses []string `json:"ip_addresses"`

	// mac
	// Format: mac
	Mac strfmt.MAC `json:"mac,omitempty"`

	// name
	Name string `json:"name,omitempty"`
}

// Validate validates this connectivity check nic
func (m *ConnectivityCheckNic) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateIPAddresses(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateMac(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConnectivityCheckNic) validateIPAddresses(formats strfmt.Registry) error {
	if swag.IsZero(m.IPAddresses) { // not required
		return nil
	}

	for i := 0; i < len(m.IPAddresses); i++ {

		if err := validate.Pattern("ip_addresses"+"."+strconv.Itoa(i), "body", m.IPAddresses[i], `^(?:(?:(?:[0-9]{1,3}\.){3}[0-9]{1,3})|(?:(?:[0-9a-fA-F]*:[0-9a-fA-F]*){2,}))$`); err != nil {
			return err
		}

	}

	return nil
}

func (m *ConnectivityCheckNic) validateMac(formats strfmt.Registry) error {
	if swag.IsZero(m.Mac) { // not required
		return nil
	}

	if err := validate.FormatOf("mac", "body", "mac", m.Mac.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this connectivity check nic based on context it is used
func (m *ConnectivityCheckNic) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *ConnectivityCheckNic) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ConnectivityCheckNic) UnmarshalBinary(b []byte) error {
	var res ConnectivityCheckNic
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
