// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// FreeNetworkAddresses free network addresses
//
// swagger:model free_network_addresses
type FreeNetworkAddresses struct {

	// free addresses
	FreeAddresses []strfmt.IPv4 `json:"free_addresses"`

	// network
	// Pattern: ^([0-9]{1,3}\.){3}[0-9]{1,3}\/[0-9]|[1-2][0-9]|3[0-2]?$
	Network string `json:"network,omitempty"`
}

// Validate validates this free network addresses
func (m *FreeNetworkAddresses) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateFreeAddresses(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateNetwork(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FreeNetworkAddresses) validateFreeAddresses(formats strfmt.Registry) error {
	if swag.IsZero(m.FreeAddresses) { // not required
		return nil
	}

	for i := 0; i < len(m.FreeAddresses); i++ {

		if err := validate.FormatOf("free_addresses"+"."+strconv.Itoa(i), "body", "ipv4", m.FreeAddresses[i].String(), formats); err != nil {
			return err
		}

	}

	return nil
}

func (m *FreeNetworkAddresses) validateNetwork(formats strfmt.Registry) error {
	if swag.IsZero(m.Network) { // not required
		return nil
	}

	if err := validate.Pattern("network", "body", m.Network, `^([0-9]{1,3}\.){3}[0-9]{1,3}\/[0-9]|[1-2][0-9]|3[0-2]?$`); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this free network addresses based on context it is used
func (m *FreeNetworkAddresses) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *FreeNetworkAddresses) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *FreeNetworkAddresses) UnmarshalBinary(b []byte) error {
	var res FreeNetworkAddresses
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
