// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// NextStepCmdRequest next step cmd request
//
// swagger:model next_step_cmd_request
type NextStepCmdRequest struct {

	// Agent image version
	// Required: true
	// Pattern: ^(([a-zA-Z0-9\-\.]+)(:[0-9]+)?\/)?[a-z0-9\._\-\/@]+[?::a-zA-Z0-9_\-.]+$
	AgentVersion *string `json:"agent_version"`

	// Host id
	// Required: true
	// Format: uuid
	HostID *strfmt.UUID `json:"host_id"`

	// Infra env id
	// Required: true
	// Format: uuid
	InfraEnvID *strfmt.UUID `json:"infra_env_id"`
}

// Validate validates this next step cmd request
func (m *NextStepCmdRequest) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateAgentVersion(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateHostID(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateInfraEnvID(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NextStepCmdRequest) validateAgentVersion(formats strfmt.Registry) error {

	if err := validate.Required("agent_version", "body", m.AgentVersion); err != nil {
		return err
	}

	if err := validate.Pattern("agent_version", "body", *m.AgentVersion, `^(([a-zA-Z0-9\-\.]+)(:[0-9]+)?\/)?[a-z0-9\._\-\/@]+[?::a-zA-Z0-9_\-.]+$`); err != nil {
		return err
	}

	return nil
}

func (m *NextStepCmdRequest) validateHostID(formats strfmt.Registry) error {

	if err := validate.Required("host_id", "body", m.HostID); err != nil {
		return err
	}

	if err := validate.FormatOf("host_id", "body", "uuid", m.HostID.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *NextStepCmdRequest) validateInfraEnvID(formats strfmt.Registry) error {

	if err := validate.Required("infra_env_id", "body", m.InfraEnvID); err != nil {
		return err
	}

	if err := validate.FormatOf("infra_env_id", "body", "uuid", m.InfraEnvID.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this next step cmd request based on context it is used
func (m *NextStepCmdRequest) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *NextStepCmdRequest) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NextStepCmdRequest) UnmarshalBinary(b []byte) error {
	var res NextStepCmdRequest
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
