// Code generated by go-swagger; DO NOT EDIT.

package installer

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"

	"github.com/openshift/assisted-service/models"
)

// NewBindHostParams creates a new BindHostParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewBindHostParams() *BindHostParams {
	return &BindHostParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewBindHostParamsWithTimeout creates a new BindHostParams object
// with the ability to set a timeout on a request.
func NewBindHostParamsWithTimeout(timeout time.Duration) *BindHostParams {
	return &BindHostParams{
		timeout: timeout,
	}
}

// NewBindHostParamsWithContext creates a new BindHostParams object
// with the ability to set a context for a request.
func NewBindHostParamsWithContext(ctx context.Context) *BindHostParams {
	return &BindHostParams{
		Context: ctx,
	}
}

// NewBindHostParamsWithHTTPClient creates a new BindHostParams object
// with the ability to set a custom HTTPClient for a request.
func NewBindHostParamsWithHTTPClient(client *http.Client) *BindHostParams {
	return &BindHostParams{
		HTTPClient: client,
	}
}

/* BindHostParams contains all the parameters to send to the API endpoint
   for the bind host operation.

   Typically these are written to a http.Request.
*/
type BindHostParams struct {

	/* BindHostParams.

	   The parameters for the host binding.
	*/
	BindHostParams *models.BindHostParams

	/* HostID.

	   The host that is being bound.

	   Format: uuid
	*/
	HostID strfmt.UUID

	/* InfraEnvID.

	   The infra-env of the host that is being bound.

	   Format: uuid
	*/
	InfraEnvID strfmt.UUID

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the bind host params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *BindHostParams) WithDefaults() *BindHostParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the bind host params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *BindHostParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the bind host params
func (o *BindHostParams) WithTimeout(timeout time.Duration) *BindHostParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the bind host params
func (o *BindHostParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the bind host params
func (o *BindHostParams) WithContext(ctx context.Context) *BindHostParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the bind host params
func (o *BindHostParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the bind host params
func (o *BindHostParams) WithHTTPClient(client *http.Client) *BindHostParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the bind host params
func (o *BindHostParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithBindHostParams adds the bindHostParams to the bind host params
func (o *BindHostParams) WithBindHostParams(bindHostParams *models.BindHostParams) *BindHostParams {
	o.SetBindHostParams(bindHostParams)
	return o
}

// SetBindHostParams adds the bindHostParams to the bind host params
func (o *BindHostParams) SetBindHostParams(bindHostParams *models.BindHostParams) {
	o.BindHostParams = bindHostParams
}

// WithHostID adds the hostID to the bind host params
func (o *BindHostParams) WithHostID(hostID strfmt.UUID) *BindHostParams {
	o.SetHostID(hostID)
	return o
}

// SetHostID adds the hostId to the bind host params
func (o *BindHostParams) SetHostID(hostID strfmt.UUID) {
	o.HostID = hostID
}

// WithInfraEnvID adds the infraEnvID to the bind host params
func (o *BindHostParams) WithInfraEnvID(infraEnvID strfmt.UUID) *BindHostParams {
	o.SetInfraEnvID(infraEnvID)
	return o
}

// SetInfraEnvID adds the infraEnvId to the bind host params
func (o *BindHostParams) SetInfraEnvID(infraEnvID strfmt.UUID) {
	o.InfraEnvID = infraEnvID
}

// WriteToRequest writes these params to a swagger request
func (o *BindHostParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.BindHostParams != nil {
		if err := r.SetBodyParam(o.BindHostParams); err != nil {
			return err
		}
	}

	// path param host_id
	if err := r.SetPathParam("host_id", o.HostID.String()); err != nil {
		return err
	}

	// path param infra_env_id
	if err := r.SetPathParam("infra_env_id", o.InfraEnvID.String()); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
