// Code generated by go-swagger; DO NOT EDIT.

package installer

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewListClusterHostsParams creates a new ListClusterHostsParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewListClusterHostsParams() *ListClusterHostsParams {
	return &ListClusterHostsParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewListClusterHostsParamsWithTimeout creates a new ListClusterHostsParams object
// with the ability to set a timeout on a request.
func NewListClusterHostsParamsWithTimeout(timeout time.Duration) *ListClusterHostsParams {
	return &ListClusterHostsParams{
		timeout: timeout,
	}
}

// NewListClusterHostsParamsWithContext creates a new ListClusterHostsParams object
// with the ability to set a context for a request.
func NewListClusterHostsParamsWithContext(ctx context.Context) *ListClusterHostsParams {
	return &ListClusterHostsParams{
		Context: ctx,
	}
}

// NewListClusterHostsParamsWithHTTPClient creates a new ListClusterHostsParams object
// with the ability to set a custom HTTPClient for a request.
func NewListClusterHostsParamsWithHTTPClient(client *http.Client) *ListClusterHostsParams {
	return &ListClusterHostsParams{
		HTTPClient: client,
	}
}

/* ListClusterHostsParams contains all the parameters to send to the API endpoint
   for the list cluster hosts operation.

   Typically these are written to a http.Request.
*/
type ListClusterHostsParams struct {

	/* ClusterID.

	   The cluster whose hosts should be retrieved.

	   Format: uuid
	*/
	ClusterID strfmt.UUID

	/* Role.

	   Role to request.
	*/
	Role *string

	/* Status.

	   Hosts status to request.
	*/
	Status *string

	/* WithConnectivity.

	   If true return the host's connectivity.
	*/
	WithConnectivity *bool

	/* WithInventory.

	   If true return the host's inventory.
	*/
	WithInventory *bool

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the list cluster hosts params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ListClusterHostsParams) WithDefaults() *ListClusterHostsParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the list cluster hosts params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ListClusterHostsParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the list cluster hosts params
func (o *ListClusterHostsParams) WithTimeout(timeout time.Duration) *ListClusterHostsParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the list cluster hosts params
func (o *ListClusterHostsParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the list cluster hosts params
func (o *ListClusterHostsParams) WithContext(ctx context.Context) *ListClusterHostsParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the list cluster hosts params
func (o *ListClusterHostsParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the list cluster hosts params
func (o *ListClusterHostsParams) WithHTTPClient(client *http.Client) *ListClusterHostsParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the list cluster hosts params
func (o *ListClusterHostsParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithClusterID adds the clusterID to the list cluster hosts params
func (o *ListClusterHostsParams) WithClusterID(clusterID strfmt.UUID) *ListClusterHostsParams {
	o.SetClusterID(clusterID)
	return o
}

// SetClusterID adds the clusterId to the list cluster hosts params
func (o *ListClusterHostsParams) SetClusterID(clusterID strfmt.UUID) {
	o.ClusterID = clusterID
}

// WithRole adds the role to the list cluster hosts params
func (o *ListClusterHostsParams) WithRole(role *string) *ListClusterHostsParams {
	o.SetRole(role)
	return o
}

// SetRole adds the role to the list cluster hosts params
func (o *ListClusterHostsParams) SetRole(role *string) {
	o.Role = role
}

// WithStatus adds the status to the list cluster hosts params
func (o *ListClusterHostsParams) WithStatus(status *string) *ListClusterHostsParams {
	o.SetStatus(status)
	return o
}

// SetStatus adds the status to the list cluster hosts params
func (o *ListClusterHostsParams) SetStatus(status *string) {
	o.Status = status
}

// WithWithConnectivity adds the withConnectivity to the list cluster hosts params
func (o *ListClusterHostsParams) WithWithConnectivity(withConnectivity *bool) *ListClusterHostsParams {
	o.SetWithConnectivity(withConnectivity)
	return o
}

// SetWithConnectivity adds the withConnectivity to the list cluster hosts params
func (o *ListClusterHostsParams) SetWithConnectivity(withConnectivity *bool) {
	o.WithConnectivity = withConnectivity
}

// WithWithInventory adds the withInventory to the list cluster hosts params
func (o *ListClusterHostsParams) WithWithInventory(withInventory *bool) *ListClusterHostsParams {
	o.SetWithInventory(withInventory)
	return o
}

// SetWithInventory adds the withInventory to the list cluster hosts params
func (o *ListClusterHostsParams) SetWithInventory(withInventory *bool) {
	o.WithInventory = withInventory
}

// WriteToRequest writes these params to a swagger request
func (o *ListClusterHostsParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param cluster_id
	if err := r.SetPathParam("cluster_id", o.ClusterID.String()); err != nil {
		return err
	}

	if o.Role != nil {

		// query param role
		var qrRole string

		if o.Role != nil {
			qrRole = *o.Role
		}
		qRole := qrRole
		if qRole != "" {

			if err := r.SetQueryParam("role", qRole); err != nil {
				return err
			}
		}
	}

	if o.Status != nil {

		// query param status
		var qrStatus string

		if o.Status != nil {
			qrStatus = *o.Status
		}
		qStatus := qrStatus
		if qStatus != "" {

			if err := r.SetQueryParam("status", qStatus); err != nil {
				return err
			}
		}
	}

	if o.WithConnectivity != nil {

		// query param with-connectivity
		var qrWithConnectivity bool

		if o.WithConnectivity != nil {
			qrWithConnectivity = *o.WithConnectivity
		}
		qWithConnectivity := swag.FormatBool(qrWithConnectivity)
		if qWithConnectivity != "" {

			if err := r.SetQueryParam("with-connectivity", qWithConnectivity); err != nil {
				return err
			}
		}
	}

	if o.WithInventory != nil {

		// query param with-inventory
		var qrWithInventory bool

		if o.WithInventory != nil {
			qrWithInventory = *o.WithInventory
		}
		qWithInventory := swag.FormatBool(qrWithInventory)
		if qWithInventory != "" {

			if err := r.SetQueryParam("with-inventory", qWithInventory); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
