// Code generated by go-swagger; DO NOT EDIT.

package installer

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the generate command

import (
	"errors"
	"net/url"
	golangswaggerpaths "path"
	"strings"

	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// ListClusterHostsURL generates an URL for the list cluster hosts operation
type ListClusterHostsURL struct {
	ClusterID strfmt.UUID

	Role             *string
	Status           *string
	WithConnectivity *bool
	WithInventory    *bool

	_basePath string
	// avoid unkeyed usage
	_ struct{}
}

// WithBasePath sets the base path for this url builder, only required when it's different from the
// base path specified in the swagger spec.
// When the value of the base path is an empty string
func (o *ListClusterHostsURL) WithBasePath(bp string) *ListClusterHostsURL {
	o.SetBasePath(bp)
	return o
}

// SetBasePath sets the base path for this url builder, only required when it's different from the
// base path specified in the swagger spec.
// When the value of the base path is an empty string
func (o *ListClusterHostsURL) SetBasePath(bp string) {
	o._basePath = bp
}

// Build a url path and query string
func (o *ListClusterHostsURL) Build() (*url.URL, error) {
	var _result url.URL

	var _path = "/v2/clusters/{cluster_id}/hosts"

	clusterID := o.ClusterID.String()
	if clusterID != "" {
		_path = strings.Replace(_path, "{cluster_id}", clusterID, -1)
	} else {
		return nil, errors.New("clusterId is required on ListClusterHostsURL")
	}

	_basePath := o._basePath
	if _basePath == "" {
		_basePath = "/api/assisted-install"
	}
	_result.Path = golangswaggerpaths.Join(_basePath, _path)

	qs := make(url.Values)

	var roleQ string
	if o.Role != nil {
		roleQ = *o.Role
	}
	if roleQ != "" {
		qs.Set("role", roleQ)
	}

	var statusQ string
	if o.Status != nil {
		statusQ = *o.Status
	}
	if statusQ != "" {
		qs.Set("status", statusQ)
	}

	var withConnectivityQ string
	if o.WithConnectivity != nil {
		withConnectivityQ = swag.FormatBool(*o.WithConnectivity)
	}
	if withConnectivityQ != "" {
		qs.Set("with-connectivity", withConnectivityQ)
	}

	var withInventoryQ string
	if o.WithInventory != nil {
		withInventoryQ = swag.FormatBool(*o.WithInventory)
	}
	if withInventoryQ != "" {
		qs.Set("with-inventory", withInventoryQ)
	}

	_result.RawQuery = qs.Encode()

	return &_result, nil
}

// Must is a helper function to panic when the url builder returns an error
func (o *ListClusterHostsURL) Must(u *url.URL, err error) *url.URL {
	if err != nil {
		panic(err)
	}
	if u == nil {
		panic("url can't be nil")
	}
	return u
}

// String returns the string representation of the path with query string
func (o *ListClusterHostsURL) String() string {
	return o.Must(o.Build()).String()
}

// BuildFull builds a full url with scheme, host, path and query string
func (o *ListClusterHostsURL) BuildFull(scheme, host string) (*url.URL, error) {
	if scheme == "" {
		return nil, errors.New("scheme is required for a full url on ListClusterHostsURL")
	}
	if host == "" {
		return nil, errors.New("host is required for a full url on ListClusterHostsURL")
	}

	base, err := o.Build()
	if err != nil {
		return nil, err
	}

	base.Scheme = scheme
	base.Host = host
	return base, nil
}

// StringFull returns the string representation of a complete url
func (o *ListClusterHostsURL) StringFull(scheme, host string) string {
	return o.Must(o.BuildFull(scheme, host)).String()
}
