// Code generated by go-swagger; DO NOT EDIT.

package bootfiles

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/openshift/assisted-service/models"
)

// DownloadBootFilesReader is a Reader for the DownloadBootFiles structure.
type DownloadBootFilesReader struct {
	formats strfmt.Registry
	writer  io.Writer
}

// ReadResponse reads a server response into the received o.
func (o *DownloadBootFilesReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewDownloadBootFilesOK(o.writer)
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 307:
		result := NewDownloadBootFilesTemporaryRedirect()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 401:
		result := NewDownloadBootFilesUnauthorized()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewDownloadBootFilesForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewDownloadBootFilesInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result

	default:
		return nil, runtime.NewAPIError("response status code does not match any response statuses defined for this endpoint in the swagger spec", response, response.Code())
	}
}

// NewDownloadBootFilesOK creates a DownloadBootFilesOK with default headers values
func NewDownloadBootFilesOK(writer io.Writer) *DownloadBootFilesOK {
	return &DownloadBootFilesOK{
		Payload: writer,
	}
}

/*DownloadBootFilesOK handles this case with default header values.

Success.
*/
type DownloadBootFilesOK struct {
	Payload io.Writer
}

func (o *DownloadBootFilesOK) Error() string {
	return fmt.Sprintf("[GET /boot-files][%d] downloadBootFilesOK  %+v", 200, o.Payload)
}

func (o *DownloadBootFilesOK) GetPayload() io.Writer {
	return o.Payload
}

func (o *DownloadBootFilesOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDownloadBootFilesTemporaryRedirect creates a DownloadBootFilesTemporaryRedirect with default headers values
func NewDownloadBootFilesTemporaryRedirect() *DownloadBootFilesTemporaryRedirect {
	return &DownloadBootFilesTemporaryRedirect{}
}

/*DownloadBootFilesTemporaryRedirect handles this case with default header values.

Redirect.
*/
type DownloadBootFilesTemporaryRedirect struct {
	Location string
}

func (o *DownloadBootFilesTemporaryRedirect) Error() string {
	return fmt.Sprintf("[GET /boot-files][%d] downloadBootFilesTemporaryRedirect ", 307)
}

func (o *DownloadBootFilesTemporaryRedirect) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// response header Location
	o.Location = response.GetHeader("Location")

	return nil
}

// NewDownloadBootFilesUnauthorized creates a DownloadBootFilesUnauthorized with default headers values
func NewDownloadBootFilesUnauthorized() *DownloadBootFilesUnauthorized {
	return &DownloadBootFilesUnauthorized{}
}

/*DownloadBootFilesUnauthorized handles this case with default header values.

Unauthorized.
*/
type DownloadBootFilesUnauthorized struct {
	Payload *models.InfraError
}

func (o *DownloadBootFilesUnauthorized) Error() string {
	return fmt.Sprintf("[GET /boot-files][%d] downloadBootFilesUnauthorized  %+v", 401, o.Payload)
}

func (o *DownloadBootFilesUnauthorized) GetPayload() *models.InfraError {
	return o.Payload
}

func (o *DownloadBootFilesUnauthorized) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.InfraError)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDownloadBootFilesForbidden creates a DownloadBootFilesForbidden with default headers values
func NewDownloadBootFilesForbidden() *DownloadBootFilesForbidden {
	return &DownloadBootFilesForbidden{}
}

/*DownloadBootFilesForbidden handles this case with default header values.

Forbidden.
*/
type DownloadBootFilesForbidden struct {
	Payload *models.InfraError
}

func (o *DownloadBootFilesForbidden) Error() string {
	return fmt.Sprintf("[GET /boot-files][%d] downloadBootFilesForbidden  %+v", 403, o.Payload)
}

func (o *DownloadBootFilesForbidden) GetPayload() *models.InfraError {
	return o.Payload
}

func (o *DownloadBootFilesForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.InfraError)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDownloadBootFilesInternalServerError creates a DownloadBootFilesInternalServerError with default headers values
func NewDownloadBootFilesInternalServerError() *DownloadBootFilesInternalServerError {
	return &DownloadBootFilesInternalServerError{}
}

/*DownloadBootFilesInternalServerError handles this case with default header values.

Error.
*/
type DownloadBootFilesInternalServerError struct {
	Payload *models.Error
}

func (o *DownloadBootFilesInternalServerError) Error() string {
	return fmt.Sprintf("[GET /boot-files][%d] downloadBootFilesInternalServerError  %+v", 500, o.Payload)
}

func (o *DownloadBootFilesInternalServerError) GetPayload() *models.Error {
	return o.Payload
}

func (o *DownloadBootFilesInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Error)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
