// Code generated by go-swagger; DO NOT EDIT.

package installer

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewListClustersParams creates a new ListClustersParams object
// with the default values initialized.
func NewListClustersParams() *ListClustersParams {
	var (
		getUnregisteredClustersDefault = bool(false)
	)
	return &ListClustersParams{
		GetUnregisteredClusters: &getUnregisteredClustersDefault,

		timeout: cr.DefaultTimeout,
	}
}

// NewListClustersParamsWithTimeout creates a new ListClustersParams object
// with the default values initialized, and the ability to set a timeout on a request
func NewListClustersParamsWithTimeout(timeout time.Duration) *ListClustersParams {
	var (
		getUnregisteredClustersDefault = bool(false)
	)
	return &ListClustersParams{
		GetUnregisteredClusters: &getUnregisteredClustersDefault,

		timeout: timeout,
	}
}

// NewListClustersParamsWithContext creates a new ListClustersParams object
// with the default values initialized, and the ability to set a context for a request
func NewListClustersParamsWithContext(ctx context.Context) *ListClustersParams {
	var (
		getUnregisteredClustersDefault = bool(false)
	)
	return &ListClustersParams{
		GetUnregisteredClusters: &getUnregisteredClustersDefault,

		Context: ctx,
	}
}

// NewListClustersParamsWithHTTPClient creates a new ListClustersParams object
// with the default values initialized, and the ability to set a custom HTTPClient for a request
func NewListClustersParamsWithHTTPClient(client *http.Client) *ListClustersParams {
	var (
		getUnregisteredClustersDefault = bool(false)
	)
	return &ListClustersParams{
		GetUnregisteredClusters: &getUnregisteredClustersDefault,
		HTTPClient:              client,
	}
}

/*ListClustersParams contains all the parameters to send to the API endpoint
for the list clusters operation typically these are written to a http.Request
*/
type ListClustersParams struct {

	/*GetUnregisteredClusters*/
	GetUnregisteredClusters *bool
	/*OpenshiftClusterID*/
	OpenshiftClusterID *strfmt.UUID

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithTimeout adds the timeout to the list clusters params
func (o *ListClustersParams) WithTimeout(timeout time.Duration) *ListClustersParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the list clusters params
func (o *ListClustersParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the list clusters params
func (o *ListClustersParams) WithContext(ctx context.Context) *ListClustersParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the list clusters params
func (o *ListClustersParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the list clusters params
func (o *ListClustersParams) WithHTTPClient(client *http.Client) *ListClustersParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the list clusters params
func (o *ListClustersParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithGetUnregisteredClusters adds the getUnregisteredClusters to the list clusters params
func (o *ListClustersParams) WithGetUnregisteredClusters(getUnregisteredClusters *bool) *ListClustersParams {
	o.SetGetUnregisteredClusters(getUnregisteredClusters)
	return o
}

// SetGetUnregisteredClusters adds the getUnregisteredClusters to the list clusters params
func (o *ListClustersParams) SetGetUnregisteredClusters(getUnregisteredClusters *bool) {
	o.GetUnregisteredClusters = getUnregisteredClusters
}

// WithOpenshiftClusterID adds the openshiftClusterID to the list clusters params
func (o *ListClustersParams) WithOpenshiftClusterID(openshiftClusterID *strfmt.UUID) *ListClustersParams {
	o.SetOpenshiftClusterID(openshiftClusterID)
	return o
}

// SetOpenshiftClusterID adds the openshiftClusterId to the list clusters params
func (o *ListClustersParams) SetOpenshiftClusterID(openshiftClusterID *strfmt.UUID) {
	o.OpenshiftClusterID = openshiftClusterID
}

// WriteToRequest writes these params to a swagger request
func (o *ListClustersParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.GetUnregisteredClusters != nil {

		// header param get_unregistered_clusters
		if err := r.SetHeaderParam("get_unregistered_clusters", swag.FormatBool(*o.GetUnregisteredClusters)); err != nil {
			return err
		}

	}

	if o.OpenshiftClusterID != nil {

		// query param openshift_cluster_id
		var qrOpenshiftClusterID strfmt.UUID
		if o.OpenshiftClusterID != nil {
			qrOpenshiftClusterID = *o.OpenshiftClusterID
		}
		qOpenshiftClusterID := qrOpenshiftClusterID.String()
		if qOpenshiftClusterID != "" {
			if err := r.SetQueryParam("openshift_cluster_id", qOpenshiftClusterID); err != nil {
				return err
			}
		}

	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
