// Code generated by go-swagger; DO NOT EDIT.

package installer

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"

	"github.com/openshift/assisted-service/models"
)

// NewUpdateHostInstallProgressParams creates a new UpdateHostInstallProgressParams object
// with the default values initialized.
func NewUpdateHostInstallProgressParams() *UpdateHostInstallProgressParams {
	var ()
	return &UpdateHostInstallProgressParams{

		timeout: cr.DefaultTimeout,
	}
}

// NewUpdateHostInstallProgressParamsWithTimeout creates a new UpdateHostInstallProgressParams object
// with the default values initialized, and the ability to set a timeout on a request
func NewUpdateHostInstallProgressParamsWithTimeout(timeout time.Duration) *UpdateHostInstallProgressParams {
	var ()
	return &UpdateHostInstallProgressParams{

		timeout: timeout,
	}
}

// NewUpdateHostInstallProgressParamsWithContext creates a new UpdateHostInstallProgressParams object
// with the default values initialized, and the ability to set a context for a request
func NewUpdateHostInstallProgressParamsWithContext(ctx context.Context) *UpdateHostInstallProgressParams {
	var ()
	return &UpdateHostInstallProgressParams{

		Context: ctx,
	}
}

// NewUpdateHostInstallProgressParamsWithHTTPClient creates a new UpdateHostInstallProgressParams object
// with the default values initialized, and the ability to set a custom HTTPClient for a request
func NewUpdateHostInstallProgressParamsWithHTTPClient(client *http.Client) *UpdateHostInstallProgressParams {
	var ()
	return &UpdateHostInstallProgressParams{
		HTTPClient: client,
	}
}

/*UpdateHostInstallProgressParams contains all the parameters to send to the API endpoint
for the update host install progress operation typically these are written to a http.Request
*/
type UpdateHostInstallProgressParams struct {

	/*ClusterID
	  The ID of the cluster to retrieve.

	*/
	ClusterID strfmt.UUID
	/*DiscoveryAgentVersion*/
	DiscoveryAgentVersion *string
	/*HostProgress
	  New progress value.

	*/
	HostProgress *models.HostProgress
	/*HostID
	  The ID of the host to retrieve.

	*/
	HostID strfmt.UUID

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithTimeout adds the timeout to the update host install progress params
func (o *UpdateHostInstallProgressParams) WithTimeout(timeout time.Duration) *UpdateHostInstallProgressParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the update host install progress params
func (o *UpdateHostInstallProgressParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the update host install progress params
func (o *UpdateHostInstallProgressParams) WithContext(ctx context.Context) *UpdateHostInstallProgressParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the update host install progress params
func (o *UpdateHostInstallProgressParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the update host install progress params
func (o *UpdateHostInstallProgressParams) WithHTTPClient(client *http.Client) *UpdateHostInstallProgressParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the update host install progress params
func (o *UpdateHostInstallProgressParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithClusterID adds the clusterID to the update host install progress params
func (o *UpdateHostInstallProgressParams) WithClusterID(clusterID strfmt.UUID) *UpdateHostInstallProgressParams {
	o.SetClusterID(clusterID)
	return o
}

// SetClusterID adds the clusterId to the update host install progress params
func (o *UpdateHostInstallProgressParams) SetClusterID(clusterID strfmt.UUID) {
	o.ClusterID = clusterID
}

// WithDiscoveryAgentVersion adds the discoveryAgentVersion to the update host install progress params
func (o *UpdateHostInstallProgressParams) WithDiscoveryAgentVersion(discoveryAgentVersion *string) *UpdateHostInstallProgressParams {
	o.SetDiscoveryAgentVersion(discoveryAgentVersion)
	return o
}

// SetDiscoveryAgentVersion adds the discoveryAgentVersion to the update host install progress params
func (o *UpdateHostInstallProgressParams) SetDiscoveryAgentVersion(discoveryAgentVersion *string) {
	o.DiscoveryAgentVersion = discoveryAgentVersion
}

// WithHostProgress adds the hostProgress to the update host install progress params
func (o *UpdateHostInstallProgressParams) WithHostProgress(hostProgress *models.HostProgress) *UpdateHostInstallProgressParams {
	o.SetHostProgress(hostProgress)
	return o
}

// SetHostProgress adds the hostProgress to the update host install progress params
func (o *UpdateHostInstallProgressParams) SetHostProgress(hostProgress *models.HostProgress) {
	o.HostProgress = hostProgress
}

// WithHostID adds the hostID to the update host install progress params
func (o *UpdateHostInstallProgressParams) WithHostID(hostID strfmt.UUID) *UpdateHostInstallProgressParams {
	o.SetHostID(hostID)
	return o
}

// SetHostID adds the hostId to the update host install progress params
func (o *UpdateHostInstallProgressParams) SetHostID(hostID strfmt.UUID) {
	o.HostID = hostID
}

// WriteToRequest writes these params to a swagger request
func (o *UpdateHostInstallProgressParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param cluster_id
	if err := r.SetPathParam("cluster_id", o.ClusterID.String()); err != nil {
		return err
	}

	if o.DiscoveryAgentVersion != nil {

		// header param discovery_agent_version
		if err := r.SetHeaderParam("discovery_agent_version", *o.DiscoveryAgentVersion); err != nil {
			return err
		}

	}

	if o.HostProgress != nil {
		if err := r.SetBodyParam(o.HostProgress); err != nil {
			return err
		}
	}

	// path param host_id
	if err := r.SetPathParam("host_id", o.HostID.String()); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
