// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// AddHostsClusterCreateParams add hosts cluster create params
//
// swagger:model add-hosts-cluster-create-params
type AddHostsClusterCreateParams struct {

	// api vip domain.
	// Required: true
	APIVipDnsname *string `json:"api_vip_dnsname"`

	// Unique identifier of the object.
	// Required: true
	// Format: uuid
	ID *strfmt.UUID `json:"id"`

	// Name of the OpenShift cluster.
	// Required: true
	Name *string `json:"name"`

	// Version of the OpenShift cluster.
	// Required: true
	// Enum: [4.6]
	OpenshiftVersion *string `json:"openshift_version"`
}

// Validate validates this add hosts cluster create params
func (m *AddHostsClusterCreateParams) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateAPIVipDnsname(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateID(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateName(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateOpenshiftVersion(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *AddHostsClusterCreateParams) validateAPIVipDnsname(formats strfmt.Registry) error {

	if err := validate.Required("api_vip_dnsname", "body", m.APIVipDnsname); err != nil {
		return err
	}

	return nil
}

func (m *AddHostsClusterCreateParams) validateID(formats strfmt.Registry) error {

	if err := validate.Required("id", "body", m.ID); err != nil {
		return err
	}

	if err := validate.FormatOf("id", "body", "uuid", m.ID.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *AddHostsClusterCreateParams) validateName(formats strfmt.Registry) error {

	if err := validate.Required("name", "body", m.Name); err != nil {
		return err
	}

	return nil
}

var addHostsClusterCreateParamsTypeOpenshiftVersionPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["4.6"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		addHostsClusterCreateParamsTypeOpenshiftVersionPropEnum = append(addHostsClusterCreateParamsTypeOpenshiftVersionPropEnum, v)
	}
}

const (

	// AddHostsClusterCreateParamsOpenshiftVersionNr46 captures enum value "4.6"
	AddHostsClusterCreateParamsOpenshiftVersionNr46 string = "4.6"
)

// prop value enum
func (m *AddHostsClusterCreateParams) validateOpenshiftVersionEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, addHostsClusterCreateParamsTypeOpenshiftVersionPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *AddHostsClusterCreateParams) validateOpenshiftVersion(formats strfmt.Registry) error {

	if err := validate.Required("openshift_version", "body", m.OpenshiftVersion); err != nil {
		return err
	}

	// value enum
	if err := m.validateOpenshiftVersionEnum("openshift_version", "body", *m.OpenshiftVersion); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *AddHostsClusterCreateParams) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *AddHostsClusterCreateParams) UnmarshalBinary(b []byte) error {
	var res AddHostsClusterCreateParams
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
