/*
Copyright (c) 2020 Red Hat, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// IMPORTANT: This file has been generated automatically, refrain from modifying it manually as all
// your changes will be lost when the file is generated again.

package v1 // github.com/openshift-online/ocm-sdk-go/clustersmgmt/v1

import (
	"io"

	jsoniter "github.com/json-iterator/go"
	"github.com/openshift-online/ocm-sdk-go/helpers"
)

// MarshalGoogleIdentityProvider writes a value of the 'google_identity_provider' type to the given writer.
func MarshalGoogleIdentityProvider(object *GoogleIdentityProvider, writer io.Writer) error {
	stream := helpers.NewStream(writer)
	writeGoogleIdentityProvider(object, stream)
	stream.Flush()
	return stream.Error
}

// writeGoogleIdentityProvider writes a value of the 'google_identity_provider' type to the given stream.
func writeGoogleIdentityProvider(object *GoogleIdentityProvider, stream *jsoniter.Stream) {
	count := 0
	stream.WriteObjectStart()
	if object.clientID != nil {
		if count > 0 {
			stream.WriteMore()
		}
		stream.WriteObjectField("client_id")
		stream.WriteString(*object.clientID)
		count++
	}
	if object.clientSecret != nil {
		if count > 0 {
			stream.WriteMore()
		}
		stream.WriteObjectField("client_secret")
		stream.WriteString(*object.clientSecret)
		count++
	}
	if object.hostedDomain != nil {
		if count > 0 {
			stream.WriteMore()
		}
		stream.WriteObjectField("hosted_domain")
		stream.WriteString(*object.hostedDomain)
		count++
	}
	stream.WriteObjectEnd()
}

// UnmarshalGoogleIdentityProvider reads a value of the 'google_identity_provider' type from the given
// source, which can be an slice of bytes, a string or a reader.
func UnmarshalGoogleIdentityProvider(source interface{}) (object *GoogleIdentityProvider, err error) {
	iterator, err := helpers.NewIterator(source)
	if err != nil {
		return
	}
	object = readGoogleIdentityProvider(iterator)
	err = iterator.Error
	return
}

// readGoogleIdentityProvider reads a value of the 'google_identity_provider' type from the given iterator.
func readGoogleIdentityProvider(iterator *jsoniter.Iterator) *GoogleIdentityProvider {
	object := &GoogleIdentityProvider{}
	for {
		field := iterator.ReadObject()
		if field == "" {
			break
		}
		switch field {
		case "client_id":
			value := iterator.ReadString()
			object.clientID = &value
		case "client_secret":
			value := iterator.ReadString()
			object.clientSecret = &value
		case "hosted_domain":
			value := iterator.ReadString()
			object.hostedDomain = &value
		default:
			iterator.ReadAny()
		}
	}
	return object
}
