// Code generated by go-swagger; DO NOT EDIT.

package installer

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/openshift/assisted-service/models"
)

// UpdateClusterLogsProgressReader is a Reader for the UpdateClusterLogsProgress structure.
type UpdateClusterLogsProgressReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *UpdateClusterLogsProgressReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 204:
		result := NewUpdateClusterLogsProgressNoContent()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 401:
		result := NewUpdateClusterLogsProgressUnauthorized()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewUpdateClusterLogsProgressForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 404:
		result := NewUpdateClusterLogsProgressNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 405:
		result := NewUpdateClusterLogsProgressMethodNotAllowed()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 409:
		result := NewUpdateClusterLogsProgressConflict()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewUpdateClusterLogsProgressInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 503:
		result := NewUpdateClusterLogsProgressServiceUnavailable()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result

	default:
		return nil, runtime.NewAPIError("response status code does not match any response statuses defined for this endpoint in the swagger spec", response, response.Code())
	}
}

// NewUpdateClusterLogsProgressNoContent creates a UpdateClusterLogsProgressNoContent with default headers values
func NewUpdateClusterLogsProgressNoContent() *UpdateClusterLogsProgressNoContent {
	return &UpdateClusterLogsProgressNoContent{}
}

/*UpdateClusterLogsProgressNoContent handles this case with default header values.

Update cluster install progress.
*/
type UpdateClusterLogsProgressNoContent struct {
}

func (o *UpdateClusterLogsProgressNoContent) Error() string {
	return fmt.Sprintf("[PUT /clusters/{cluster_id}/logs_progress][%d] updateClusterLogsProgressNoContent ", 204)
}

func (o *UpdateClusterLogsProgressNoContent) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewUpdateClusterLogsProgressUnauthorized creates a UpdateClusterLogsProgressUnauthorized with default headers values
func NewUpdateClusterLogsProgressUnauthorized() *UpdateClusterLogsProgressUnauthorized {
	return &UpdateClusterLogsProgressUnauthorized{}
}

/*UpdateClusterLogsProgressUnauthorized handles this case with default header values.

Unauthorized.
*/
type UpdateClusterLogsProgressUnauthorized struct {
	Payload *models.InfraError
}

func (o *UpdateClusterLogsProgressUnauthorized) Error() string {
	return fmt.Sprintf("[PUT /clusters/{cluster_id}/logs_progress][%d] updateClusterLogsProgressUnauthorized  %+v", 401, o.Payload)
}

func (o *UpdateClusterLogsProgressUnauthorized) GetPayload() *models.InfraError {
	return o.Payload
}

func (o *UpdateClusterLogsProgressUnauthorized) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.InfraError)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUpdateClusterLogsProgressForbidden creates a UpdateClusterLogsProgressForbidden with default headers values
func NewUpdateClusterLogsProgressForbidden() *UpdateClusterLogsProgressForbidden {
	return &UpdateClusterLogsProgressForbidden{}
}

/*UpdateClusterLogsProgressForbidden handles this case with default header values.

Forbidden.
*/
type UpdateClusterLogsProgressForbidden struct {
	Payload *models.InfraError
}

func (o *UpdateClusterLogsProgressForbidden) Error() string {
	return fmt.Sprintf("[PUT /clusters/{cluster_id}/logs_progress][%d] updateClusterLogsProgressForbidden  %+v", 403, o.Payload)
}

func (o *UpdateClusterLogsProgressForbidden) GetPayload() *models.InfraError {
	return o.Payload
}

func (o *UpdateClusterLogsProgressForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.InfraError)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUpdateClusterLogsProgressNotFound creates a UpdateClusterLogsProgressNotFound with default headers values
func NewUpdateClusterLogsProgressNotFound() *UpdateClusterLogsProgressNotFound {
	return &UpdateClusterLogsProgressNotFound{}
}

/*UpdateClusterLogsProgressNotFound handles this case with default header values.

Error.
*/
type UpdateClusterLogsProgressNotFound struct {
	Payload *models.Error
}

func (o *UpdateClusterLogsProgressNotFound) Error() string {
	return fmt.Sprintf("[PUT /clusters/{cluster_id}/logs_progress][%d] updateClusterLogsProgressNotFound  %+v", 404, o.Payload)
}

func (o *UpdateClusterLogsProgressNotFound) GetPayload() *models.Error {
	return o.Payload
}

func (o *UpdateClusterLogsProgressNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Error)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUpdateClusterLogsProgressMethodNotAllowed creates a UpdateClusterLogsProgressMethodNotAllowed with default headers values
func NewUpdateClusterLogsProgressMethodNotAllowed() *UpdateClusterLogsProgressMethodNotAllowed {
	return &UpdateClusterLogsProgressMethodNotAllowed{}
}

/*UpdateClusterLogsProgressMethodNotAllowed handles this case with default header values.

Method Not Allowed.
*/
type UpdateClusterLogsProgressMethodNotAllowed struct {
	Payload *models.Error
}

func (o *UpdateClusterLogsProgressMethodNotAllowed) Error() string {
	return fmt.Sprintf("[PUT /clusters/{cluster_id}/logs_progress][%d] updateClusterLogsProgressMethodNotAllowed  %+v", 405, o.Payload)
}

func (o *UpdateClusterLogsProgressMethodNotAllowed) GetPayload() *models.Error {
	return o.Payload
}

func (o *UpdateClusterLogsProgressMethodNotAllowed) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Error)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUpdateClusterLogsProgressConflict creates a UpdateClusterLogsProgressConflict with default headers values
func NewUpdateClusterLogsProgressConflict() *UpdateClusterLogsProgressConflict {
	return &UpdateClusterLogsProgressConflict{}
}

/*UpdateClusterLogsProgressConflict handles this case with default header values.

Error.
*/
type UpdateClusterLogsProgressConflict struct {
	Payload *models.Error
}

func (o *UpdateClusterLogsProgressConflict) Error() string {
	return fmt.Sprintf("[PUT /clusters/{cluster_id}/logs_progress][%d] updateClusterLogsProgressConflict  %+v", 409, o.Payload)
}

func (o *UpdateClusterLogsProgressConflict) GetPayload() *models.Error {
	return o.Payload
}

func (o *UpdateClusterLogsProgressConflict) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Error)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUpdateClusterLogsProgressInternalServerError creates a UpdateClusterLogsProgressInternalServerError with default headers values
func NewUpdateClusterLogsProgressInternalServerError() *UpdateClusterLogsProgressInternalServerError {
	return &UpdateClusterLogsProgressInternalServerError{}
}

/*UpdateClusterLogsProgressInternalServerError handles this case with default header values.

Error.
*/
type UpdateClusterLogsProgressInternalServerError struct {
	Payload *models.Error
}

func (o *UpdateClusterLogsProgressInternalServerError) Error() string {
	return fmt.Sprintf("[PUT /clusters/{cluster_id}/logs_progress][%d] updateClusterLogsProgressInternalServerError  %+v", 500, o.Payload)
}

func (o *UpdateClusterLogsProgressInternalServerError) GetPayload() *models.Error {
	return o.Payload
}

func (o *UpdateClusterLogsProgressInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Error)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUpdateClusterLogsProgressServiceUnavailable creates a UpdateClusterLogsProgressServiceUnavailable with default headers values
func NewUpdateClusterLogsProgressServiceUnavailable() *UpdateClusterLogsProgressServiceUnavailable {
	return &UpdateClusterLogsProgressServiceUnavailable{}
}

/*UpdateClusterLogsProgressServiceUnavailable handles this case with default header values.

Unavailable.
*/
type UpdateClusterLogsProgressServiceUnavailable struct {
	Payload *models.Error
}

func (o *UpdateClusterLogsProgressServiceUnavailable) Error() string {
	return fmt.Sprintf("[PUT /clusters/{cluster_id}/logs_progress][%d] updateClusterLogsProgressServiceUnavailable  %+v", 503, o.Payload)
}

func (o *UpdateClusterLogsProgressServiceUnavailable) GetPayload() *models.Error {
	return o.Payload
}

func (o *UpdateClusterLogsProgressServiceUnavailable) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Error)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
