// Code generated by go-swagger; DO NOT EDIT.

package installer

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
)

// NewUploadHostLogsParams creates a new UploadHostLogsParams object
// with the default values initialized.
func NewUploadHostLogsParams() *UploadHostLogsParams {
	var ()
	return &UploadHostLogsParams{

		timeout: cr.DefaultTimeout,
	}
}

// NewUploadHostLogsParamsWithTimeout creates a new UploadHostLogsParams object
// with the default values initialized, and the ability to set a timeout on a request
func NewUploadHostLogsParamsWithTimeout(timeout time.Duration) *UploadHostLogsParams {
	var ()
	return &UploadHostLogsParams{

		timeout: timeout,
	}
}

// NewUploadHostLogsParamsWithContext creates a new UploadHostLogsParams object
// with the default values initialized, and the ability to set a context for a request
func NewUploadHostLogsParamsWithContext(ctx context.Context) *UploadHostLogsParams {
	var ()
	return &UploadHostLogsParams{

		Context: ctx,
	}
}

// NewUploadHostLogsParamsWithHTTPClient creates a new UploadHostLogsParams object
// with the default values initialized, and the ability to set a custom HTTPClient for a request
func NewUploadHostLogsParamsWithHTTPClient(client *http.Client) *UploadHostLogsParams {
	var ()
	return &UploadHostLogsParams{
		HTTPClient: client,
	}
}

/*UploadHostLogsParams contains all the parameters to send to the API endpoint
for the upload host logs operation typically these are written to a http.Request
*/
type UploadHostLogsParams struct {

	/*ClusterID
	  The cluster of the host whose logs should be uploaded.

	*/
	ClusterID strfmt.UUID
	/*DiscoveryAgentVersion
	  The software version of the discovery agent that is uploading the logs.

	*/
	DiscoveryAgentVersion *string
	/*HostID
	  The host whose logs should be uploaded.

	*/
	HostID strfmt.UUID
	/*Upfile
	  The log file to be uploaded.

	*/
	Upfile runtime.NamedReadCloser

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithTimeout adds the timeout to the upload host logs params
func (o *UploadHostLogsParams) WithTimeout(timeout time.Duration) *UploadHostLogsParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the upload host logs params
func (o *UploadHostLogsParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the upload host logs params
func (o *UploadHostLogsParams) WithContext(ctx context.Context) *UploadHostLogsParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the upload host logs params
func (o *UploadHostLogsParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the upload host logs params
func (o *UploadHostLogsParams) WithHTTPClient(client *http.Client) *UploadHostLogsParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the upload host logs params
func (o *UploadHostLogsParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithClusterID adds the clusterID to the upload host logs params
func (o *UploadHostLogsParams) WithClusterID(clusterID strfmt.UUID) *UploadHostLogsParams {
	o.SetClusterID(clusterID)
	return o
}

// SetClusterID adds the clusterId to the upload host logs params
func (o *UploadHostLogsParams) SetClusterID(clusterID strfmt.UUID) {
	o.ClusterID = clusterID
}

// WithDiscoveryAgentVersion adds the discoveryAgentVersion to the upload host logs params
func (o *UploadHostLogsParams) WithDiscoveryAgentVersion(discoveryAgentVersion *string) *UploadHostLogsParams {
	o.SetDiscoveryAgentVersion(discoveryAgentVersion)
	return o
}

// SetDiscoveryAgentVersion adds the discoveryAgentVersion to the upload host logs params
func (o *UploadHostLogsParams) SetDiscoveryAgentVersion(discoveryAgentVersion *string) {
	o.DiscoveryAgentVersion = discoveryAgentVersion
}

// WithHostID adds the hostID to the upload host logs params
func (o *UploadHostLogsParams) WithHostID(hostID strfmt.UUID) *UploadHostLogsParams {
	o.SetHostID(hostID)
	return o
}

// SetHostID adds the hostId to the upload host logs params
func (o *UploadHostLogsParams) SetHostID(hostID strfmt.UUID) {
	o.HostID = hostID
}

// WithUpfile adds the upfile to the upload host logs params
func (o *UploadHostLogsParams) WithUpfile(upfile runtime.NamedReadCloser) *UploadHostLogsParams {
	o.SetUpfile(upfile)
	return o
}

// SetUpfile adds the upfile to the upload host logs params
func (o *UploadHostLogsParams) SetUpfile(upfile runtime.NamedReadCloser) {
	o.Upfile = upfile
}

// WriteToRequest writes these params to a swagger request
func (o *UploadHostLogsParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param cluster_id
	if err := r.SetPathParam("cluster_id", o.ClusterID.String()); err != nil {
		return err
	}

	if o.DiscoveryAgentVersion != nil {

		// header param discovery_agent_version
		if err := r.SetHeaderParam("discovery_agent_version", *o.DiscoveryAgentVersion); err != nil {
			return err
		}

	}

	// path param host_id
	if err := r.SetPathParam("host_id", o.HostID.String()); err != nil {
		return err
	}

	if o.Upfile != nil {

		if o.Upfile != nil {

			// form file param upfile
			if err := r.SetFileParam("upfile", o.Upfile); err != nil {
				return err
			}

		}

	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
