// Code generated by go-swagger; DO NOT EDIT.

package manifests

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"

	"github.com/openshift/assisted-service/models"
)

// NewCreateClusterManifestParams creates a new CreateClusterManifestParams object
// with the default values initialized.
func NewCreateClusterManifestParams() *CreateClusterManifestParams {
	var ()
	return &CreateClusterManifestParams{

		timeout: cr.DefaultTimeout,
	}
}

// NewCreateClusterManifestParamsWithTimeout creates a new CreateClusterManifestParams object
// with the default values initialized, and the ability to set a timeout on a request
func NewCreateClusterManifestParamsWithTimeout(timeout time.Duration) *CreateClusterManifestParams {
	var ()
	return &CreateClusterManifestParams{

		timeout: timeout,
	}
}

// NewCreateClusterManifestParamsWithContext creates a new CreateClusterManifestParams object
// with the default values initialized, and the ability to set a context for a request
func NewCreateClusterManifestParamsWithContext(ctx context.Context) *CreateClusterManifestParams {
	var ()
	return &CreateClusterManifestParams{

		Context: ctx,
	}
}

// NewCreateClusterManifestParamsWithHTTPClient creates a new CreateClusterManifestParams object
// with the default values initialized, and the ability to set a custom HTTPClient for a request
func NewCreateClusterManifestParamsWithHTTPClient(client *http.Client) *CreateClusterManifestParams {
	var ()
	return &CreateClusterManifestParams{
		HTTPClient: client,
	}
}

/*CreateClusterManifestParams contains all the parameters to send to the API endpoint
for the create cluster manifest operation typically these are written to a http.Request
*/
type CreateClusterManifestParams struct {

	/*CreateManifestParams
	  The new manifest to create.

	*/
	CreateManifestParams *models.CreateManifestParams
	/*ClusterID
	  The cluster for which a new manifest should be created.

	*/
	ClusterID strfmt.UUID

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithTimeout adds the timeout to the create cluster manifest params
func (o *CreateClusterManifestParams) WithTimeout(timeout time.Duration) *CreateClusterManifestParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the create cluster manifest params
func (o *CreateClusterManifestParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the create cluster manifest params
func (o *CreateClusterManifestParams) WithContext(ctx context.Context) *CreateClusterManifestParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the create cluster manifest params
func (o *CreateClusterManifestParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the create cluster manifest params
func (o *CreateClusterManifestParams) WithHTTPClient(client *http.Client) *CreateClusterManifestParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the create cluster manifest params
func (o *CreateClusterManifestParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithCreateManifestParams adds the createManifestParams to the create cluster manifest params
func (o *CreateClusterManifestParams) WithCreateManifestParams(createManifestParams *models.CreateManifestParams) *CreateClusterManifestParams {
	o.SetCreateManifestParams(createManifestParams)
	return o
}

// SetCreateManifestParams adds the createManifestParams to the create cluster manifest params
func (o *CreateClusterManifestParams) SetCreateManifestParams(createManifestParams *models.CreateManifestParams) {
	o.CreateManifestParams = createManifestParams
}

// WithClusterID adds the clusterID to the create cluster manifest params
func (o *CreateClusterManifestParams) WithClusterID(clusterID strfmt.UUID) *CreateClusterManifestParams {
	o.SetClusterID(clusterID)
	return o
}

// SetClusterID adds the clusterId to the create cluster manifest params
func (o *CreateClusterManifestParams) SetClusterID(clusterID strfmt.UUID) {
	o.ClusterID = clusterID
}

// WriteToRequest writes these params to a swagger request
func (o *CreateClusterManifestParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.CreateManifestParams != nil {
		if err := r.SetBodyParam(o.CreateManifestParams); err != nil {
			return err
		}
	}

	// path param cluster_id
	if err := r.SetPathParam("cluster_id", o.ClusterID.String()); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
